/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.service.position;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.db.DBRoute;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hrmp.hbpm.business.service.position.IPositionTplApplicationScopeService;

public class PositionTplApplicationScopeServiceImpl
implements IPositionTplApplicationScopeService {
    @Override
    public List<Long> queryApplicationScope(Long adminorgId, String longStructNumber) {
        String queryAdminScopeSql = "select fid,fadminorgid,fcontainssubordinate from t_hbpm_applicationscope";
        List<Long> matchScopePositionTplIdList = this.getMatchScopePositionTplIdList("fadminorgid", "fcontainssubordinate", queryAdminScopeSql, "t_hbpm_applicationscope", longStructNumber);
        String queryExceptionAdminScopeSql = "select fid,fexceptionadminorgid,fexcontainssubordinate from t_hbpm_exceptionscope";
        List<Long> matchExScopePositionTplIdList = this.getMatchScopePositionTplIdList("fexceptionadminorgid", "fexcontainssubordinate", queryExceptionAdminScopeSql, "t_hbpm_exceptionscope", longStructNumber);
        matchScopePositionTplIdList.removeAll(matchExScopePositionTplIdList);
        return matchScopePositionTplIdList;
    }

    @Override
    public List<Long> getSubOrgId(Long orgId) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber("21");
        param.setId(orgId.longValue());
        List rootInfoMap = OrgUnitServiceHelper.getTreeChildrenMap((OrgTreeParam)param);
        List<Long> buId = rootInfoMap.stream().map(temp -> temp.getOrDefault("id", 0L)).collect(Collectors.toList());
        buId.add(orgId);
        return buId;
    }

    @Override
    public boolean contansApplicationScope(Long positionTplId, Long adminorgId, String longStructNumber) {
        List<Long> longs = this.queryApplicationScope(adminorgId, longStructNumber);
        return longs.contains(positionTplId);
    }

    private List<Long> getMatchScopePositionTplIdList(String scopeAdminField, String containssubordinateField, String sql, String tableName, String longStructNumber) {
        ArrayList result = new ArrayList();
        ArrayList adminorgIdList = new ArrayList();
        try (DataSet rs = HRDBUtil.queryDataSet((String)tableName, (DBRoute)new DBRoute("hr"), (String)sql, (Object[])new Object[0]);){
            rs.forEach(data -> {
                HashMap<String, Constable> dataMap = new HashMap<String, Constable>(8);
                dataMap.put("id", data.getLong("fid"));
                dataMap.put("adminorg", data.getLong(scopeAdminField));
                dataMap.put("containssubordinate", data.getBoolean(containssubordinateField));
                adminorgIdList.add(data.getLong(scopeAdminField));
                result.add(dataMap);
            });
        }
        Map structReuslt = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgStructQueryService", (String)"adminOrgStructQuery", (Object[])new Object[]{adminorgIdList, new Date(), true});
        HashMap adminorgIdToLongnumberMap = new HashMap();
        structReuslt.forEach((key, value) -> {
            String longnumber = value.getOrDefault("longnumber", "");
            adminorgIdToLongnumberMap.put(key, longnumber);
        });
        ArrayList<Long> matchTplIds = new ArrayList<Long>(16);
        result.forEach(temp -> {
            long id = (Long)temp.get("id");
            String adminorgId = String.valueOf(temp.get("adminorg"));
            boolean isContainssubordinate = (Boolean)temp.get("containssubordinate");
            String longnumber = adminorgIdToLongnumberMap.getOrDefault(adminorgId, "");
            if (isContainssubordinate) {
                if (longStructNumber.contains(longnumber)) {
                    matchTplIds.add(id);
                }
            } else if (longStructNumber.equals(longnumber)) {
                matchTplIds.add(id);
            }
        });
        return matchTplIds;
    }
}

