/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.service.position;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.application.impl.position.DarkPositionApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionTplFieldRepository;
import kd.hrmp.hbpm.business.utils.DynamicConvertUtils;
import kd.hrmp.hbpm.business.utils.SystemParamHelper;
import kd.hrmp.hbpm.common.constants.JobLevelGradeTextEnum;

public class PositionTplChangeSyncPosService {
    private static final Log LOG = LogFactory.getLog(PositionTplChangeSyncPosService.class);
    private static final String SPECIAL_TEXTCOL_JOBGRADERANGE = "jobgraderange";
    private static final String SPECIAL_TEXTCOL_JOBlEVELRANGE = "joblevelrange";
    private static final String SPECIAL_BIZCOL_POSITIONTYPE = "positiontype";
    private Map<Long, DynamicObject> oldDynMap;

    public PositionTplChangeSyncPosService(Map<Long, DynamicObject> oldDynMap) {
        this.oldDynMap = oldDynMap;
    }

    public void syncUpdatePosition(DynamicObject[] positionTpls) {
        LOG.info("PositionTplChangeSyncPosService-start");
        if (ObjectUtils.isEmpty(this.oldDynMap)) {
            LOG.info("PositionTplChangeSyncPosService_end addnew_scene");
            return;
        }
        List<String> positiontplfields = PositionTplFieldRepository.getInstance().queryAllNumberListNew();
        Map<Long, DynamicObject> tplIdToDynMap = this.getToHandleTplDataMap(positionTpls, positiontplfields);
        Set<Long> tplIdSet = tplIdToDynMap.keySet();
        if (tplIdSet.size() == 0) {
            LOG.info("PositionTplChangeSyncPosService_end, tplsize = 0");
            return;
        }
        DynamicObject[] positions = PositionQueryRepository.getInstance().queryPositionByTplId(tplIdSet);
        DynamicObject[] initPositions = PositionQueryRepository.getInstance().queryInitPositionByTplId(tplIdSet);
        if (positions.length == 0 && initPositions.length == 0) {
            LOG.info("PositionTplChangeSyncPosService_end, posSize = 0");
            return;
        }
        Map<Long, List<DynamicObject>> tplPositionMap = Arrays.stream(positions).collect(Collectors.groupingBy(dyn -> dyn.getLong("positiontpl.id")));
        Map<Long, List<DynamicObject>> tplInitPositions = Arrays.stream(initPositions).collect(Collectors.groupingBy(dyn -> dyn.getLong("positiontpl.id")));
        ArrayList toChangePosList = Lists.newArrayListWithExpectedSize((int)positions.length);
        ArrayList toChangeFuturePosList = Lists.newArrayListWithExpectedSize((int)positions.length);
        ArrayList toUpdatePosList = Lists.newArrayListWithExpectedSize((int)positions.length);
        Date now = HRDateTimeUtils.getNowDate();
        tplIdToDynMap.forEach((tplId, tpl) -> {
            List positionList = tplPositionMap.getOrDefault(tplId, new ArrayList());
            List initPositionList = tplInitPositions.getOrDefault(tplId, new ArrayList());
            List<String> numberList = this.getToFixFields((DynamicObject)tpl, positiontplfields);
            for (DynamicObject pos : positionList) {
                if (HRStringUtils.equals((String)pos.getString("datastatus"), (String)"0") && HRDateTimeUtils.dayBefore((Date)pos.getDate("bsed"), (Date)now)) continue;
                this.setTplValueToPos((DynamicObject)tpl, pos, numberList);
                if (HRStringUtils.equals((String)pos.getString("datastatus"), (String)"1") && !HRDateTimeUtils.dayBefore((Date)pos.getDate("bsled"), (Date)now)) {
                    pos.set("bsed", (Object)now);
                }
                pos.set("changetype", (Object)1020L);
                pos.set("sourcevid", (Object)pos.getLong("id"));
                if (HRStringUtils.equals((String)pos.getString("datastatus"), (String)"1")) {
                    toChangePosList.add(pos);
                    continue;
                }
                toChangeFuturePosList.add(pos);
            }
            for (DynamicObject pos : initPositionList) {
                this.setTplValueToPos((DynamicObject)tpl, pos, numberList);
                toUpdatePosList.add(pos);
            }
        });
        PositionServiceApplicationImpl application = new PositionServiceApplicationImpl();
        if (toUpdatePosList.size() > 0) {
            application.modifyInitingPosData(toUpdatePosList);
        }
        if (toChangeFuturePosList.size() > 0) {
            application.changePosition(toChangeFuturePosList, false);
        }
        if (toChangePosList.size() > 0) {
            DynamicObject[] hisVersions = application.changePosition(toChangePosList, true);
            if (positiontplfields.contains("isleader")) {
                new DarkPositionApplicationImpl().maintainDarkPositionRelation(Arrays.asList(hisVersions), true, true);
            }
        }
        LOG.info("PositionTplChangeSyncPosService_end");
    }

    private void setTplValueToPos(DynamicObject tpl, DynamicObject pos, List<String> numberList) {
        for (String number : numberList) {
            if (HRStringUtils.equals((String)number, (String)SPECIAL_BIZCOL_POSITIONTYPE) && tpl.getDynamicObject(SPECIAL_BIZCOL_POSITIONTYPE) == null || !tpl.containsProperty(number) || !pos.containsProperty(number)) continue;
            pos.set(number, tpl.get(number));
        }
    }

    private Map<Long, DynamicObject> getToHandleTplDataMap(DynamicObject[] positionTpls, List<String> positiontplfields) {
        List<Long> buIdList = Arrays.stream(positionTpls).map(dyn -> dyn.getLong("org.id")).collect(Collectors.toList());
        Map<String, Map<String, Object>> batchParameter = SystemParamHelper.getBatchParameter(buIdList);
        HashMap tplIdToDynMap = Maps.newHashMapWithExpectedSize((int)positionTpls.length);
        DynamicConvertUtils dynamicCompareUtils = new DynamicConvertUtils(null);
        for (DynamicObject dyn2 : positionTpls) {
            String orgId;
            Map parameterMap;
            boolean openTplChangePos;
            long id = dyn2.getLong("id");
            DynamicObject oldDyn = this.oldDynMap.get(id);
            if (oldDyn == null || !(openTplChangePos = (parameterMap = (Map)batchParameter.getOrDefault(orgId = dyn2.getString("org.id"), new HashMap())).getOrDefault("positiontplchangepos", false).booleanValue())) continue;
            List<DynamicConvertUtils.CompareResult> compareResults = dynamicCompareUtils.compareAndGetAllDiffCol(dyn2, oldDyn);
            List changedFields = compareResults.stream().filter(r -> !r.isSame()).map(r -> r.getPropKey()).collect(Collectors.toList());
            List<String> toFixFields = this.getToFixFields(dyn2, positiontplfields);
            changedFields.retainAll(toFixFields);
            if (changedFields.contains(SPECIAL_BIZCOL_POSITIONTYPE) && dyn2.getDynamicObject(SPECIAL_BIZCOL_POSITIONTYPE) == null) {
                changedFields.remove(SPECIAL_BIZCOL_POSITIONTYPE);
            }
            if (changedFields.size() == 0) continue;
            LOG.info("PositionTplChangeSyncPosService_id:{}_changefields:{}", (Object)id, changedFields);
            tplIdToDynMap.put(id, dyn2);
        }
        return tplIdToDynMap;
    }

    private List<String> getToFixFields(DynamicObject tpl, List<String> positiontplfields) {
        List<String> notFillNumberList = this.getNotFillFileds(tpl);
        ArrayList<String> numberList = new ArrayList<String>(positiontplfields);
        numberList.removeAll(notFillNumberList);
        if (numberList.contains(SPECIAL_TEXTCOL_JOBGRADERANGE)) {
            numberList.add(JobLevelGradeTextEnum.GRADE.getLowSign());
            numberList.add(JobLevelGradeTextEnum.GRADE.getHighSign());
        }
        if (numberList.contains(SPECIAL_TEXTCOL_JOBlEVELRANGE)) {
            numberList.add(JobLevelGradeTextEnum.LEVEL.getLowSign());
            numberList.add(JobLevelGradeTextEnum.LEVEL.getHighSign());
        }
        return numberList;
    }

    private List<String> getNotFillFileds(DynamicObject tpl) {
        DynamicObjectCollection fieldrange = tpl.getDynamicObjectCollection("fieldrange");
        if (CollectionUtils.isEmpty((Collection)fieldrange)) {
            return Lists.newArrayListWithExpectedSize((int)8);
        }
        return fieldrange.stream().map(temp -> temp.getString("fbasedataid.number")).collect(Collectors.toList());
    }
}

