/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.service.position;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.domain.repository.position.HisEventRepository;
import kd.hrmp.hbpm.business.domain.repository.position.StandardPositionRepository;
import kd.hrmp.hbpm.common.constants.StandardPositionConstants;

public class StandardPositionCommonService {
    private static final ThreadLocal<Map<String, Object>> threadLocal = ThreadLocal.withInitial(() -> new HashMap(16));
    private static final String SELECT_COIN = "selectCoin";
    private static final String TAG = "JOB_";

    public static DynamicObject copyValueFromJobToStandardPosition(DynamicObject job, DynamicObject std) {
        Long standId = job.getLong("id");
        std.set("id", (Object)standId);
        std.set("masterid", (Object)standId);
        std.set("job", job.get("boid"));
        std.set("job_id", job.get("boid"));
        std.set("createmode", (Object)"3");
        std.set("initstatus", job.get("initstatus"));
        std.set("positiontype", (Object)StandardPositionCommonService.buildPositionToDarkStandardPosition());
        std.set("boid", job.get("boid"));
        StandardPositionCommonService.copyCommonValueFromJobToStandardPosition(job, std);
        StandardPositionCommonService.setHisFieldValue(job, std);
        return std;
    }

    public static void copyValueFromChangeJobToStandardPosition(DynamicObject job, DynamicObject std) {
        Long standId = job.getLong("id");
        std.set("id", (Object)standId);
        std.set("masterid", (Object)standId);
        std.set("job", job.get("boid"));
        std.set("job_id", job.get("boid"));
        std.set("createmode", (Object)"3");
        std.set("initstatus", job.get("initstatus"));
        std.set("boid", job.get("boid"));
        StandardPositionCommonService.copyCommonValueFromJobToStandardPosition(job, std);
        std.set("bsed", job.get("bsed"));
        std.set("bsled", job.get("bsled"));
        std.set("sourcevid", job.get("sourcevid"));
        std.set("firstbsed", job.get("firstbsed"));
        std.set("changebsed", job.get("changebsed"));
        std.set("bred", job.get("bred"));
        std.set("brled", job.get("brled"));
        std.set("changedescription", job.get("changedescription"));
        std.set("datastatus", job.get("datastatus"));
    }

    public static void copyCommonValueFromJobToStandardPosition(DynamicObject job, DynamicObject std) {
        std.set("number", (Object)(TAG + job.get("number")));
        std.set("name", job.get("name"));
        std.set("ctrlstrategy", job.get("ctrlstrategy"));
        std.set("jobscm", job.get("jobscm"));
        std.set("lowjoblevel", job.get("lowjoblevel"));
        std.set("highjoblevel", job.get("highjoblevel"));
        std.set("lowjobgrade", job.get("lowjobgrade"));
        std.set("highjobgrade", job.get("highjobgrade"));
        std.set("status", job.get("status"));
        std.set("enable", job.get("enable"));
        std.set("createtime", job.get("createtime"));
        std.set("modifytime", job.get("modifytime"));
        std.set("creator", job.get("creator"));
        std.set("modifier", job.get("modifier"));
        std.set("createorg", job.get("createorg"));
        std.set("org", job.get("org"));
        std.set("useorg", job.get("useorg"));
        std.set("orgdesignbu", job.get("createorg"));
        std.set("description", job.get("description"));
        std.set("disabler", job.get("disabler"));
        std.set("disabledate", job.get("disabledate"));
    }

    public static void setHisFieldValue(DynamicObject job, DynamicObject std) {
        std.set("bsed", job.get("bsed"));
        std.set("bsled", job.get("bsled"));
        std.set("iscurrentversion", job.get("iscurrentversion"));
        std.set("sourcevid", job.get("sourcevid"));
        std.set("ismodify", job.get("ismodify"));
        std.set("firstbsed", job.get("firstbsed"));
        std.set("changebsed", job.get("changebsed"));
        std.set("bred", job.get("bred"));
        std.set("brled", job.get("brled"));
        std.set("changedescription", job.get("changedescription"));
        std.set("hisversion", job.get("hisversion"));
        std.set("datastatus", job.get("datastatus"));
    }

    public static void copyHisEventFromJobToPosition(DynamicObject jobHisEvent, DynamicObject positionHisEvent) {
        positionHisEvent.set("id", jobHisEvent.get("id"));
        positionHisEvent.set("creator", jobHisEvent.get("creator"));
        positionHisEvent.set("createtime", jobHisEvent.get("createtime"));
        positionHisEvent.set("modifier", jobHisEvent.get("modifier"));
        positionHisEvent.set("modifytime", jobHisEvent.get("modifytime"));
        positionHisEvent.set("initstatus", jobHisEvent.get("initstatus"));
        positionHisEvent.set("vid", jobHisEvent.get("vid"));
        positionHisEvent.set("prestatus", jobHisEvent.get("prestatus"));
        positionHisEvent.set("prebsed", jobHisEvent.get("prebsed"));
        positionHisEvent.set("prebsled", jobHisEvent.get("prebsled"));
        positionHisEvent.set("busievent", jobHisEvent.get("busievent"));
    }

    public static void copyBizEventFromJobToPosition(DynamicObject jobBizEvent, DynamicObject positionBizEvent) {
        positionBizEvent.set("id", jobBizEvent.get("id"));
        positionBizEvent.set("creator", jobBizEvent.get("creator"));
        positionBizEvent.set("createtime", jobBizEvent.get("createtime"));
        positionBizEvent.set("modifier", jobBizEvent.get("modifier"));
        positionBizEvent.set("modifytime", jobBizEvent.get("modifytime"));
        positionBizEvent.set("initstatus", jobBizEvent.get("initstatus"));
        positionBizEvent.set("boid", jobBizEvent.get("boid"));
        positionBizEvent.set("isbusinesseventbo", jobBizEvent.get("isbusinesseventbo"));
        positionBizEvent.set("status", jobBizEvent.get("status"));
        positionBizEvent.set("canceledeventid", jobBizEvent.get("canceledeventid"));
        positionBizEvent.set("operateuser", jobBizEvent.get("operateuser"));
        positionBizEvent.set("operatedate", jobBizEvent.get("operatedate"));
        positionBizEvent.set("event", jobBizEvent.get("event"));
        positionBizEvent.set("sourceentity", (Object)"hbpm_stposition");
    }

    public static void copyEventFromJobToPosition(DynamicObject jobEvent, DynamicObject positionEvent) {
        positionEvent.set("id", jobEvent.get("id"));
        positionEvent.set("creator", jobEvent.get("creator"));
        positionEvent.set("createtime", jobEvent.get("createtime"));
        positionEvent.set("modifier", jobEvent.get("modifier"));
        positionEvent.set("modifytime", jobEvent.get("modifytime"));
        positionEvent.set("initstatus", jobEvent.get("initstatus"));
        positionEvent.set("eventtype", jobEvent.get("eventtype"));
        positionEvent.set("executeway", jobEvent.get("executeway"));
        positionEvent.set("status", jobEvent.get("status"));
        positionEvent.set("eventbatchtype", jobEvent.get("eventbatchtype"));
        positionEvent.set("canceledeventid", jobEvent.get("canceledeventid"));
        positionEvent.set("operateuser", jobEvent.get("operateuser"));
        positionEvent.set("operatedate", jobEvent.get("operatedate"));
    }

    private static DynamicObject buildPositionToDarkStandardPosition() {
        Map<String, Object> data = threadLocal.get();
        if (ObjectUtils.isEmpty(data) || ObjectUtils.isEmpty((Object)data.get(SELECT_COIN)) || HRStringUtils.equals((String)"false", (String)String.valueOf(data.get(SELECT_COIN)))) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_positiontype");
            DynamicObject positionType = serviceHelper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)StandardPositionConstants.POSITION_TYPE_JOB)});
            data = new HashMap<String, Object>(16);
            data.put(SELECT_COIN, "true");
            data.put("positiontype", positionType);
        }
        return (DynamicObject)data.get("positiontype");
    }

    public static DynamicObject[] batchHisVersionFirstChange(DynamicObject[] dyns) {
        StandardPositionRepository.getInstance().saveBatch(Arrays.asList(dyns));
        return dyns;
    }

    public static void buildAndSaveStandardPositionHisEventInfo(DynamicObject[] hisEvent_datas) {
        if (ObjectUtils.isEmpty((Object[])hisEvent_datas)) {
            return;
        }
        List<DynamicObject> standHisEvent = HisEventRepository.getInstance().generateEmptyObject("hbpm_poshisevent", hisEvent_datas.length);
        for (int index = 0; index < hisEvent_datas.length; ++index) {
            DynamicObject standardHisEvent = standHisEvent.get(index);
            DynamicObject jobHisEvent = hisEvent_datas[index];
            StandardPositionCommonService.copyHisEventFromJobToPosition(jobHisEvent, standardHisEvent);
        }
        HisEventRepository.getInstance().saveBatch("hbpm_poshisevent", standHisEvent);
    }

    public static void buildAndSaveStandardPositionBizEventInfo(DynamicObject[] bizvent_datas) {
        if (ObjectUtils.isEmpty((Object[])bizvent_datas)) {
            return;
        }
        List<DynamicObject> standBizEvenst = HisEventRepository.getInstance().generateEmptyObject("hbpm_posbizevent", bizvent_datas.length);
        for (int index = 0; index < bizvent_datas.length; ++index) {
            DynamicObject standardBizEvent = standBizEvenst.get(index);
            DynamicObject jobBizEvent = bizvent_datas[index];
            StandardPositionCommonService.copyBizEventFromJobToPosition(jobBizEvent, standardBizEvent);
        }
        HisEventRepository.getInstance().saveBatch("hbpm_posbizevent", standBizEvenst);
    }

    public static void buildAndSaveStandardPositionEventInfo(DynamicObject[] event_datas) {
        if (ObjectUtils.isEmpty((Object[])event_datas)) {
            return;
        }
        List<Long> ids = Arrays.stream(event_datas).map(data -> data.getLong("id")).collect(Collectors.toList());
        Object[] hasData = HisEventRepository.getInstance().getEventDataByIds("hbpm_posevent", ids);
        List<Object> dealData = new ArrayList(event_datas.length);
        if (!ObjectUtils.isEmpty((Object[])hasData)) {
            Set hasDataIds = Arrays.stream(hasData).map(data -> data.getLong("id")).collect(Collectors.toSet());
            dealData = Arrays.stream(event_datas).filter(data -> !hasDataIds.contains(data.getLong("id"))).collect(Collectors.toList());
        } else {
            dealData = Arrays.asList(event_datas);
        }
        if (!ObjectUtils.isEmpty(dealData)) {
            List<DynamicObject> standEvents = HisEventRepository.getInstance().generateEmptyObject("hbpm_posevent", dealData.size());
            for (int index = 0; index < dealData.size(); ++index) {
                DynamicObject standardEvent = standEvents.get(index);
                DynamicObject jobEvent = (DynamicObject)dealData.get(index);
                StandardPositionCommonService.copyEventFromJobToPosition(jobEvent, standardEvent);
            }
            HisEventRepository.getInstance().saveBatch("hbpm_posevent", standEvents);
        }
    }

    public static DynamicObject[] batchHisVersionChange(DynamicObject[] dyns) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEntityNumber("hbpm_stposition");
        hisVersionParamBo.setHisDyns(dyns);
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        HisResponse versionChangeRespDataHisResponse = HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
        DynamicObject[] newDynamicObjects = ((VersionChangeRespData)versionChangeRespDataHisResponse.getData()).getNewDynamicObjects();
        return newDynamicObjects;
    }
}

