/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.service.position;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.init.AbstractInitDomainDataService;
import kd.hrmp.hbpm.business.application.impl.position.PositionInitServiceApplication;
import org.apache.commons.lang3.StringUtils;

public class StandardPositionInitServiceImpl
extends AbstractInitDomainDataService {
    private static Log LOG = LogFactory.getLog(StandardPositionInitServiceImpl.class);
    private Map<String, Object> result;
    private Map<Object, Set<Long>> idMapping;
    private List<DynamicObject> entityDycList;

    public void validate() {
        this.result = this.getInfoWithDynamicObject();
        this.entityDycList = (List)this.result.get("data");
        this.idMapping = (Map)this.result.get("idmapping");
        this.setInitDefalutValue(this.entityDycList);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isInitValidate", "true");
        this.callOp(operateOption);
    }

    public void save() {
        this.result = this.getInfoWithDynamicObject();
        this.entityDycList = (List)this.result.get("data");
        this.idMapping = (Map)this.result.get("idmapping");
        this.setInitDefalutValue(this.entityDycList);
        this.callOp(OperateOption.create());
    }

    private void callOp(OperateOption operateOption) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)this.getInitInParam().getEntityNumber(), (DynamicObject[])this.entityDycList.toArray(new DynamicObject[0]), (OperateOption)operateOption);
        HashMap<Long, Set<String>> errMap = new HashMap<Long, Set<String>>();
        ValidateResultCollection validateResult = result.getValidateResult();
        if (validateResult != null && !CollectionUtils.isEmpty((Collection)validateResult.getValidateErrors())) {
            List errorPkIdList = ((ValidateResult)validateResult.getValidateErrors().get(0)).getAllErrorInfo();
            errorPkIdList.forEach(err -> {
                Long pkValue = (Long)err.getPkValue();
                final String message = err.getMessage();
                if (errMap.containsKey(pkValue)) {
                    ((Set)errMap.get(pkValue)).add(message);
                } else {
                    errMap.put(pkValue, new HashSet<String>(){
                        {
                            this.add(message);
                        }
                    });
                }
            });
        }
        this.buildInitOutParam(errMap);
    }

    private void buildInitOutParam(HashMap<Long, Set<String>> errMap) {
        this.idMapping.forEach((key, val) -> {
            if (!ObjectUtils.isEmpty((Object)val)) {
                if (errMap.containsKey(key)) {
                    val.forEach(midId -> this.getInitOutParam().addErrorMsg(midId, StringUtils.join((Iterable)((Iterable)errMap.get(key)), (String)";")));
                } else {
                    val.forEach(midId -> this.getInitOutParam().addSuccessMsg(midId, key.toString(), ""));
                }
            }
        });
    }

    public void changeStatus() {
        PositionInitServiceApplication application = new PositionInitServiceApplication();
        List<Long> positionIds = application.changeStatus(this.getInitInParam().getEntityNumber(), this.getInitInParam().getBatchNumber(), this.getSourceStatus(), this.getTargetStatus());
        this.getInitOutParam().getHandleIdSet().addAll(positionIds);
    }

    public void rollback() {
        PositionInitServiceApplication application = new PositionInitServiceApplication();
        List<Long> rollbackIds = application.handleRollBack(this.getInitInParam().getEntityNumber(), this.getInitInParam().getBatchNumber(), false);
        this.getInitOutParam().getHandleIdSet().addAll(rollbackIds);
    }
}

