/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.service.position;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;

public class StandardPositionMsgService {
    private static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"StandardPositionMsgServiceThreadpool", (int)1, (int)4);
    private static int MAX_TITLE_LENGTH = 50;

    public static void sendStandardPositionChangeMsg(DynamicObject[] standardPositions) {
        if (ObjectUtils.isEmpty((Object[])standardPositions)) {
            return;
        }
        for (final DynamicObject standardPosition : standardPositions) {
            threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    HRProducerServiceHelper.publishAction(StandardPositionMsgService.buildChangePublishInfo(standardPosition));
                }
            });
        }
    }

    public static void sendStandardPositionDisableMsg(DynamicObject[] standardPositions) {
        if (ObjectUtils.isEmpty((Object[])standardPositions)) {
            return;
        }
        for (final DynamicObject standardPosition : standardPositions) {
            threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    HRProducerServiceHelper.publishAction(StandardPositionMsgService.buildDisablePublishInfo(standardPosition));
                }
            });
        }
    }

    public static Map<String, Object> buildChangePublishInfo(DynamicObject msg) {
        String msgTag = ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d\u53d8\u66f4", (String)"StandardPositionMsgService_3", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
        StringBuilder msgTitle = new StringBuilder();
        msgTitle.append(msgTag);
        String title = String.format(ResManager.loadKDString((String)"\uff08\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%1$s\uff09", (String)"StandardPositionMsgService_2", (String)"hrmp-hbpm-business", (Object[])new Object[0]), msg.get("number"), msg.get("name"));
        if (title.length() > MAX_TITLE_LENGTH) {
            title = title.substring(0, MAX_TITLE_LENGTH);
        }
        msgTitle.append(title);
        HashMap<String, Object> actionInfo = new HashMap<String, Object>();
        actionInfo.put("msgNumber", msg.getString("id"));
        actionInfo.put("senderId", 1L);
        actionInfo.put("sendTime", new Date());
        actionInfo.put("actionId", 1030201L);
        actionInfo.put("msgPubNo", "MP20220826000834");
        actionInfo.put("params", SerializationUtils.serializeToBase64(StandardPositionMsgService.buildStandardChangeMsgParam(msg)));
        actionInfo.put("msgTitle", msgTitle.toString());
        actionInfo.put("msgDesc", ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d\u53d8\u66f4\u901a\u77e5", (String)"StandardPositionMsgService_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        actionInfo.put("msgTag", msgTag);
        return actionInfo;
    }

    public static Map<String, Object> buildDisablePublishInfo(DynamicObject msg) {
        String msgTag = ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d\u7981\u7528", (String)"StandardPositionMsgService_4", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
        StringBuilder msgTitle = new StringBuilder();
        msgTitle.append(msgTag);
        msgTitle.append(String.format(ResManager.loadKDString((String)"\uff08\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%1$s\uff09", (String)"StandardPositionMsgService_2", (String)"hrmp-hbpm-business", (Object[])new Object[0]), msg.get("number"), msg.get("name")));
        HashMap<String, Object> actionInfo = new HashMap<String, Object>();
        actionInfo.put("msgNumber", msg.getString("id"));
        actionInfo.put("senderId", 1L);
        actionInfo.put("sendTime", new Date());
        actionInfo.put("actionId", 1030202L);
        actionInfo.put("msgPubNo", "MP20220826000835");
        actionInfo.put("params", SerializationUtils.serializeToBase64(StandardPositionMsgService.buildStandardDisableMsgParam(msg)));
        actionInfo.put("msgTitle", msgTitle.toString());
        actionInfo.put("msgDesc", ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d\u7981\u7528\u901a\u77e5", (String)"StandardPositionMsgService_1", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        actionInfo.put("msgTag", msgTag);
        return actionInfo;
    }

    public static Map<String, Object> buildStandardChangeMsgParam(DynamicObject dyn) {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("id", dyn.get("id"));
        msg.put("boid", dyn.get("boid"));
        msg.put("id", dyn.get("id"));
        msg.put("number", dyn.get("number"));
        msg.put("name", dyn.get("name"));
        msg.put("modifytime", dyn.get("modifytime"));
        msg.put("enable", dyn.get("enable"));
        return msg;
    }

    public static Map<String, Object> buildStandardDisableMsgParam(DynamicObject dyn) {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("id", dyn.get("id"));
        msg.put("boid", dyn.get("boid"));
        msg.put("number", dyn.get("number"));
        msg.put("name", dyn.get("name"));
        msg.put("modifytime", dyn.get("modifytime"));
        msg.put("enable", dyn.get("enable"));
        return msg;
    }
}

