/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.service.projectrole;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;

public class ProjRoleChangeEvent
implements ProjectRoleConstants {
    private static final String PAGE_EVENT_SUM = "hbpm_rolecheventsum";
    private static final String PAGE_EVENT_DETAIL = "hbpm_rolecheventdetail";
    private static final String PAGE_OP_DETAIL = "hbpm_rolechopdetail";
    private static final String HAOS_PROJ_CHANGE_TYPE = "hbpm_rolechangetype";
    private static final String HAOS_PROJ_CHANGE_OPERATE = "hbpm_rolechangeoperate";
    private Date now;
    private final long creatorId = RequestContext.get().getCurrUserId();
    private String datasource = "";
    private Map<Long, Long> afterVidToBillIdMap;
    private static final String DATASOURCE_POSITION = "10";
    private static final String DATASOURCE_PROJECT_ROLE = "20";
    private static final ProjRoleChangeEvent INSTANCE = new ProjRoleChangeEvent();
    Map<String, String> datasourceEntity = new HashMap<String, String>(){
        static final long serialVersionUID = 1L;
        {
            this.put(ProjRoleChangeEvent.DATASOURCE_POSITION, "hbpm_positionhr");
            this.put(ProjRoleChangeEvent.DATASOURCE_PROJECT_ROLE, "hbpm_projectrolesdetail");
        }
    };

    public static ProjRoleChangeEvent getInstance() {
        return INSTANCE;
    }

    public void handleProRoleEventByHisResponse(HisResponse<VersionChangeRespData> hisResponse, Long changeSceneId, Long changeTypeId, Long changeOperateId, long changeReasonId) {
        if (hisResponse == null) {
            return;
        }
        HashMap<Long, Long> changeTypeIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> changeOperateIdMap = new HashMap<Long, Long>(16);
        ArrayList<DynamicObject> eventDataList = new ArrayList<DynamicObject>(16);
        HashMap<Long, Long> changeSceneMap = new HashMap<Long, Long>(16);
        for (DynamicObject dyn : ((VersionChangeRespData)hisResponse.getData()).getNewDynamicObjects()) {
            Long boId = dyn.getLong("boid");
            changeTypeIdMap.put(boId, changeTypeId);
            changeOperateIdMap.put(boId, changeOperateId);
            eventDataList.add(dyn);
            changeSceneMap.put(boId, changeSceneId);
        }
        ProjRoleChangeEvent.getInstance().handleProRoleEvent(eventDataList, changeSceneMap, null, changeTypeIdMap, changeOperateIdMap, null, null, changeReasonId);
    }

    public void handleProRoleEvent(List<DynamicObject> bizDataList, Map<Long, Long> changeSceneMap, Map<Long, Long> changeSceneSubMap, Map<Long, Long> changeTypeIdMap, Map<Long, Long> changeOperateIdMap, Long oldMainDutyProRoleBoId, Long newMainDutyProRoleBoId, long changeReasonId) {
        ArrayList<DynamicObject> afterDynList = new ArrayList<DynamicObject>(16);
        HRBaseServiceHelper projectRoleHelper = new HRBaseServiceHelper("hbpm_projectroles");
        DynamicObject changeReasonDyn = new HRBaseServiceHelper("hbpm_rolechangereason").generateEmptyDynamicObject();
        HRBaseServiceHelper proRoleChangeTypeHelper = new HRBaseServiceHelper(HAOS_PROJ_CHANGE_TYPE);
        HRBaseServiceHelper proRoleChangeOperateHelper = new HRBaseServiceHelper(HAOS_PROJ_CHANGE_OPERATE);
        HashMap<Long, DynamicObject> beforeMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, Long> newMainDutyEventDetailIdMap = new HashMap<Long, Long>(1);
        Long sourceRoleDetailId = null;
        Long sourceRoleBoId = null;
        if (oldMainDutyProRoleBoId != null && oldMainDutyProRoleBoId != 0L) {
            sourceRoleDetailId = DB.genLongId((String)PAGE_EVENT_DETAIL);
        }
        for (int i = 0; i < bizDataList.size(); ++i) {
            DynamicObject dyn = bizDataList.get(i);
            if (dyn.getBoolean("iscurrentversion")) continue;
            long boId = dyn.getLong("boid");
            long sourceVid = dyn.getLong("sourcevid");
            if (sourceVid > 0L) {
                DynamicObject beforeDyn = projectRoleHelper.generateEmptyDynamicObject();
                beforeDyn.set("id", (Object)dyn.getLong("sourcevid"));
                beforeDyn.set("boid", (Object)dyn.getLong("boid"));
                beforeMap.put(boId, beforeDyn);
            }
            DynamicObject changeTypeDy = proRoleChangeTypeHelper.generateEmptyDynamicObject();
            DynamicObject changeOperationDy = proRoleChangeOperateHelper.generateEmptyDynamicObject();
            changeTypeDy.set("id", (Object)changeTypeIdMap.get(boId));
            changeOperationDy.set("id", (Object)changeOperateIdMap.get(boId));
            changeReasonDyn.set("id", (Object)changeReasonId);
            dyn.set("changeoperate", (Object)changeOperationDy);
            dyn.set("changetype", (Object)changeTypeDy);
            dyn.set("changereason", (Object)changeReasonDyn);
            if (newMainDutyProRoleBoId != null && newMainDutyProRoleBoId == boId && oldMainDutyProRoleBoId != null && oldMainDutyProRoleBoId != 0L) {
                newMainDutyEventDetailIdMap.put(boId, sourceRoleDetailId);
                sourceRoleBoId = boId;
            }
            afterDynList.add(dyn);
        }
        this.saveProRoleEvent(afterDynList, beforeMap, newMainDutyEventDetailIdMap, changeSceneMap, changeSceneSubMap, sourceRoleDetailId, sourceRoleBoId);
    }

    private void saveProRoleEvent(List<DynamicObject> afterDynList, Map<Long, DynamicObject> beforeMap, Map<Long, Long> newMainDutyEventDetailIdMap, Map<Long, Long> changeSceneMap, Map<Long, Long> changeSceneSubMap, Long sourceRoleDetailId, Long sourceRoleBoId) {
        int index = 0;
        ArrayList eventList = Lists.newArrayListWithExpectedSize((int)afterDynList.size());
        ArrayList eventDetailList = Lists.newArrayListWithExpectedSize((int)afterDynList.size());
        ArrayList opDetailList = Lists.newArrayListWithExpectedSize((int)afterDynList.size());
        long[] eventIds = DB.genGlobalLongIds((int)afterDynList.size());
        this.now = new Date();
        for (DynamicObject after : afterDynList) {
            long eventId = eventIds[index++];
            long boId = after.getLong("boid");
            DynamicObject before = beforeMap.get(boId);
            Long changeSceneId = changeSceneMap.get(boId);
            DynamicObject eventSumDyn = this.getEventSum(after, changeSceneId, eventId);
            eventList.add(eventSumDyn);
            Long eventDetailId = newMainDutyEventDetailIdMap.get(boId);
            DynamicObject eventDetail = this.getRoleChEventDetail(after, eventId, eventDetailId, changeSceneId, changeSceneSubMap, sourceRoleDetailId, sourceRoleBoId);
            eventDetailList.add(eventDetail);
            DynamicObject operateDetail = this.handleOpDetail(after, before, eventId, this.datasource);
            opDetailList.add(operateDetail);
        }
        this.saveBatch(PAGE_EVENT_SUM, eventList);
        this.saveBatch(PAGE_EVENT_DETAIL, eventDetailList);
        this.saveBatch(PAGE_OP_DETAIL, opDetailList);
    }

    public static void handleChangeEvent(HisResponse<VersionChangeRespData> hisResponse, long changeType, long changeOperate, Long changeSceneId, Long changeReasonId) {
        if (hisResponse == null) {
            return;
        }
        DynamicObject[] newDynamicObjects = ((VersionChangeRespData)hisResponse.getData()).getNewDynamicObjects();
        DynamicObject[] afterData = (DynamicObject[])Arrays.stream(newDynamicObjects).filter(dyn -> !dyn.getBoolean("iscurrentversion")).toArray(DynamicObject[]::new);
        DynamicObject[] beforeData = ProjRoleChangeEvent.getBeforeDate(afterData);
        ProjRoleChangeEvent.setChange(afterData, changeType, changeOperate, changeReasonId);
        ProjRoleChangeEvent.handleChangeEvent(afterData, beforeData, changeSceneId);
    }

    public static void handleChangeEvent(DynamicObject[] projTeamDy, long changeType, long changeOperate, Long changeSceneId, Long changeReasonId) {
        long sourceVid = projTeamDy[0].getLong("sourcevid");
        HRBaseServiceHelper prjRoleHelper = new HRBaseServiceHelper("hbpm_projectroles");
        DynamicObject hisDyn = prjRoleHelper.queryOne((Object)sourceVid);
        DynamicObject[] hisDynArr = Collections.singletonList(hisDyn).toArray(new DynamicObject[0]);
        ProjRoleChangeEvent.setChange(hisDynArr, changeType, changeOperate, changeReasonId == null ? 0L : changeReasonId);
        ProjRoleChangeEvent.handleChangeEvent(hisDynArr, hisDynArr, changeSceneId);
    }

    private static void handleChangeEvent(DynamicObject[] afterData, DynamicObject[] beforeData, Long changeSceneId) {
        ProjRoleChangeEvent.getInstance().handleChangeEvent(DATASOURCE_PROJECT_ROLE, beforeData, afterData, null, false, changeSceneId);
    }

    private static void setChange(DynamicObject[] afterData, long changeType, long changeOperate, long changeReasonId) {
        DynamicObject changeOperationDy = new HRBaseServiceHelper(HAOS_PROJ_CHANGE_OPERATE).generateEmptyDynamicObject();
        DynamicObject changeReasonDyn = new HRBaseServiceHelper("hbpm_rolechangereason").generateEmptyDynamicObject();
        DynamicObject changeTypeDy = new HRBaseServiceHelper(HAOS_PROJ_CHANGE_TYPE).generateEmptyDynamicObject();
        changeOperationDy.set("id", (Object)changeOperate);
        changeTypeDy.set("id", (Object)changeType);
        changeReasonDyn.set("id", (Object)changeReasonId);
        for (DynamicObject after : afterData) {
            after.set("changeoperate", (Object)changeOperationDy);
            after.set("changetype", (Object)changeTypeDy);
            after.set("changereason", (Object)changeReasonDyn);
        }
    }

    private static DynamicObject[] getBeforeDate(DynamicObject[] afterData) {
        HRBaseServiceHelper projectRoleHelper = new HRBaseServiceHelper("hbpm_projectroles");
        ArrayList<DynamicObject> beforeData = new ArrayList<DynamicObject>(16);
        for (DynamicObject position : afterData) {
            DynamicObject object = projectRoleHelper.generateEmptyDynamicObject();
            object.set("id", (Object)position.getLong("sourcevid"));
            object.set("boid", (Object)position.getLong("boid"));
            beforeData.add(object);
        }
        return beforeData.toArray(new DynamicObject[0]);
    }

    public void handleChangeEvent(String datasource, DynamicObject[] beforeData, DynamicObject[] afterData, Map<Long, Long> afterVidToBillIdMap, boolean isInitSource, Long changeSceneId) {
        if (!this.checkParams(datasource, afterData)) {
            return;
        }
        this.datasource = datasource;
        this.afterVidToBillIdMap = afterVidToBillIdMap;
        Map<Object, Object> beforeMap = beforeData == null ? Maps.newHashMapWithExpectedSize((int)8) : Arrays.stream(beforeData).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("boid"), dynamicObject -> dynamicObject));
        long[] eventIds = DB.genGlobalLongIds((int)afterData.length);
        int index = 0;
        ArrayList eventList = Lists.newArrayListWithExpectedSize((int)afterData.length);
        ArrayList eventDetailList = Lists.newArrayListWithExpectedSize((int)afterData.length);
        ArrayList opDetailList = Lists.newArrayListWithExpectedSize((int)afterData.length);
        this.now = new Date();
        for (DynamicObject after : afterData) {
            long eventId = eventIds[index++];
            long boid = after.getLong("boid");
            DynamicObject before = (DynamicObject)beforeMap.get(boid);
            DynamicObject event = this.handleEventSum(after, before, eventId, changeSceneId);
            eventList.add(event);
            DynamicObject eventDetail = this.handleEventDetail(after, before, eventId, changeSceneId);
            eventDetailList.add(eventDetail);
            DynamicObject operDetail = this.handleOpDetail(after, before, eventId, datasource);
            opDetailList.add(operDetail);
        }
        this.saveBatch(PAGE_EVENT_SUM, eventList);
        this.saveBatch(PAGE_EVENT_DETAIL, eventDetailList);
        this.saveBatch(PAGE_OP_DETAIL, opDetailList);
    }

    private boolean checkParams(String datasource, DynamicObject[] afterData) {
        if (!this.datasourceEntity.containsKey(datasource)) {
            return false;
        }
        return afterData != null && afterData.length != 0;
    }

    private DynamicObject getEventSum(DynamicObject after, Long changeSceneId, Long eventId) {
        DynamicObject event = this.newEmptyDynamicObject(PAGE_EVENT_SUM);
        Long id = ProjRoleChangeEvent.createId(PAGE_EVENT_SUM);
        event.set("id", (Object)id);
        event.set("creator", (Object)this.creatorId);
        event.set("createtime", (Object)this.now);
        event.set("event", (Object)eventId);
        event.set("sourcetype", (Object)this.datasource);
        Long proRoleBoId = after.getLong("boid");
        event.set("projrole", (Object)proRoleBoId);
        event.set("changetype", (Object)after.getString("changetype.id"));
        event.set("changereason", (Object)after.getString("changereason.id"));
        event.set("changedate", (Object)after.getDate("bsed"));
        event.set("changescene", (Object)changeSceneId);
        return event;
    }

    private DynamicObject handleEventSum(DynamicObject after, DynamicObject before, Long eventId, Long changeSceneId) {
        DynamicObject event = this.newEmptyDynamicObject(PAGE_EVENT_SUM);
        Long id = ProjRoleChangeEvent.createId(PAGE_EVENT_SUM);
        event.set("id", (Object)id);
        event.set("creator", (Object)this.creatorId);
        event.set("createtime", (Object)this.now);
        event.set("event", (Object)eventId);
        event.set("sourcetype", (Object)this.datasource);
        event.set("projrole", (Object)after.getLong("boid"));
        event.set("changetype", (Object)after.getString("changetype.id"));
        event.set("changereason", (Object)after.getString("changereason.id"));
        event.set("changedate", (Object)after.getDate("bsed"));
        event.set("changescene", (Object)changeSceneId);
        if (this.afterVidToBillIdMap != null) {
            event.set("billid", (Object)this.afterVidToBillIdMap.get(after.getLong("id")));
        }
        return event;
    }

    private DynamicObject getRoleChEventDetail(DynamicObject after, Long eventId, Long eventDetailId, Long changeSceneId, Map<Long, Long> changeSceneSubMap, Long eventDetailRelId, Long sourceRoleBoId) {
        DynamicObject event = this.newEmptyDynamicObject(PAGE_EVENT_DETAIL);
        if (eventDetailId != null && eventDetailId > 0L) {
            event.set("id", (Object)eventDetailId);
        } else {
            Long id = ProjRoleChangeEvent.createId(PAGE_EVENT_DETAIL);
            event.set("id", (Object)id);
        }
        if (eventDetailRelId != null && sourceRoleBoId != null) {
            if (eventDetailId == null) {
                event.set("sourceroleid", (Object)sourceRoleBoId);
                event.set("eventdetailrelid", (Object)eventDetailRelId);
            } else if (eventDetailRelId.longValue() != eventDetailId.longValue()) {
                event.set("sourceroleid", (Object)sourceRoleBoId);
                event.set("eventdetailrelid", (Object)eventDetailRelId);
            }
        }
        Long proRoleBoId = after.getLong("boid");
        event.set("creator", (Object)this.creatorId);
        event.set("createtime", (Object)this.now);
        event.set("event", (Object)eventId);
        event.set("sourcetype", (Object)this.datasource);
        event.set("projrole", (Object)proRoleBoId);
        event.set("changetype", (Object)after.getString("changetype.id"));
        event.set("changereason", (Object)after.getString("changereason.id"));
        event.set("changedate", (Object)after.getDate("bsed"));
        event.set("changescene", (Object)changeSceneId);
        event.set("changescenesub", (Object)(changeSceneSubMap == null || changeSceneSubMap.get(proRoleBoId) == null ? Long.valueOf(0L) : changeSceneSubMap.get(proRoleBoId)));
        return event;
    }

    private DynamicObject handleEventDetail(DynamicObject after, DynamicObject before, Long eventId, Long changeSceneId) {
        DynamicObject event = this.newEmptyDynamicObject(PAGE_EVENT_DETAIL);
        Long id = ProjRoleChangeEvent.createId(PAGE_EVENT_DETAIL);
        event.set("id", (Object)id);
        event.set("creator", (Object)this.creatorId);
        event.set("createtime", (Object)this.now);
        event.set("event", (Object)eventId);
        event.set("sourcetype", (Object)this.datasource);
        event.set("projrole", (Object)after.getLong("boid"));
        event.set("changetype", (Object)after.getString("changetype.id"));
        event.set("changereason", (Object)after.getString("changereason.id"));
        event.set("changedate", (Object)after.getDate("bsed"));
        event.set("changescene", (Object)changeSceneId);
        return event;
    }

    private DynamicObject handleOpDetail(DynamicObject after, DynamicObject before, Long eventId, String datasource) {
        DynamicObject operDetail = this.newEmptyDynamicObject(PAGE_OP_DETAIL);
        Long id = ProjRoleChangeEvent.createId(PAGE_OP_DETAIL);
        operDetail.set("id", (Object)id);
        operDetail.set("creator", (Object)this.creatorId);
        operDetail.set("createtime", (Object)this.now);
        operDetail.set("event", (Object)eventId);
        operDetail.set("sourcetype", (Object)datasource);
        operDetail.set("projrole", (Object)after.getLong("boid"));
        operDetail.set("changeoperate", (Object)after.getLong("changeoperate.id"));
        operDetail.set("changedate", (Object)after.getDate("bsed"));
        operDetail.set("beforerole", (Object)(before == null ? 0L : before.getLong("id")));
        operDetail.set("afterrole", (Object)after.getLong("id"));
        return operDetail;
    }

    private static Long createId(String pageValue) {
        return ORM.create().genLongId(pageValue);
    }

    private DynamicObject newEmptyDynamicObject(String pageValue) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)pageValue);
        return new DynamicObject((DynamicObjectType)dataEntityType);
    }

    public void saveBatch(String entityPage, List<DynamicObject> dynamicObjects) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityPage);
        serviceHelper.save(dynamicObjects.toArray(new DynamicObject[0]));
    }
}

