/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.service.projectrole;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hrmp.hbpm.business.utils.PrjRolePermUtils;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;

public class ProjectRoleBusiness
implements ProjectRoleConstants {
    private static final Log log = LogFactory.getLog(ProjectRoleBusiness.class);
    private static final String IS_HAVE_MEMBERS = "isHaveMembers";

    public static Long getSuperRole(boolean isMainHead, DynamicObject project) {
        QFilter dutyFilter;
        if (project == null) {
            return null;
        }
        HRBaseServiceHelper workRoleHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        QFilter prjFilter = isMainHead ? new QFilter("adminorg", "=", (Object)project.getLong("parentorg.id")) : new QFilter("adminorg", "=", (Object)project.getLong("id"));
        DynamicObject[] projectRole = workRoleHelper.queryOriginalArray("id", new QFilter[]{prjFilter, dutyFilter = new QFilter("mainpeoincharge", "=", (Object)"1"), FILTER_IS_CURRENT_VERSION, Q_FILTER_ENABLE});
        if (projectRole.length == 1) {
            return projectRole[0].getLong("id");
        }
        return null;
    }

    public static DynamicObject getRoleTypeDynByMainHead(Boolean isMainHead) {
        HRBaseServiceHelper roleTypeHelper = new HRBaseServiceHelper("hbpm_roletype");
        DynamicObject roleTypeDyn = roleTypeHelper.generateEmptyDynamicObject();
        if (isMainHead.booleanValue()) {
            roleTypeDyn.set("id", (Object)1010L);
        } else {
            roleTypeDyn.set("id", (Object)1030L);
        }
        return roleTypeDyn;
    }

    public static List<Map<String, Object>> getProjectRoleMembers(Map<Long, String> projectMap) {
        ArrayList<Long> ids = new ArrayList<Long>(projectMap.keySet());
        ArrayList<Map<String, Object>> result = new ArrayList();
        try {
            result = (List)HRMServiceHelper.invokeHRService((String)"ptmm", (String)"IPTMMQueryMemberService", (String)"getProjectRoleMembersById", (Object[])new Object[]{ids});
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"ProjectRoleBusiness_2", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        }
        return result;
    }

    public static Map<Long, StringBuilder> validProjectRoleMembers(Map<Long, String> idNameMap) {
        if (idNameMap == null || idNameMap.size() < 1) {
            return null;
        }
        List<Map<String, Object>> roleMembers = ProjectRoleBusiness.getProjectRoleMembers(idNameMap);
        HashMap<Long, StringBuilder> idTipMap = new HashMap<Long, StringBuilder>(16);
        String loadString = ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u5b58\u5728\u5728\u804c\u4eba\u5458\u3002", (String)"ProjectRoleBusiness_1", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
        roleMembers.forEach(map -> {
            if (!((Boolean)map.get(IS_HAVE_MEMBERS)).booleanValue()) {
                return;
            }
            StringBuilder member = new StringBuilder();
            member.append(loadString);
            idTipMap.put((Long)map.get("projectRoleId"), member);
        });
        return idTipMap;
    }

    public static boolean checkPermWithDataAndBU(Object currentNodeId) {
        QFilter permFilter = new QFilter("1", "=", (Object)1);
        Optional.ofNullable(PrjRolePermUtils.getDataRuleForBdProp("projteam")).ifPresent(arg_0 -> ((QFilter)permFilter).and(arg_0));
        long value = Long.parseLong(String.valueOf(currentNodeId));
        DynamicObjectCollection haos_projectgroupbaseinfo = QueryServiceHelper.query((String)"haos_projteambaseinfo", (String)"id,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)value), permFilter});
        return haos_projectgroupbaseinfo.size() == 1;
    }
}

