/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.service.projectrole;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.domain.repository.position.ProjectRoleQueryRepository;
import kd.hrmp.hbpm.business.service.workroles.ReportRelationApiServiceHelper;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;

public class ProjectRoleValidateHelper
implements ProjectRoleConstants {
    public static final String BSED = "bsed";
    public static final String BSLED = "bsled";
    public static final String PARENT_ID = "parent.id";
    public static final String EFFECTDATE = "effectdate";
    public static final String ROLE_ID = "role.id";
    private static final String OP_KEY = "kd.hrmp.hbpm.opplugin.web.validate.ProjectRoleCheckValidator";
    private static final String SYSTEM_TYPE = "hrmp-hbpm-business";
    public static HRBaseServiceHelper PR_SERVICE_HELPER = new HRBaseServiceHelper("hbpm_projectroles");
    private static final Log LOG = LogFactory.getLog(ProjectRoleValidateHelper.class);
    private static final String symbol = ";";

    public static List<String> disableCheckOneLeader(DynamicObject[] dy) {
        ArrayList<String> result = new ArrayList<String>(dy.length);
        for (DynamicObject dynamicObject : dy) {
            if (!dynamicObject.getBoolean("isdutypers")) continue;
            result.add(dynamicObject.getString("number") + symbol + dynamicObject.getString("projteam.name"));
        }
        return result;
    }

    public static List<String> disableCheckSlave(DynamicObject[] dy) {
        ArrayList<String> result = new ArrayList<String>(dy.length);
        for (DynamicObject dynamicObject : dy) {
            DynamicObject[] query = ProjectRoleValidateHelper.getQuery(dynamicObject);
            if (query.length <= 0) continue;
            result.add(dynamicObject.getString("number") + symbol + dynamicObject.getString("name"));
        }
        return result;
    }

    private static DynamicObject[] getQuery(DynamicObject dynamicObject) {
        return PR_SERVICE_HELPER.query("id", new QFilter[]{new QFilter("superroles", "=", (Object)dynamicObject.getLong("id")), new QFilter("enable", "=", (Object)"1"), new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'))});
    }

    public static Map<Long, DynamicObject> getRoleCoopRelMap(Long workRoleId) {
        HRBaseServiceHelper roleCoopRelHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter typeFilter = new QFilter("role", "in", (Object)workRoleId);
        QFilter reportingTypeFilter = new QFilter("reportingtype", "!=", (Object)1010L);
        QFilter isCurVerFilter = new QFilter("iscurrentversion", "in", (Object)"1");
        DynamicObject[] wrRelationArr = roleCoopRelHelper.queryOriginalArray("id,bsed,role.id,firstbsed", new QFilter[]{enableFilter, typeFilter, isCurVerFilter, reportingTypeFilter});
        Map<Long, DynamicObject> roleCoopRelMap = Arrays.stream(wrRelationArr).filter(dyn -> dyn.getLong(ROLE_ID) != 0L).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        return roleCoopRelMap;
    }

    public static DynamicObject getWorkRoleDyn(Long proRoleId) {
        if (proRoleId == null) {
            return null;
        }
        HRBaseServiceHelper workRolesHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        QFilter[] qFilters = new QFilter[]{new QFilter("position", "=", (Object)proRoleId), new QFilter("iscurrentversion", "=", (Object)"1")};
        return workRolesHelper.queryOne("id,position.id", qFilters);
    }

    public static List<String> checkNumber(DynamicObject dy) {
        DynamicObject[] query;
        ArrayList<String> result = new ArrayList<String>();
        for (DynamicObject dynamicObject : query = PR_SERVICE_HELPER.query("id,name,number", new QFilter[]{new QFilter("number", "=", (Object)dy.getString("number")), new QFilter("iscurrentversion", "=", (Object)"1")})) {
            Long aLong = dynamicObject.getLong("id");
            if (aLong.equals(dy.getLong("id"))) continue;
            result.add("NumberExist");
            break;
        }
        return result;
    }

    public static boolean isExistProRoleNumber(Set<String> numberSet, Long boId) {
        if (numberSet == null) {
            return false;
        }
        QFilter numberFilter = new QFilter("number", "in", numberSet).and(new QFilter("boid", "!=", (Object)boId));
        return PR_SERVICE_HELPER.isExists(numberFilter);
    }

    public static Map<Long, List<DynamicObject>> getProRoleByProTeam(Set<Long> projectTeamIdSet) {
        if (projectTeamIdSet == null) {
            return null;
        }
        HashMap<Long, List<DynamicObject>> retDataMap = new HashMap(projectTeamIdSet.size());
        LOG.info("ProjectRoleValidateHelper.getProRoleByName, projectTeamIdSet.size={}", (Object)projectTeamIdSet.size());
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter isCurVerFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter proTeamFilter = new QFilter("projteam.id", "in", projectTeamIdSet);
        DynamicObject[] proRoleDataArr = PR_SERVICE_HELPER.query("id,boid,name,number,projteam", new QFilter[]{proTeamFilter, enableFilter, isCurVerFilter});
        if (proRoleDataArr != null) {
            retDataMap = Arrays.stream(proRoleDataArr).collect(Collectors.groupingBy(dyn -> dyn.getLong("projteam.id")));
        }
        LOG.info("ProjectRoleValidateHelper.getProRoleByProTeam, retDataMap.size", (Object)(proRoleDataArr == null ? 0 : retDataMap.size()));
        return retDataMap;
    }

    public static List<String> checkNameValidity(OrmLocaleValue name) {
        ArrayList<String> result = new ArrayList<String>(16);
        String CnName = name.getLocaleValue_zh_CN();
        String EnName = name.getLocaleValue_en();
        if (HRStringUtils.isEmpty((String)CnName) && HRStringUtils.isEmpty((String)EnName)) {
            return result;
        }
        Set entries = name.entrySet();
        for (Map.Entry nameSet : entries) {
            String value = (String)nameSet.getValue();
            if (!value.contains("!") && !value.contains("_") && !value.contains("\\") && !value.contains("/")) continue;
            result.add("specialsymbols");
            break;
        }
        return result;
    }

    public static List<String> checkName(OrmLocaleValue name, Long teamId, Long id) {
        DynamicObject[] query;
        ArrayList<String> result = new ArrayList<String>();
        String CnName = name.getLocaleValue_zh_CN();
        String EnName = name.getLocaleValue_en();
        if (HRStringUtils.isEmpty((String)CnName) && HRStringUtils.isEmpty((String)EnName)) {
            return result;
        }
        Set entries = name.entrySet();
        for (Map.Entry nameSet : entries) {
            String value = (String)nameSet.getValue();
            if (!value.contains("!") && !value.contains("_") && !value.contains("\\") && !value.contains("/")) continue;
            result.add("specialsymbols");
            break;
        }
        ArrayList<String> enableValue = new ArrayList<String>(3);
        enableValue.add("1");
        enableValue.add("10");
        if (Objects.isNull(teamId) || teamId == 0L) {
            return result;
        }
        block1: for (DynamicObject dynamicObject : query = PR_SERVICE_HELPER.query("id,name", new QFilter[]{new QFilter("projteam", "=", (Object)teamId), new QFilter("enable", "in", enableValue), new QFilter("iscurrentversion", "=", (Object)"1")})) {
            OrmLocaleValue roleName = (OrmLocaleValue)dynamicObject.get("name");
            Long dataId = dynamicObject.getLong("id");
            if (dataId.equals(id)) continue;
            for (Map.Entry entry : entries) {
                for (Map.Entry dateEntry : roleName.entrySet()) {
                    String nameValue = (String)entry.getValue();
                    if (!HRStringUtils.isNotEmpty((String)nameValue) || !nameValue.equals(dateEntry.getValue())) continue;
                    result.add("NameExist");
                    continue block1;
                }
            }
        }
        return result;
    }

    public static List<String> checkEffectiveness(DynamicObject superRoles, DynamicObject projteam) {
        ArrayList<String> result = new ArrayList<String>(3);
        if (!HRObjectUtils.isEmpty((Object)superRoles) && "0".equals(superRoles.getString("enable"))) {
            result.add("superroles");
        }
        if (!HRObjectUtils.isEmpty((Object)projteam) && "0".equals(projteam.getString("enable"))) {
            result.add("projteam");
        }
        return result;
    }

    public static List<String> checkSubordinateRelations(DynamicObject entity) {
        DynamicObject superroles = entity.getDynamicObject("superroles");
        ArrayList<String> result = new ArrayList<String>(3);
        if (HRObjectUtils.isEmpty((Object)superroles)) {
            return result;
        }
        DynamicObject[] dynamicObjects = PR_SERVICE_HELPER.query("superroles,id", new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("iscurrentversion", "=", (Object)"1")});
        HashMap map = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            map.put(dynamicObject.getLong("id"), dynamicObject);
        }
        if (ProjectRoleValidateHelper.getSupper(entity, entity.getLong("id"), map)) {
            result.add("subordinateRelations");
        }
        return result;
    }

    private static boolean getSupper(DynamicObject dyn, Long id, Map<Long, DynamicObject> map) {
        if (Objects.isNull(dyn)) {
            return false;
        }
        DynamicObject superroles = dyn.getDynamicObject("superroles");
        if (!HRObjectUtils.isEmpty((Object)superroles)) {
            Long aLong = superroles.getLong("id");
            superroles = map.get(aLong);
            if (aLong.equals(id)) {
                return true;
            }
            return ProjectRoleValidateHelper.getSupper(superroles, id, map);
        }
        return false;
    }

    public static Date formatDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return format.parse(format.format(date));
        }
        catch (ParseException e) {
            LOG.error((Throwable)e);
            return new Date();
        }
    }

    public static List<String> checkDateReasonable(DynamicObject entity) {
        ArrayList<String> result = new ArrayList<String>(3);
        Date design = ProjectRoleValidateHelper.formatDate(entity.getDate("design"));
        DynamicObject projteam = entity.getDynamicObject("projteam");
        if (!HRObjectUtils.isEmpty((Object)projteam)) {
            Date projteamDate = projteam.getDate("establishmentdate");
            Date establishmentdate = ProjectRoleValidateHelper.formatDate(projteamDate);
            if (design.getTime() < establishmentdate.getTime()) {
                result.add("designBeforeEst");
            }
        }
        if (ProjectRoleValidateHelper.formatDate(entity.getDate(BSED)).getTime() < design.getTime()) {
            result.add("efiBeforeDesign");
        }
        return result;
    }

    public static List<String> checkEstablishDate(DynamicObject proRoleDyn) {
        ArrayList<String> result = new ArrayList<String>(16);
        Date design = ProjectRoleValidateHelper.formatDate(proRoleDyn.getDate("design"));
        DynamicObject projTeamDyn = proRoleDyn.getDynamicObject("projteam");
        if (!HRObjectUtils.isEmpty((Object)projTeamDyn)) {
            Date projTeamDate = projTeamDyn.getDate("establishmentdate");
            Date establishDate = ProjectRoleValidateHelper.formatDate(projTeamDate);
            if (design.getTime() < establishDate.getTime()) {
                result.add("designBeforeEst");
            }
        }
        return result;
    }

    public static List<String> checkProRoleDesignDate(DynamicObject entity) {
        ArrayList<String> result = new ArrayList<String>(1);
        Date design = ProjectRoleValidateHelper.formatDate(entity.getDate("design"));
        if (ProjectRoleValidateHelper.formatDate(entity.getDate(BSED)).getTime() < design.getTime()) {
            result.add("efiBeforeDesign");
        }
        return result;
    }

    public static List<String> checkTheMainLeader(DynamicObject proRoleDyn) {
        ArrayList<String> result;
        block2: {
            boolean dbMainIsNotMe;
            boolean isdutypers;
            DynamicObject[] roles;
            block3: {
                result = new ArrayList<String>(3);
                DynamicObject projTeam = proRoleDyn.getDynamicObject("projteam");
                if (HRObjectUtils.isEmpty((Object)projTeam)) break block2;
                roles = PR_SERVICE_HELPER.query("isdutypers,id,name,number", new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("projteam", "=", (Object)projTeam.getLong("id")), new QFilter("isdutypers", "=", (Object)"1"), new QFilter("iscurrentversion", "=", (Object)"1")});
                isdutypers = proRoleDyn.getBoolean("isdutypers");
                if (roles.length != 0) break block3;
                if (isdutypers) break block2;
                result.add("atLeastOneLeader");
                break block2;
            }
            DynamicObject dbMainRole = roles[0];
            boolean bl = dbMainIsNotMe = proRoleDyn.getLong("boid") != dbMainRole.getLong("id");
            if (isdutypers && dbMainIsNotMe && !ProjectRoleValidateHelper.curRoleEffectToday(proRoleDyn)) {
                result.add("addAnotherLeader");
            }
            for (DynamicObject role : roles) {
                Long aLong = role.getLong("id");
                if (!aLong.equals(proRoleDyn.getLong("id")) || isdutypers) continue;
                result.add("atLeastOneLeader");
                break;
            }
        }
        return result;
    }

    public static boolean curRoleEffectToday(DynamicObject proRoleDyn) {
        return LocalDateTime.ofInstant(proRoleDyn.getDate(BSED).toInstant(), ZoneId.systemDefault()).toLocalDate().isEqual(LocalDate.now());
    }

    public static Set<String> checkCollaborationEffective(DynamicObject entity) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            DynamicObject workRole = dynamicObject.getDynamicObject("parent");
            String enable = workRole.getString("enable");
            if ("1".equals(enable)) continue;
            String workRoleName = workRole.getString("name");
            DynamicObject reportCorelType = dynamicObject.getDynamicObject("reportcoreltype");
            String reportCorelTypeName = reportCorelType.getString("name");
            result.add(reportCorelTypeName + symbol + workRoleName);
        }
        return result;
    }

    public static Set<String> checkSameTypeCollaborationCycle(DynamicObject entity) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        DynamicObjectCollection entryentity = entity.getDynamicObjectCollection("entryentity");
        if (Objects.isNull(entryentity) || entryentity.size() == 0) {
            return result;
        }
        Date today = ProjectRoleValidateHelper.formatDate(new Date());
        DynamicObject role = ProjectRoleValidateHelper.getWorkRoleIdByProjectRoleId(entity);
        if (role == null) {
            return result;
        }
        Long roleId = role.getLong("id");
        Map<Long, List<DynamicObject>> infoMap = ProjectRoleValidateHelper.getEffctiveDatas(entryentity, role, today, ProjectRoleValidateHelper.formatDate(((DynamicObject)entryentity.get(0)).getDate(EFFECTDATE)));
        StringBuilder printResult = new StringBuilder();
        for (Map.Entry<Long, List<DynamicObject>> valueEntry : infoMap.entrySet()) {
            List<DynamicObject> value = valueEntry.getValue();
            Map<Long, List<DynamicObject>> roleIdAndParentsList = value.stream().collect(Collectors.groupingBy(item -> item.getLong(ROLE_ID), Collectors.toList()));
            DynamicObject entryData = value.get(0);
            Stack<DynamicObject> stack = new Stack<DynamicObject>();
            stack.add(entryData);
            if (!ProjectRoleValidateHelper.isCycle(roleIdAndParentsList, roleId, stack, entryData)) continue;
            result.add(entryData.getString("reportingtype.name"));
            while (!stack.isEmpty()) {
                DynamicObject pop = stack.pop();
                printResult.append("id").append(':').append(pop.getLong("id")).append("==").append(pop.getString("role.name")).append("-->").append(pop.getString("parent.name")).append(':').append(HRDateTimeUtils.format((Date)pop.getDate(BSED), (String)"yyyy-MM-dd")).append("\u2014\u2014").append(HRDateTimeUtils.format((Date)pop.getDate(BSLED), (String)"yyyy-MM-dd")).append(System.lineSeparator());
            }
            LOG.info(MessageFormat.format("==Cycle validate result:{0}{1}", System.lineSeparator(), printResult.toString()));
            printResult.delete(0, printResult.length());
        }
        return result;
    }

    private static boolean isCycle(Map<Long, List<DynamicObject>> roleIdAndParentsList, Long roleId, Stack<DynamicObject> stack, DynamicObject entryData) {
        boolean hasCycle = false;
        long[] overlappingDate = new long[2];
        block0: while (!stack.isEmpty() && !hasCycle) {
            Long parentId;
            List<DynamicObject> dynamicObjects;
            DynamicObject current = stack.pop();
            if (current == entryData) {
                overlappingDate = new long[2];
            }
            if ((dynamicObjects = roleIdAndParentsList.get(parentId = Long.valueOf(current.getLong(PARENT_ID)))) == null || dynamicObjects.size() == 0) break;
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (!ProjectRoleValidateHelper.hasTimeOverlapping(current, dynamicObject, overlappingDate)) continue;
                if (roleId.equals(dynamicObject.getLong(ROLE_ID))) {
                    hasCycle = true;
                    stack.push(current);
                    continue block0;
                }
                stack.push(current);
                stack.push(dynamicObject);
                continue block0;
            }
        }
        return hasCycle;
    }

    private static boolean hasTimeOverlapping(DynamicObject current, DynamicObject dynamicObject, long[] overlappingDate) {
        boolean result;
        long currentStart = ProjectRoleValidateHelper.formatDate(current.getDate(BSED)).getTime();
        long currentEnd = ProjectRoleValidateHelper.formatDate(current.getDate(BSLED)).getTime();
        long dyStart = ProjectRoleValidateHelper.formatDate(dynamicObject.getDate(BSED)).getTime();
        long dyEnd = ProjectRoleValidateHelper.formatDate(dynamicObject.getDate(BSLED)).getTime();
        if (overlappingDate[0] != 0L && overlappingDate[1] != 0L) {
            currentStart = overlappingDate[0];
            currentEnd = overlappingDate[1];
        }
        boolean bl = result = dyEnd >= currentStart && dyStart <= currentEnd;
        if (result) {
            Long repeatTimeStart = Math.max(currentStart, dyStart);
            Long repeatTimeEnd = Math.min(currentEnd, dyEnd);
            overlappingDate[0] = repeatTimeStart;
            overlappingDate[1] = repeatTimeEnd;
        }
        return result;
    }

    private static Map<Long, List<DynamicObject>> getEffctiveDatas(DynamicObjectCollection entryentity, DynamicObject role, Date today, Date date) {
        List<Long> reportcoreltypeIds = entryentity.stream().map(entryentit -> entryentit.getLong("reportcoreltype.id")).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        DynamicObject[] effctiveData = ProjectRoleValidateHelper.queryEffctiveDataBck(serviceHelper, reportcoreltypeIds, today, date);
        HashMap infoMap = Maps.newHashMapWithExpectedSize((int)reportcoreltypeIds.size());
        for (Long reportcoreltypeId : reportcoreltypeIds) {
            ArrayList<DynamicObject> infoList = new ArrayList<DynamicObject>(16);
            for (DynamicObject dynamicObject : entryentity) {
                if (!reportcoreltypeId.equals(dynamicObject.getLong("reportcoreltype.id"))) continue;
                DynamicObject newDy = serviceHelper.generateEmptyDynamicObject();
                newDy.set(BSED, (Object)ProjectRoleValidateHelper.formatDate(dynamicObject.getDate(EFFECTDATE)));
                newDy.set(BSLED, (Object)ProjectRoleValidateHelper.formatDate(new Date()));
                newDy.set("parent", (Object)dynamicObject.getDynamicObject("parent"));
                newDy.set("role", (Object)role);
                newDy.set("reportingtype", (Object)dynamicObject.getDynamicObject("reportcoreltype"));
                infoList.add(newDy);
            }
            for (DynamicObject effctiveDatum : effctiveData) {
                if (!reportcoreltypeId.equals(effctiveDatum.getLong("reportingtype.id"))) continue;
                infoList.add(effctiveDatum);
            }
            infoMap.put(reportcoreltypeId, infoList);
        }
        return infoMap;
    }

    private static DynamicObject getWorkRoleIdByProjectRoleId(DynamicObject entity) {
        Long projectRoleId = entity.getLong("id");
        HRBaseServiceHelper workroleshr = new HRBaseServiceHelper("hbpm_workroleshr");
        DynamicObject workRole = workroleshr.loadDynamicObject(new QFilter[]{new QFilter("position", "=", (Object)projectRoleId), new QFilter("iscurrentversion", "=", (Object)"1")});
        return workRole;
    }

    private static DynamicObject[] queryEffctiveDataBck(HRBaseServiceHelper serviceHelper, List<Long> reportcoreltypeIds, Date today, Date effectdate) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter typeFilter = new QFilter("reportingtype", "in", reportcoreltypeIds);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"}).and("iscurrentversion", "=", (Object)"0");
        QFilter dateFilter = new QFilter(BSED, "<=", (Object)today).and(new QFilter(BSLED, ">=", (Object)effectdate));
        DynamicObject[] enableRelations = serviceHelper.query("id,bsed,bsled,parent.id,parent.name,role.id,role.name,reportingtype.id,reportingtype.name", new QFilter[]{enableFilter, typeFilter, statusFilter, dateFilter});
        return enableRelations;
    }

    public static Set<String> checkSameTypeCollaborationUnique(DynamicObject entity) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        DynamicObjectCollection entryentity = entity.getDynamicObjectCollection("entryentity");
        if (Objects.isNull(entryentity) || entryentity.size() == 0) {
            return result;
        }
        long endTime = ProjectRoleValidateHelper.formatDate(new Date()).getTime();
        long startTime = ProjectRoleValidateHelper.formatDate(entity.getDate(BSED)).getTime();
        HashMap<Long, List<DynamicObject>> classificationMap = new HashMap<Long, List<DynamicObject>>();
        ProjectRoleValidateHelper.getClassificationMap((List<DynamicObject>)entryentity, classificationMap);
        Collection values = classificationMap.values();
        for (List value : values) {
            if (value.size() <= 1) continue;
            result.add(((DynamicObject)value.get(0)).getString("reportcoreltype.name"));
        }
        if (result.size() > 0 || 0L == entity.getLong("boid")) {
            return result;
        }
        long workRoleIdByProjectRoleId = ProjectRoleValidateHelper.getWorkRoleIdByProjectRoleId(entity).getLong("id");
        Map<Long, List<DynamicObject>> enableReportRelations4UniCheck = ReportRelationApiServiceHelper.getEnableReportRelations4UniCheck(classificationMap.keySet(), workRoleIdByProjectRoleId);
        Set entries = classificationMap.entrySet();
        for (Map.Entry longListEntry : entries) {
            DynamicObject current = (DynamicObject)((List)longListEntry.getValue()).get(0);
            List<DynamicObject> enableReportRelations = enableReportRelations4UniCheck.get(longListEntry.getKey());
            ProjectRoleValidateHelper.getTimeIntersection(enableReportRelations, current, startTime, endTime, result);
        }
        return result;
    }

    private static void getTimeIntersection(List<DynamicObject> dynamicObjects, DynamicObject current, long startTime, long endTime, Set<String> result) {
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            long end = ProjectRoleValidateHelper.formatDate(dynamicObject.getDate(BSLED)).getTime();
            long start = ProjectRoleValidateHelper.formatDate(dynamicObject.getDate(BSED)).getTime();
            if (end < startTime || start > endTime || current.getLong("reportingrelboid") == dynamicObject.getLong("boid")) continue;
            result.add(current.getString("reportcoreltype.name"));
            break;
        }
    }

    private static void getClassificationMap(List<DynamicObject> entryentity, Map<Long, List<DynamicObject>> classificationMap) {
        LinkedHashSet classific = Sets.newLinkedHashSetWithExpectedSize((int)entryentity.size());
        for (DynamicObject dynamicObject : entryentity) {
            classific.add(dynamicObject.getLong("reportcoreltype.id"));
        }
        for (Long aLong : classific) {
            ArrayList<DynamicObject> dateList = new ArrayList<DynamicObject>();
            for (DynamicObject dynamicObject : entryentity) {
                if (!aLong.equals(dynamicObject.getLong("reportcoreltype.id"))) continue;
                dateList.add(dynamicObject);
            }
            classificationMap.put(aLong, dateList);
        }
    }

    public static boolean alterConfigWindow(DynamicObject entity, OperateOption option) {
        String confirmResultString = option.getVariableValue("interactionconfirmresult", "");
        InteractionConfirmResult intConfirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
        if (intConfirmResult.getResults().containsKey(OP_KEY)) {
            String result = (String)intConfirmResult.getResults().get(OP_KEY);
            return "Yes".equals(result);
        }
        DynamicObject pj = entity.getDynamicObject("projteam");
        if (!HRObjectUtils.isEmpty((Object)pj)) {
            DynamicObject role = PR_SERVICE_HELPER.queryOne("isdutypers,id,name,number", new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("projteam", "=", (Object)pj.getLong("id")), new QFilter("isdutypers", "=", (Object)"1"), new QFilter("iscurrentversion", "=", (Object)"1")});
            if (role == null) {
                return true;
            }
            InteractionContext interactionContext = new InteractionContext();
            StringBuilder message = ProjectRoleValidateHelper.getProDutyRoleValidatorMsg(entity, pj, role);
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setMessage(message.toString());
            errorInfo.setLevel(ErrorLevel.Warning);
            interactionContext.addOperateInfo(errorInfo);
            throw new KDInteractionException(OP_KEY, interactionContext);
        }
        return false;
    }

    public static StringBuilder getProDutyRoleValidatorMsg(DynamicObject entity, DynamicObject pj, DynamicObject role) {
        StringBuilder message = new StringBuilder();
        String pJName = pj.getString("name");
        String pJNumber = pj.getString("number");
        String oldName = null;
        String oldNumber = null;
        if (null != role) {
            oldName = role.getString("name");
            oldNumber = role.getString("number");
        }
        String newName = entity.getString("name");
        String newNumber = entity.getString("number");
        message.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u201c%1$s/%2$s\u201d\u4e2d\u5df2\u6709\u4e3b\u8d1f\u8d23\u89d2\u8272\u201c%3$s/%4$s\u201d\uff0c\u9009\u62e9\u7ee7\u7eed\u540e\uff0c\u4e3b\u8d1f\u8d23\u89d2\u8272\u5c06\u66ff\u6362\u4e3a\u201c%5$s/%6$s\u201d\u3002", (String)"ProjectRoleValidateHelper_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), pJName, pJNumber, oldName, oldNumber, newName, newNumber));
        return message;
    }

    public static void updateNumberRule(String type, DynamicObject[] dyArray) {
        boolean exist = CodeRuleServiceHelper.isExist((String)"hbpm_projectrolesdetail", (DynamicObject)dyArray[0], null);
        if (!exist) {
            return;
        }
        if ("opplugin".equals(type)) {
            CodeRuleServiceHelper.getNumbers((String)"hbpm_projectrolesdetail", Arrays.stream(dyArray).collect(Collectors.toList()));
        } else if ("form".equals(type)) {
            try {
                CodeRuleServiceHelper.readNumber((String)"hbpm_projectrolesdetail", (DynamicObject)dyArray[0], (String)"");
            }
            catch (KDException e) {
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public static List<String> validRolePlanImportInfo(DynamicObject rolePlan, DynamicObject pjDyn) {
        DynamicObjectCollection roleCol = rolePlan.getDynamicObjectCollection("entryentity");
        ArrayList<String> result = new ArrayList<String>();
        if (ObjectUtils.isEmpty((Object)roleCol)) {
            return Collections.emptyList();
        }
        int noEmptyNameCount = 0;
        int noEmptyNumberCount = 0;
        HashSet<String> nameSet = new HashSet<String>(roleCol.size());
        HashSet<String> numberSet = new HashSet<String>(roleCol.size());
        for (DynamicObject dyn : roleCol) {
            String name;
            String number = dyn.getString("plannumber");
            if (HRStringUtils.isNotEmpty((String)number)) {
                ++noEmptyNumberCount;
                numberSet.add(number);
            }
            if (!HRStringUtils.isNotEmpty((String)(name = dyn.getString("planname")))) continue;
            ++noEmptyNameCount;
            nameSet.add(name);
        }
        if (numberSet.size() != noEmptyNumberCount || nameSet.size() != noEmptyNameCount) {
            String nameOrNumberRepeat = ResManager.loadKDString((String)"\u9875\u9762\u6240\u5f55\u7f16\u7801\u6216\u540d\u79f0\u5b58\u5728\u91cd\u590d\u3002", (String)"ProjectRoleValidateHelper_22", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            result.add(nameOrNumberRepeat);
        } else {
            String numberErrMg = ProjectRoleValidateHelper.checkNumberOrName(numberSet, "number", null, false);
            String nameErrMg = ProjectRoleValidateHelper.checkNumberOrName(nameSet, "name", pjDyn.getLong("id"), true);
            if (!StringUtils.isEmpty((CharSequence)numberErrMg)) {
                String numberExist = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectRoleValidateHelper_23", (String)SYSTEM_TYPE, (Object[])new Object[0]), numberErrMg);
                result.add(numberExist);
            }
            if (!StringUtils.isEmpty((CharSequence)nameErrMg)) {
                String nameExist = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272\u540d\u79f0\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectRoleValidateHelper_24", (String)SYSTEM_TYPE, (Object[])new Object[0]), nameErrMg);
                result.add(nameExist);
            }
        }
        result.add(ProjectRoleValidateHelper.validProjectTeamExist(pjDyn));
        result.add(ProjectRoleValidateHelper.validEntryMultiDutyRole(roleCol));
        result.add(ProjectRoleValidateHelper.validMainRoleFromDB(rolePlan, pjDyn));
        result.removeIf(HRStringUtils::isEmpty);
        return result;
    }

    private static String validProjectTeamExist(DynamicObject pjDyn) {
        String errMsg = "";
        HRBaseServiceHelper proHelper = new HRBaseServiceHelper("haos_projteambaseinfo");
        Long projectTeamId = pjDyn.getLong("id");
        if (!proHelper.isExists(new QFilter[]{Q_FILTER_ENABLE, new QFilter("id", "=", (Object)projectTeamId)})) {
            errMsg = ResManager.loadKDString((String)"\u201c\u6240\u5c5e\u9879\u76ee\u7ec4\u7ec7\u201d\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ProjectRoleValidateHelper_25", (String)SYSTEM_TYPE, (Object[])new Object[0]) + "\n";
        }
        return errMsg;
    }

    private static String validEntryMultiDutyRole(DynamicObjectCollection roleCol) {
        String mMain = "";
        int i = 0;
        for (DynamicObject dyn : roleCol) {
            String isDutyPer = dyn.getString("isdutypers");
            if (!"1".equals(isDutyPer)) continue;
            ++i;
        }
        if (i > 1) {
            mMain = ResManager.loadKDString((String)"\u89d2\u8272\u65b9\u6848\u4e2d\u53ea\u80fd\u6709\u4e00\u4e2a\u4e3b\u8d1f\u8d23\u89d2\u8272\u3002", (String)"ProjectRoleValidateHelper_26", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        return mMain;
    }

    private static String validMainRoleFromDB(DynamicObject rolePlan, DynamicObject pjtDyn) {
        DynamicObjectCollection roleCol = rolePlan.getDynamicObjectCollection("entryentity");
        Optional<DynamicObject> dutyRoleOpt = roleCol.stream().filter(role -> "1".equals(role.getString("isdutypers"))).findAny();
        if (!dutyRoleOpt.isPresent()) {
            DynamicObject[] mainRoles = ProjectRoleQueryRepository.getInstance().queryMainRoleByProjectTeam(Collections.singletonList(pjtDyn.getLong("id")));
            if (mainRoles.length == 0) {
                return String.format(ResManager.loadKDString((String)"%s\uff1a\u9879\u76ee\u56e2\u961f\u4e2d\u81f3\u5c11\u9700\u8981\u6709\u4e00\u4e2a\u4e3b\u8d1f\u8d23\u89d2\u8272\u3002", (String)"ProjectRoleValidateHelper_20", (String)SYSTEM_TYPE, (Object[])new Object[0]), pjtDyn.getString("name"));
            }
        } else {
            DynamicObject[] mainRoles = ProjectRoleQueryRepository.getInstance().queryMainRoleByProjectTeam(Collections.singletonList(pjtDyn.getLong("id")));
            if (mainRoles.length > 0 && !ProjectRoleValidateHelper.curRoleEffectToday(rolePlan)) {
                return String.format(ResManager.loadKDString((String)"%s\uff1a\u66ff\u6362\u539f\u4e3b\u8d1f\u8d23\u89d2\u8272\uff0c\u8bbe\u7acb\u65e5\u671f\u8bf7\u9009\u62e9\u4eca\u5929\u3002", (String)"ProjectRoleValidateHelper_21", (String)SYSTEM_TYPE, (Object[])new Object[0]), dutyRoleOpt.get().getString("plannumber"));
            }
        }
        return "";
    }

    public static String checkNumberOrName(Set<String> nameOrNumberList, String propertyName, Long projectTeamId, boolean isCheckName) {
        QFilter[] qFilters;
        HRBaseServiceHelper proRoleHelper = new HRBaseServiceHelper("hbpm_projectroles");
        if (nameOrNumberList.size() < 1) {
            return null;
        }
        if (isCheckName) {
            QFilter projectTeamIdFilter = new QFilter("projteam.id", "=", (Object)projectTeamId);
            projectTeamIdFilter.and(FILTER_IS_CURRENT_VERSION).and(new QFilter("enable", "=", (Object)"1"));
            qFilters = new QFilter[]{projectTeamIdFilter, new QFilter(propertyName, "in", nameOrNumberList)};
        } else {
            qFilters = new QFilter[]{new QFilter(propertyName, "in", nameOrNumberList)};
        }
        DynamicObject[] dynArr = proRoleHelper.query(propertyName, qFilters);
        if (dynArr == null || dynArr.length == 0) {
            return null;
        }
        HashSet<String> errMsgList = new HashSet<String>(16);
        for (DynamicObject dyn : dynArr) {
            String dbFiled = dyn.getString(propertyName);
            if (!nameOrNumberList.contains(dbFiled)) continue;
            errMsgList.add(dbFiled);
        }
        if (errMsgList.size() > 0) {
            return String.join((CharSequence)symbol, errMsgList);
        }
        return null;
    }

    public static String checkProRoleInfo(DynamicObject entity) {
        List<String> checkNumber = ProjectRoleValidateHelper.checkNumber(entity);
        List<String> checkName = ProjectRoleValidateHelper.checkName((OrmLocaleValue)entity.get("name"), entity.getLong("projteam.id"), entity.getLong("id"));
        List<String> checkEffectiveness = ProjectRoleValidateHelper.checkEffectiveness(entity.getDynamicObject("superroles"), entity.getDynamicObject("projteam"));
        List<String> checkSubordinateRelations = ProjectRoleValidateHelper.checkSubordinateRelations(entity);
        List<String> checkDateReasonable = ProjectRoleValidateHelper.checkDateReasonable(entity);
        List<String> checkTheMainLeader = ProjectRoleValidateHelper.checkTheMainLeader(entity);
        checkName.addAll(checkNumber);
        checkName.addAll(checkEffectiveness);
        checkName.addAll(checkSubordinateRelations);
        checkName.addAll(checkDateReasonable);
        checkName.addAll(checkTheMainLeader);
        return ProjectRoleValidateHelper.checkMainInfo(checkName, entity, SYSTEM_TYPE);
    }

    public static String checkCollaborationCycle(Set<String> collaborationEffective, String systemType) {
        String errMsg = "";
        for (String co : collaborationEffective) {
            errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u534f\u4f5c\u5173\u7cfb\u51fa\u73b0\u534f\u4f5c\u5faa\u73af\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectRoleValidateHelper_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), co);
        }
        return errMsg;
    }

    public static String checkCollaborationUnique(Set<String> collaborationEffective, String systemType) {
        StringBuilder buf = new StringBuilder();
        for (String co : collaborationEffective) {
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u540c\u4e00\u65f6\u95f4\u6bb5\u5185\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u591a\u6761\u76f8\u540c\u534f\u4f5c\u7c7b\u578b\u201c%s\u201d\u7684\u534f\u4f5c\u4fe1\u606f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectRoleValidateHelper_27", (String)SYSTEM_TYPE, (Object[])new Object[0]), co);
            buf.append(msg);
        }
        return buf.toString();
    }

    public static String checkCollaborationDisable(Set<String> collaborationEffective, String systemType) {
        String errMsg = "";
        for (String co : collaborationEffective) {
            String[] split = co.split(symbol);
            errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u534f\u4f5c\u89d2\u8272\u201c%2$s\u201d\u5df2\u7981\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectRoleValidateHelper_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), split[0], split[1]);
        }
        return errMsg;
    }

    public static String checkMainInfo(List<String> checkName, DynamicObject entity, String systemType) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String errMsg = null;
        Iterator<String> iterator = checkName.iterator();
        while (iterator.hasNext()) {
            String mess;
            switch (mess = iterator.next()) {
                case "NumberExist": {
                    errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectRoleValidateHelper_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]);
                    break;
                }
                case "NameExist": {
                    errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectRoleValidateHelper_10", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]);
                    break;
                }
                case "specialsymbols": {
                    errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u9879\u76ee\u89d2\u8272\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08%2$s\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectRoleValidateHelper_11", (String)SYSTEM_TYPE, (Object[])new Object[0]), entity.getString("name"), "!_/\\");
                    break;
                }
                case "projteam": {
                    String projTeam = ResManager.loadKDString((String)"%s\uff1a\u6240\u5c5e\u9879\u76ee\u56e2\u961f\u5df2\u7981\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectRoleValidateHelper_12", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                    errMsg = String.format(Locale.ROOT, projTeam, entity.getString("projteam.name"));
                    break;
                }
                case "superroles": {
                    errMsg = ResManager.loadKDString((String)"\u4e0a\u7ea7\u89d2\u8272\u5df2\u7981\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectRoleValidateHelper_13", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                    break;
                }
                case "subordinateRelations": {
                    String subordinateRelations = ResManager.loadKDString((String)"%s\uff1a\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u7684\u4e0b\u7ea7\u89d2\u8272\u4e3a\u4e0a\u7ea7\u89d2\u8272\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectRoleValidateHelper_14", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                    errMsg = String.format(Locale.ROOT, subordinateRelations, entity.getString("name"));
                    break;
                }
                case "designBeforeEst": {
                    String designBeforeEst = ResManager.loadKDString((String)"%1$s\uff1a\u8bbe\u7acb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6240\u5c5e\u9879\u76ee\u56e2\u961f\u7684\u6210\u7acb\u65e5\u671f%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectRoleValidateHelper_15", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                    errMsg = String.format(Locale.ROOT, designBeforeEst, entity.getString("number"), simpleDateFormat.format(entity.getDate("projteam.establishmentdate")));
                    break;
                }
                case "efiBeforeDesign": {
                    String efiBeforeDesign = ResManager.loadKDString((String)"%s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u89d2\u8272\u7684\u8bbe\u7acb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectRoleValidateHelper_16", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                    errMsg = String.format(Locale.ROOT, efiBeforeDesign, entity.getString("number"));
                    break;
                }
                case "efiBeforeProEarliestEfi": {
                    String efiBeforeProEarliestEfi = ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6240\u5c5e\u9879\u76ee\u56e2\u961f\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f%2$s\uff0c\u8bf7\u4fee\u6539", (String)"ProjectRoleValidateHelper_17", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                    errMsg = String.format(Locale.ROOT, efiBeforeProEarliestEfi, entity.getString("number"), simpleDateFormat.format(entity.getDate("projteam.firstbsed")));
                    break;
                }
                case "designBeforeEarliestEfi": {
                    String desiBeforeProEarliestEfi = ResManager.loadKDString((String)"%1$s\uff1a\u8bbe\u7acb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6240\u5c5e\u9879\u76ee\u56e2\u961f\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectRoleValidateHelper_19", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                    errMsg = String.format(Locale.ROOT, desiBeforeProEarliestEfi, entity.getString("number"), simpleDateFormat.format(entity.getDate("projteam.firstbsed")));
                    break;
                }
                case "atLeastOneLeader": {
                    String atLeastOneLeader = ResManager.loadKDString((String)"%s\uff1a\u9879\u76ee\u56e2\u961f\u4e2d\u81f3\u5c11\u9700\u8981\u6709\u4e00\u4e2a\u4e3b\u8d1f\u8d23\u4eba\u3002", (String)"ProjectRoleValidateHelper_18", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                    errMsg = String.format(Locale.ROOT, atLeastOneLeader, entity.getString("projteam.name"));
                    break;
                }
                case "addAnotherLeader": {
                    String addAnotherLeader = ResManager.loadKDString((String)"%s\uff1a\u66ff\u6362\u539f\u4e3b\u8d1f\u8d23\u89d2\u8272\uff0c\u8bbe\u7acb\u65e5\u671f\u8bf7\u9009\u62e9\u4eca\u5929\u3002", (String)"ProjectRoleValidateHelper_21", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                    errMsg = String.format(Locale.ROOT, addAnotherLeader, entity.getString("number"));
                    break;
                }
            }
        }
        return errMsg;
    }

    public static boolean checkCurEffDate(Long proRoleId, Date effDate) {
        QFilter filter = new QFilter("id", "=", (Object)proRoleId);
        filter.and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("iscurrentversion", "=", (Object)"1"));
        HRBaseServiceHelper proRoleHelper = new HRBaseServiceHelper("hbpm_projectroles");
        DynamicObject dyn = proRoleHelper.queryOne("id,bsed", filter);
        if (dyn == null) {
            return true;
        }
        return !effDate.before(dyn.getDate(BSED));
    }

    public static boolean checkSuperRolesEffDate(Long parentWorkRoleId, Date designDate) {
        QFilter filter = new QFilter("id", "=", (Object)parentWorkRoleId);
        filter.and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("iscurrentversion", "=", (Object)"1"));
        HRBaseServiceHelper proRoleHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        DynamicObject dyn = proRoleHelper.queryOne("id,firstbsed,bsed", filter);
        if (dyn == null) {
            return true;
        }
        return !designDate.before(dyn.getDate("firstbsed"));
    }

    public static void addCoopRelErrInfo(DynamicObjectCollection coopInfoList, DynamicObject targetObject, Map<Long, DynamicObject> coopRelDynMap, List<DynamicObject> proTeamChgSaveErrList, Map<Long, Date> coopRelChgLastDateMap, List<DynamicObject> proTeamDelErrList) {
        Date coopTeamFirstDate = ProjectRoleValidateHelper.formatDateYYYYMMDD(targetObject.getDate("firstbsed"));
        Date sourceOrgEffDate = targetObject.getDate(BSED);
        for (DynamicObject coopInfo : coopInfoList) {
            Date orgTeamFirstBSed = ProjectRoleValidateHelper.formatDateYYYYMMDD(coopInfo.getDate("parent.firstbsed"));
            Long coopRelId = coopInfo.getLong("id");
            if (sourceOrgEffDate == null || orgTeamFirstBSed == null || !coopRelDynMap.containsKey(coopRelId)) continue;
            Date lastEffDate = coopTeamFirstDate;
            DynamicObject coopRelDynDb = coopRelDynMap.get(coopRelId);
            Date coopRelEffDate = ProjectRoleValidateHelper.formatDateYYYYMMDD(coopRelDynDb.getDate(BSED));
            if (lastEffDate.before(orgTeamFirstBSed)) {
                lastEffDate = orgTeamFirstBSed;
            }
            if (lastEffDate.before(coopRelEffDate)) {
                lastEffDate = coopRelEffDate;
            }
            if (sourceOrgEffDate.before(lastEffDate)) {
                proTeamChgSaveErrList.add(coopInfo);
                coopRelChgLastDateMap.put(coopRelId, lastEffDate);
            }
            coopRelDynMap.remove(coopRelId);
        }
        if (!ObjectUtils.isEmpty(coopRelDynMap)) {
            for (DynamicObject coopRelDel : coopRelDynMap.values()) {
                Date coopRelDelEffDate = ProjectRoleValidateHelper.formatDateYYYYMMDD(coopRelDel.getDate(BSED));
                if (sourceOrgEffDate == null || !sourceOrgEffDate.before(coopRelDelEffDate)) continue;
                proTeamDelErrList.add(coopRelDel);
            }
        }
    }

    public static Date formatDateYYYYMMDD(Date date) {
        String curProCoopEffDateStr = HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
        try {
            return HRDateTimeUtils.parseDate((String)curProCoopEffDateStr, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            LOG.error("parseDate ParseException", (Throwable)e);
            return new Date();
        }
    }

    public static Map<Long, DynamicObject> getProRoleCoopLastEffDynMap(Set<Long> enableRoleIdSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter typeFilter = new QFilter("role", "in", enableRoleIdSet);
        QFilter reportingTypeFilter = new QFilter("reportingtype", "!=", (Object)1010L);
        QFilter statusFilter = new QFilter("iscurrentversion", "in", (Object)"1");
        DynamicObject[] wrRelationArr = serviceHelper.query("id,bsed,role.id,firstbsed", new QFilter[]{enableFilter, typeFilter, statusFilter, reportingTypeFilter});
        HashMap<Long, DynamicObject> proRoleCoopRelMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject proDyn : wrRelationArr) {
            DynamicObject proRoleDyn;
            Date proRoleRelOtherEffDate;
            Long proRoleId = proDyn.getLong(ROLE_ID);
            Date proRoleRelEffDate = proDyn.getDate(BSED);
            if (!proRoleCoopRelMap.containsKey(proRoleId)) {
                proRoleCoopRelMap.put(proRoleId, proDyn);
            }
            if (!(proRoleRelOtherEffDate = (proRoleDyn = (DynamicObject)proRoleCoopRelMap.get(proRoleId)).getDate(BSED)).before(proRoleRelEffDate)) continue;
            proRoleCoopRelMap.put(proRoleId, proDyn);
        }
        return proRoleCoopRelMap;
    }

    public static Date getProRoleAndCoopLastDate(Map<Long, DynamicObject> proRoleCoopLastEffDynMap, Long proRoleId, Date bseDate) {
        Date coopLastEffDate;
        DynamicObject proRoleCoopDyn;
        if (!ObjectUtils.isEmpty(proRoleCoopLastEffDynMap) && (proRoleCoopDyn = proRoleCoopLastEffDynMap.get(proRoleId)) != null && bseDate.before(coopLastEffDate = proRoleCoopDyn.getDate(BSED))) {
            bseDate = coopLastEffDate;
        }
        return bseDate;
    }
}

