/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.service.utils;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class PositionFieldValueConverter {
    private static final Log LOGGER = LogFactory.getLog(PositionFieldValueConverter.class);

    public void assembleHistoryDynamicObjectToDataModel(IDataModel dataModel, DynamicObject historyDynamicObject) {
        if (historyDynamicObject != null) {
            MainEntityType mainEntityType = dataModel.getDataEntityType();
            List pageFieldsNameList = HistoryEntityUtils.getFieldsNameList((MainEntityType)mainEntityType);
            MainEntityType hisEntityType = (MainEntityType)historyDynamicObject.getDataEntityType();
            List fieldsNames = HistoryEntityUtils.getFieldsNameList((MainEntityType)hisEntityType);
            this.setDateToDateModel(historyDynamicObject, fieldsNames, pageFieldsNameList, dataModel);
        }
    }

    private void setDateToDateModel(DynamicObject dyn, List<String> fieldsNameList, List<String> pageFieldsNameList, IDataModel dataModel) {
        for (String fieldsName : fieldsNameList) {
            if (!pageFieldsNameList.contains(fieldsName)) continue;
            Object value = dyn.get(fieldsName);
            this.setFieldValue(value, fieldsName, dataModel);
        }
    }

    private void setFieldValue(Object value, String fieldName, IDataModel dataModel) {
        if (value instanceof DynamicObject) {
            dataModel.setValue(fieldName, (Object)((DynamicObject)value));
        } else if (value instanceof DynamicObjectCollection) {
            MainEntityType mainEntityType = dataModel.getDataEntityType();
            EntityType entryType = (EntityType)mainEntityType.getAllEntities().get(fieldName);
            if (entryType == null) {
                dataModel.setValue(fieldName, this.getDynamicObjectCollection((DynamicObjectCollection)value));
            } else if (entryType instanceof EntryType) {
                dataModel.getDataEntity().set(fieldName, (Object)this.getNewEntry((DynamicObjectCollection)value, entryType));
            }
        } else if (value != null) {
            dataModel.setValue(fieldName, value);
        }
    }

    private Object getDynamicObjectCollection(DynamicObjectCollection dynamicObjectCollection) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return null;
        }
        if (!HistoryEntityUtils.checkNullInDynamicCollection((DynamicObjectCollection)dynamicObjectCollection, (Collection)Lists.newArrayList((Object[])new String[]{"fbasedataid"}))) {
            return null;
        }
        DynamicObjectCollection newDynamicObjectCollection = new DynamicObjectCollection();
        int cunt = 0;
        long[] newDynamicObjectCollectionIds = ORM.create().genLongIds((IDataEntityType)dynamicObjectCollection.getDynamicObjectType(), dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            DynamicObject newDynamicObject = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)newDynamicObject);
            newDynamicObject.set("pkid", (Object)newDynamicObjectCollectionIds[cunt++]);
            newDynamicObjectCollection.add((Object)newDynamicObject);
        }
        return newDynamicObjectCollection;
    }

    private DynamicObjectCollection getNewEntry(DynamicObjectCollection entryCollection, EntityType entryType) {
        if (CollectionUtils.isEmpty((Collection)entryCollection)) {
            return null;
        }
        DynamicObjectCollection newEntryObjColl = new DynamicObjectCollection();
        int cunt = 0;
        long[] entryIds = ORM.create().genLongIds((IDataEntityType)entryType, entryCollection.size());
        for (DynamicObject entry : entryCollection) {
            DynamicObject newEntry = new DynamicObject((DynamicObjectType)entryType);
            HRDynamicObjectUtils.copy((DynamicObject)entry, (DynamicObject)newEntry);
            newEntry.set("id", (Object)entryIds[cunt]);
            newEntry.setParent(entry.getParent());
            try {
                newEntry.set("seq", (Object)cunt++);
            }
            catch (Exception var10) {
                LOGGER.info("has not seq");
            }
            newEntryObjColl.add((Object)newEntry);
        }
        return newEntryObjColl;
    }
}

