/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.service.workroles;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hrmp.hbpm.business.domain.repository.position.DutyWorkRoleQueryRepository;
import kd.hrmp.hbpm.business.utils.WorkRoleNewHisUtils;

public class DutyRolesApiServiceHelper {
    private static final Log LOG = LogFactory.getLog(DutyRolesApiServiceHelper.class);

    public static ApiResult addDutyRoles(List<DynamicObject> dutyRoles) {
        ApiResult result = ApiResult.success(null);
        result.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"DutyRolesApiServiceHelper_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        if (CollectionUtils.isEmpty(dutyRoles)) {
            LOG.info("addDutyRoles() param is empty");
            result.setSuccess(false);
            result.setMessage("param is empty.");
            return result;
        }
        List<DynamicObject> dy4New = WorkRoleNewHisUtils.getDy4New(dutyRoles);
        WorkRoleNewHisUtils.loadReference(dy4New, Arrays.asList("orgtype", "teamtype"));
        WorkRoleNewHisUtils.setPrefixNumber(dy4New);
        OperationResult opResult = DutyRolesApiServiceHelper.callOp("save_api", dy4New.toArray(new DynamicObject[0]));
        if (!opResult.isSuccess()) {
            LOG.info("addDutyRoles() opResult:{}", (Object)opResult.getAllErrorOrValidateInfo().toString());
            result.setSuccess(false);
            result.setMessage(opResult.getAllErrorOrValidateInfo().toString());
            result.setData((Object)opResult);
        }
        LOG.info("addDutyRoles() result:{}", (Object)result.getMessage());
        return result;
    }

    public static ApiResult changeDutyWorkStatus(String enable, List<DynamicObject> dutyRolesList) {
        return DutyRolesApiServiceHelper.changeDutyWorkStatus(enable, dutyRolesList, null);
    }

    public static ApiResult changeDutyWorkStatus(String enable, List<DynamicObject> dutyRolesList, Date effectDate) {
        ApiResult result = ApiResult.success(null);
        result.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"DutyRolesApiServiceHelper_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        if (CollectionUtils.isEmpty(dutyRolesList)) {
            LOG.info("changeDutyWorkStatus() param is empty.");
            result.setSuccess(false);
            result.setMessage("param is empty.");
            return result;
        }
        switch (enable) {
            case "enable": {
                enable = "enable_api";
                break;
            }
            case "disable": {
                enable = "disable_api";
                break;
            }
            default: {
                LOG.info("changeDutyWorkStatus() enable tag is no defined.");
                return ApiResult.fail((String)(enable + "no defined"));
            }
        }
        OperationResult enableResult = WorkRoleNewHisUtils.callOp(enable, dutyRolesList.toArray(new DynamicObject[0]), WorkRoleNewHisUtils.createEffectDateOption(effectDate));
        if (!enableResult.isSuccess()) {
            LOG.info("changeDutyWorkStatus() result:{}", (Object)enableResult.getAllErrorOrValidateInfo().toString());
            result.setSuccess(false);
            result.setMessage(enableResult.getMessage());
            result.setData((Object)enableResult);
        }
        LOG.info("changeDutyWorkStatus() result:{}", (Object)result.getMessage());
        return result;
    }

    private static OperationResult callOp(String opKey, DynamicObject[] dutyRoles) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        return opImpl.localInvokeOperation(opKey, dutyRoles, operateOption);
    }

    public static ApiResult deleteDutyRoles(List<Long> roleIds) {
        ApiResult result;
        block4: {
            result = ApiResult.success(null);
            try {
                result.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"DutyRolesApiServiceHelper_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                if (CollectionUtils.isEmpty(roleIds)) {
                    LOG.info("deleteDutyRoles() param is empty");
                    result.setSuccess(false);
                    result.setErrorCode("fail");
                    result.setMessage("param is empty.");
                    return result;
                }
                boolean existNotEnable = DutyWorkRoleQueryRepository.getInstance().isExistNotEnable(roleIds);
                if (existNotEnable) {
                    result.setSuccess(false);
                    result.setErrorCode("fail");
                    result.setMessage(ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u542f\u7528\u7684\u6570\u636e\u624d\u80fd\u5220\u9664\u3002", (String)"DutyRolesApiServiceHelper_3", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                    return result;
                }
                WorkRoleNewHisUtils.deleteHisData4Api(roleIds, "hbpm_dutyworkroles", result);
                LOG.info("deleteDutyRoles() result:{}", (Object)result);
            }
            catch (Exception e) {
                result.setErrorCode("fail");
                if (!e.getMessage().contains("type casts")) break block4;
                result.setMessage("unsupported type.");
            }
        }
        return result;
    }

    public static ApiResult changeDutyRolesProp(String opType, List<DynamicObject> dutyRoles) {
        String opKey;
        ApiResult result = ApiResult.success(null);
        result.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"ReportRelationApiServiceHelper_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        if (CollectionUtils.isEmpty(dutyRoles)) {
            LOG.info("updateDutyRoles() param is empty");
            result.setSuccess(false);
            result.setMessage("param is empty.");
            return result;
        }
        switch (opType) {
            case "1": 
            case "2": {
                opKey = "change_api";
                break;
            }
            default: {
                LOG.info("changeDutyRolesProp() opType is no defined.");
                return ApiResult.fail((String)(opType + "no defined"));
            }
        }
        List<DynamicObject> dy4ChgProp = WorkRoleNewHisUtils.getDy4ChgProp(dutyRoles);
        WorkRoleNewHisUtils.setPrefixNumber(dy4ChgProp);
        OperationResult opResult = WorkRoleNewHisUtils.callOp(opKey, dy4ChgProp.toArray(new DynamicObject[0]));
        if (!opResult.isSuccess()) {
            LOG.info("updateDutyRoles() opResult:{}", (Object)opResult.getAllErrorOrValidateInfo().toString());
            result.setSuccess(false);
            result.setMessage(opResult.getAllErrorOrValidateInfo().toString());
            result.setData((Object)opResult);
        }
        LOG.info("addDutyRoles() result:{}", (Object)result.getMessage());
        return result;
    }
}

