/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.service.workroles;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hbpm.business.domain.repository.position.ReportingrelationQueryRepository;
import kd.hrmp.hbpm.business.utils.WorkRoleNewHisUtils;

public class ReportRelationApiServiceHelper {
    private static final Log LOG = LogFactory.getLog(ReportRelationApiServiceHelper.class);
    private static final int MAX_TIMES = 10;

    public static ApiResult addReportRelations(List<DynamicObject> relations) {
        ApiResult result = ApiResult.success(null);
        result.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"ReportRelationApiServiceHelper_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        if (CollectionUtils.isEmpty(relations)) {
            LOG.info("addReportRelations() param is empty");
            result.setSuccess(false);
            result.setMessage("param is empty.");
            return result;
        }
        List<DynamicObject> dy4New = WorkRoleNewHisUtils.getDy4New(relations);
        OperationResult opResult = WorkRoleNewHisUtils.callOp("save_api", dy4New.toArray(new DynamicObject[0]));
        if (!opResult.isSuccess()) {
            LOG.info("addReportRelations() opResult:{}", (Object)opResult.getAllErrorOrValidateInfo().toString());
            result.setSuccess(false);
            result.setMessage(opResult.getAllErrorOrValidateInfo().toString());
            result.setData((Object)opResult);
        }
        LOG.info("addReportRelations() result:{}", (Object)result.getMessage());
        return result;
    }

    public static ApiResult changeReportRelationsStatus(String enable, List<DynamicObject> relationList) {
        return ReportRelationApiServiceHelper.changeReportRelationsStatus(enable, relationList, null);
    }

    public static ApiResult changeReportRelationsStatus(String enable, List<DynamicObject> relationList, Date effectDate) {
        ApiResult result = ApiResult.success(null);
        result.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"ReportRelationApiServiceHelper_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        if (CollectionUtils.isEmpty(relationList)) {
            LOG.info("changeReportRelationsStatus() param is empty");
            result.setSuccess(false);
            result.setMessage("param is empty.");
            return result;
        }
        switch (enable) {
            case "enable": {
                enable = "enable_api";
                break;
            }
            case "disable": {
                enable = "disable_api";
                break;
            }
            default: {
                LOG.info("changeReportRelationsStatus() enable tag is no defined.");
                return ApiResult.fail((String)(enable + "no defined"));
            }
        }
        OperationResult enableResult = WorkRoleNewHisUtils.callOp(enable, relationList.toArray(new DynamicObject[0]), WorkRoleNewHisUtils.createEffectDateOption(effectDate));
        if (!enableResult.isSuccess()) {
            LOG.info("changeReportRelationsStatus() enableResult:{}", (Object)enableResult.getAllErrorOrValidateInfo().toString());
            result.setSuccess(false);
            result.setMessage(enableResult.getMessage());
            result.setData((Object)enableResult);
        }
        LOG.info("changeReportRelationsStatus() result:{}", (Object)result.getMessage());
        return result;
    }

    public static ApiResult deleteReportRelations(List<Long> relationIds) {
        ApiResult result;
        block4: {
            result = ApiResult.success(null);
            try {
                result.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"ReportRelationApiServiceHelper_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                if (CollectionUtils.isEmpty(relationIds)) {
                    LOG.info("deleteReportRelations() param is empty.");
                    result.setSuccess(false);
                    result.setMessage("param is empty.");
                    return result;
                }
                boolean existNotEnable = ReportingrelationQueryRepository.getInstance().isExistNotEnable(relationIds);
                if (existNotEnable) {
                    result.setSuccess(false);
                    result.setErrorCode("fail");
                    result.setMessage(ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u542f\u7528\u7684\u6570\u636e\u624d\u80fd\u5220\u9664\u3002", (String)"DutyRolesApiServiceHelper_3", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                    return result;
                }
                WorkRoleNewHisUtils.deleteHisData4Api(relationIds, "hbpm_reportingrelation", result);
                LOG.info("deleteReportRelations() result:{}", (Object)result);
            }
            catch (Exception e) {
                result.setErrorCode("fail");
                if (!e.getMessage().contains("type casts")) break block4;
                result.setMessage("unsupported type.");
            }
        }
        return result;
    }

    public static ApiResult deleteReportRelationsByWorkRole(List<Long> workRoleIdList) {
        ApiResult result = ApiResult.success(null);
        result.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"ReportRelationApiServiceHelper_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        if (CollectionUtils.isEmpty(workRoleIdList)) {
            LOG.info("deleteReportRelations() param is empty.");
            result.setSuccess(false);
            result.setMessage("param is empty.");
            return result;
        }
        List<Long> reportRelationIdList = WorkRoleNewHisUtils.queryReportRelationByWorkRole(workRoleIdList);
        if (CollectionUtils.isEmpty(reportRelationIdList)) {
            return result;
        }
        WorkRoleNewHisUtils.deleteHisData4Api(reportRelationIdList, "hbpm_reportingrelation", result);
        LOG.info("deleteReportRelations() result:{}", (Object)result);
        return result;
    }

    public static ApiResult checkRelationCycle(List<DynamicObject> relations, long reportingTypeId) {
        ApiResult result = ApiResult.success(null);
        result.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"ReportRelationApiServiceHelper_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        HashMap verify = Maps.newHashMapWithExpectedSize((int)relations.size());
        result.setData((Object)verify);
        if (CollectionUtils.isEmpty(relations)) {
            LOG.info("checkRelationCycle() param is empty.");
            result.setMessage("param is empty.");
            result.setSuccess(false);
            return result;
        }
        Map<Long, Long> enableReportRelations = ReportRelationApiServiceHelper.getEnableReportRelations(reportingTypeId);
        LOG.info("checkRelationCycle2() enableReportRelations.size:{}", (Object)enableReportRelations.size());
        Map<Long, Long> paramMap = relations.stream().collect(Collectors.toMap(dy -> HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)"role"), dy -> HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)"parent")));
        enableReportRelations.putAll(paramMap);
        relations.forEach(relation -> {
            Long parentId;
            Long roleId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)relation, (String)"role");
            boolean cycle = ReportRelationApiServiceHelper.recursion4Parent(roleId, parentId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)relation, (String)"parent"), enableReportRelations, 0);
            if (cycle) {
                verify.put(relation.getLong("id"), Boolean.FALSE);
            } else {
                verify.put(relation.getLong("id"), Boolean.TRUE);
            }
        });
        LOG.info("checkRelationCycle() result:{}", (Object)result);
        return result;
    }

    private static boolean recursion4Parent(Long roleId, Long parentId, Map<Long, Long> enableReportRelations, int times) {
        if (parentId == null || parentId == 0L || times > 10) {
            return false;
        }
        if (parentId.equals(roleId)) {
            return true;
        }
        parentId = enableReportRelations.get(parentId);
        return ReportRelationApiServiceHelper.recursion4Parent(roleId, parentId, enableReportRelations, ++times);
    }

    private static Map<Long, Long> getEnableReportRelations(long reportingTypeId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter typeFilter = new QFilter("reportingtype", "=", (Object)reportingTypeId);
        DynamicObject[] enableRelations = serviceHelper.queryOriginalArray("role.id,parent.id", new QFilter[]{enableFilter, typeFilter});
        return Arrays.stream(enableRelations).collect(Collectors.toMap(dy -> dy.getLong("role.id"), dy -> dy.getLong("parent.id")));
    }

    public static Map<Long, List<DynamicObject>> getEnableReportRelations4UniCheck(Set<Long> reportingTypeIds, long roleId) {
        QFilter statusFilter;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter typeFilter = new QFilter("reportingtype", "in", reportingTypeIds);
        QFilter idFilter = new QFilter("role", "=", (Object)roleId);
        DynamicObject[] enableRelations = serviceHelper.loadDynamicObjectArray(new QFilter[]{enableFilter, typeFilter, idFilter, statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"}).and(new QFilter("iscurrentversion", "=", (Object)"0"))});
        if (enableRelations == null || enableRelations.length == 0) {
            return new HashMap<Long, List<DynamicObject>>();
        }
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>();
        for (Long reportingTypeId : reportingTypeIds) {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
            for (DynamicObject enableRelation : enableRelations) {
                if (reportingTypeId.equals(enableRelation.getLong("reportingtype.id"))) {
                    list.add(enableRelation);
                }
                result.put(reportingTypeId, list);
            }
        }
        return result;
    }

    public static ApiResult changeReportRelationsProp(String opType, List<DynamicObject> relationList) {
        String opKey;
        ApiResult result = ApiResult.success(null);
        result.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"ReportRelationApiServiceHelper_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        if (CollectionUtils.isEmpty(relationList)) {
            LOG.info("changeReportRelationsProp() param is empty");
            result.setSuccess(false);
            result.setMessage("param is empty.");
            return result;
        }
        switch (opType) {
            case "1": 
            case "2": {
                opKey = "change_api";
                break;
            }
            default: {
                LOG.info("changeDutyRolesProp() opType is no defined.");
                return ApiResult.fail((String)(opType + "no defined"));
            }
        }
        List<DynamicObject> dy4ChgProp = WorkRoleNewHisUtils.getDy4ChgProp(relationList);
        OperationResult enableResult = WorkRoleNewHisUtils.callOp(opKey, dy4ChgProp.toArray(new DynamicObject[0]));
        if (!enableResult.isSuccess()) {
            LOG.info("changeReportRelationsProp() enableResult:{}", (Object)enableResult.getAllErrorOrValidateInfo().toString());
            result.setSuccess(false);
            result.setMessage(enableResult.getMessage());
            result.setData((Object)enableResult);
        }
        LOG.info("changeReportRelationsProp() result:{}", (Object)result.getMessage());
        return result;
    }

    public static ApiResult queryEnabledReportRelations(Date date, Long workroleId, Long roletypeId) {
        ApiResult result;
        block2: {
            result = ApiResult.success(null);
            try {
                DynamicObject[] reportRelations = ReportingrelationQueryRepository.getInstance().queryEnabledReportRelations(date, workroleId, roletypeId);
                result.setData((Object)reportRelations);
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorCode("fail");
                if (!e.getMessage().contains("type casts")) break block2;
                result.setMessage("unsupported type.");
            }
        }
        return result;
    }
}

