/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.service.workroles;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hrmp.hbpm.business.application.impl.workrole.WorkRoleServiceApplicationImpl;
import kd.hrmp.hbpm.business.domain.repository.position.WorkRoleQueryRepository;
import kd.hrmp.hbpm.business.utils.WorkRoleNewHisUtils;

public class WorkRolesApiServiceHelper {
    private static final Log LOG = LogFactory.getLog(WorkRolesApiServiceHelper.class);

    public static ApiResult addWorkRoles(List<DynamicObject> roles) {
        ApiResult result = ApiResult.success(null);
        result.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"WorkRolesApiServiceHelper_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        if (CollectionUtils.isEmpty(roles)) {
            LOG.info("addWorkRoles() param is empty.");
            result.setSuccess(false);
            result.setMessage("param is empty.");
            return result;
        }
        List<DynamicObject> dynamicObjectList = WorkRoleNewHisUtils.getDy4New(roles);
        WorkRoleNewHisUtils.loadReference(dynamicObjectList, Arrays.asList("teamtype", "orgtype"));
        WorkRoleNewHisUtils.setPrefixNumber(dynamicObjectList);
        OperationResult opResult = WorkRoleNewHisUtils.callOp("save_api", dynamicObjectList.toArray(new DynamicObject[0]));
        if (!opResult.isSuccess()) {
            LOG.info("addWorkRoles() opResult:{}", (Object)opResult.getAllErrorOrValidateInfo().toString());
            result.setSuccess(false);
            result.setData((Object)opResult);
            result.setMessage(opResult.getAllErrorOrValidateInfo().toString());
        }
        LOG.info("addWorkRoles() result:{}", (Object)result.getMessage());
        return result;
    }

    public static ApiResult changeWorkRolesStatus(String enable, List<DynamicObject> roleList) {
        return WorkRolesApiServiceHelper.changeWorkRolesStatus(enable, roleList, null);
    }

    public static ApiResult changeWorkRolesStatus(String enable, List<DynamicObject> roleList, Date effectDate) {
        ApiResult result = ApiResult.success(null);
        result.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"WorkRolesApiServiceHelper_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        if (CollectionUtils.isEmpty(roleList)) {
            LOG.info("updateWorkRolesStatus() param is empty.");
            result.setSuccess(false);
            result.setMessage("param is empty.");
            return result;
        }
        switch (enable) {
            case "enable": {
                enable = "enable_api";
                break;
            }
            case "disable": {
                enable = "disable_api";
                break;
            }
            default: {
                LOG.info("updateWorkRolesStatus() enable tag is no defined.");
                return ApiResult.fail((String)(enable + "no defined"));
            }
        }
        OperationResult enableResult = WorkRoleNewHisUtils.callOp(enable, roleList.toArray(new DynamicObject[0]), WorkRoleNewHisUtils.createEffectDateOption(effectDate));
        if (!enableResult.isSuccess()) {
            LOG.info("changeWorkRolesStatus() result:{}", (Object)enableResult.getAllErrorOrValidateInfo().toString());
            result.setSuccess(false);
            result.setMessage(enableResult.getMessage());
            result.setData((Object)enableResult);
        }
        LOG.info("changeWorkRolesStatus() result:{}", (Object)result.getMessage());
        return result;
    }

    public static ApiResult deleteWorkRoles(List<Long> roleIds) {
        ApiResult result;
        block4: {
            result = ApiResult.success(null);
            try {
                result.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"WorkRolesApiServiceHelper_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                if (CollectionUtils.isEmpty(roleIds)) {
                    LOG.info("deleteWorkRoles() param is empty.");
                    result.setSuccess(false);
                    result.setMessage("param is empty.");
                    return result;
                }
                boolean existNotEnable = WorkRoleQueryRepository.getInstance().isExistNotEnable(roleIds);
                if (existNotEnable) {
                    result.setSuccess(false);
                    result.setErrorCode("fail");
                    result.setMessage(ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u542f\u7528\u7684\u6570\u636e\u624d\u80fd\u5220\u9664\u3002", (String)"DutyRolesApiServiceHelper_3", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                    return result;
                }
                WorkRoleNewHisUtils.deleteHisData4Api(roleIds, "hbpm_workroleshr", result);
                LOG.info("deleteWorkRoles() result:{}", (Object)result.getMessage());
            }
            catch (Exception e) {
                result.setErrorCode("fail");
                if (!e.getMessage().contains("type casts")) break block4;
                result.setMessage("unsupported type.");
            }
        }
        return result;
    }

    public static ApiResult changeWorkRolesProp(String opType, List<DynamicObject> roleList) {
        ApiResult result = ApiResult.success(null);
        result.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"WorkRolesApiServiceHelper_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        if (CollectionUtils.isEmpty(roleList)) {
            LOG.info("changeWorkRolesProp() param roles is empty.");
            result.setSuccess(false);
            result.setMessage("param is empty.");
            return result;
        }
        OperateOption operateOption = OperateOption.create();
        switch (opType) {
            case "1": {
                operateOption.setVariableValue("change_prop_type", "1");
                break;
            }
            case "2": {
                operateOption.setVariableValue("change_prop_type", "2");
                break;
            }
            default: {
                LOG.info("changeDutyRolesProp() opType is no defined.");
                return ApiResult.fail((String)(opType + "no defined"));
            }
        }
        List<DynamicObject> dy4ChgProp = WorkRoleNewHisUtils.getDy4ChgProp(roleList);
        OperationResult opResult = WorkRoleNewHisUtils.callOp("change_api", dy4ChgProp.toArray(new DynamicObject[0]), operateOption);
        if (!opResult.isSuccess()) {
            LOG.info("changeWorkRolesProp() opResult:{}", (Object)opResult.getAllErrorOrValidateInfo().toString());
            result.setSuccess(false);
            result.setMessage(opResult.getMessage());
            result.setData((Object)opResult);
        }
        LOG.info("updateWorkRolesProp() result:{}", (Object)result.getMessage());
        return result;
    }

    public static ApiResult queryWorkRole(Date date, Long workroleId) {
        ApiResult result;
        block2: {
            result = ApiResult.success(null);
            try {
                DynamicObject role = WorkRoleQueryRepository.getInstance().queryWorkRole(date, workroleId);
                result.setData((Object)role);
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorCode("fail");
                if (!e.getMessage().contains("type casts")) break block2;
                result.setMessage("unsupported type.");
            }
        }
        return result;
    }

    public static ApiResult queryAllRelations(Object date, Object workroleIds, Object roletypeId, Boolean isSelectParent) {
        ApiResult result;
        block5: {
            result = ApiResult.success(null);
            try {
                String message = WorkRolesApiServiceHelper.valideQueryRelationsParam(date, workroleIds, roletypeId);
                if (StringUtils.isNotEmpty((String)message)) {
                    result.setSuccess(false);
                    result.setMessage(message);
                    return result;
                }
                WorkRoleServiceApplicationImpl workRoleServiceApplication = new WorkRoleServiceApplicationImpl();
                if (isSelectParent.booleanValue()) {
                    List<DynamicObject> alParentRelations = workRoleServiceApplication.queryAllParentRelations((Date)date, (List)workroleIds, (Long)roletypeId);
                    result.setData(alParentRelations);
                } else {
                    List<DynamicObject> alParentRelations = workRoleServiceApplication.queryAllChildRelations((Date)date, (List)workroleIds, (Long)roletypeId);
                    result.setData(alParentRelations);
                }
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                result.setSuccess(false);
                result.setErrorCode("fail");
                if (!ex.getMessage().contains("type casts")) break block5;
                result.setMessage("unsupported type.");
            }
        }
        return result;
    }

    private static String valideQueryRelationsParam(Object date, Object workroleIds, Object roletypeId) {
        LOG.info("WorkRolesApiServiceHelper valideQueryRelationsParam() date:", date);
        LOG.info("WorkRolesApiServiceHelper valideQueryRelationsParam() workroleIds:", workroleIds);
        LOG.info("WorkRolesApiServiceHelper valideQueryRelationsParam() roletypeId:", roletypeId);
        StringBuilder buf = new StringBuilder();
        if (date == null || !(date instanceof Date)) {
            buf.append("\nsearch date is invalide.");
        }
        if (workroleIds == null || !(workroleIds instanceof List)) {
            buf.append("\nsearch workroleIds is invalide.");
        } else {
            for (Object key : (List)workroleIds) {
                if (key instanceof Long) continue;
                buf.append("\nsearch workroleIds is invalide.");
                break;
            }
        }
        if (roletypeId == null || !(roletypeId instanceof Long)) {
            buf.append("\nsearch roletypeId is invalide.");
        }
        return buf.toString();
    }
}

