/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hrmp.hbpm.business.domain.repository.position.HisEventRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionChangeDetailRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.PositionChangeDetailServiceImpl;
import kd.hrmp.hbpm.business.utils.model.ChangeDetailEntity;
import kd.hrmp.hbpm.common.constants.PositionDetailConstants;

public class PositionChangeDetailTask
extends AbstractTask {
    private static Log LOG = LogFactory.getLog(PositionChangeDetailTask.class);
    private static Integer MAX_BATCH = 10000;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Long startTime = System.currentTimeMillis();
        List<Long> excludeIds = new ArrayList<Long>(8);
        DynamicObject[] changeDetailEvents = PositionChangeDetailRepository.getInstance().getAllEventInfo();
        if (changeDetailEvents != null && changeDetailEvents.length > 0) {
            excludeIds = Arrays.stream(changeDetailEvents).map(data -> data.getLong("event")).collect(Collectors.toList());
        }
        LOG.info("--PositionChangeDetailTask execute events query by excludeIds : {}", excludeIds);
        DynamicObject[] events = HisEventRepository.getInstance().getEventDetailDataByExcludeEventIds(excludeIds);
        if (events == null || events.length <= 0) {
            LOG.info("--PositionChangeDetailTask execute has no events data");
            return;
        }
        List<DynamicObject> eventsBatch = this.getEmptyList(events.length, 0);
        for (int index = 0; index < events.length; ++index) {
            eventsBatch.add(events[index]);
            if (eventsBatch.size() < MAX_BATCH && index != events.length - 1) continue;
            this.doEventService(eventsBatch);
            eventsBatch = this.getEmptyList(events.length, index);
        }
        LOG.info("--PositionChangeDetailTask execute time : {}", (Object)(System.currentTimeMillis() - startTime));
    }

    private void doEventService(List<DynamicObject> events) {
        Set<Long> eventIds = events.stream().map(data -> data.getLong("event")).collect(Collectors.toSet());
        DynamicObject[] opDetails = HisEventRepository.getInstance().getOpDetailDataByEventIds(eventIds);
        if (opDetails == null || opDetails.length <= 0) {
            LOG.info("--PositionChangeDetailTask execute current batch has no opDetails data");
            return;
        }
        HashSet<Long> positionIds = new HashSet<Long>(opDetails.length * 2);
        Arrays.stream(opDetails).forEach(data -> {
            Long afterPositionId;
            Long beforePositionId = data.getLong("beforeposition");
            if (beforePositionId != null && beforePositionId > 0L) {
                positionIds.add(beforePositionId);
            }
            if ((afterPositionId = Long.valueOf(data.getLong("afterposition"))) != null && afterPositionId > 0L) {
                positionIds.add(afterPositionId);
            }
        });
        LOG.info("--PositionChangeDetailTask execute current batch positionIds : {}", positionIds);
        if (positionIds.size() <= 0) {
            return;
        }
        String queryProps = this.getQueryProps();
        DynamicObject[] positions = PositionQueryRepository.getInstance().queryPositionsPropsByIds(queryProps, positionIds);
        Map<Object, Object> positionDataMap = new HashMap(8);
        if (positions != null && positions.length > 0) {
            MainEntityType dataEntityTypePosition = MetadataServiceHelper.getDataEntityType((String)"hbpm_positionhr");
            ArrayList<DynamicObject> positionDatas = new ArrayList<DynamicObject>(positions.length);
            for (DynamicObject pos : positions) {
                DynamicObject newPosition = new DynamicObject((DynamicObjectType)dataEntityTypePosition);
                HRDynamicObjectUtils.copy((DynamicObject)pos, (DynamicObject)newPosition);
                newPosition.set("id", pos.get("id"));
                positionDatas.add(newPosition);
            }
            positionDataMap = positionDatas.stream().collect(Collectors.toMap(data -> data.getLong("id"), v1 -> v1, (v1, v2) -> v2));
        }
        Map<Long, List<DynamicObject>> opDetailMap = Arrays.stream(opDetails).collect(Collectors.groupingBy(data -> data.getLong("event")));
        ArrayList changeDetails = Lists.newArrayListWithExpectedSize((int)events.size());
        for (DynamicObject event : events) {
            List<DynamicObject> eventOpDetails;
            Long eventId = event.getLong("event");
            if (eventId == null || eventId <= 0L || (eventOpDetails = opDetailMap.get(eventId)) == null || eventOpDetails.size() <= 0) continue;
            Long modifier = event.getLong("creator.id");
            Long changeTypeId = event.getLong("changetype.id");
            Long changeSceneId = event.getLong("changescene.id");
            Long changeReasonId = event.getLong("changereason.id");
            for (DynamicObject eventOpDetail : eventOpDetails) {
                Long boid = eventOpDetail.getLong("position");
                DynamicObject beforeDyn = (DynamicObject)positionDataMap.get(eventOpDetail.getLong("beforeposition"));
                DynamicObject afterDyn = (DynamicObject)positionDataMap.get(eventOpDetail.getLong("afterposition"));
                Date operateTime = eventOpDetail.getDate("createtime");
                Long changeOperateId = eventOpDetail.getLong("changeoperate.id");
                Date changeDate = eventOpDetail.getDate("changedate");
                changeDetails.add(new ChangeDetailEntity(boid, beforeDyn, afterDyn, eventId, operateTime, modifier, changeOperateId, changeTypeId, changeSceneId, changeReasonId, changeDate, null));
            }
        }
        LOG.info("--PositionChangeDetailTask execute current batch changeDetails size : {}", (Object)changeDetails.size());
        PositionChangeDetailServiceImpl service = new PositionChangeDetailServiceImpl();
        if (changeDetails.size() > 0) {
            service.saveChangeDetail(changeDetails);
        }
    }

    private List<DynamicObject> getEmptyList(int size, int index) {
        ArrayList<DynamicObject> eventsBatch = new ArrayList<DynamicObject>(this.calSize(size, index));
        return eventsBatch;
    }

    private int calSize(int size, int index) {
        if (size <= 0 || size <= index) {
            return 0;
        }
        if (size - index > MAX_BATCH) {
            return MAX_BATCH;
        }
        return size - index;
    }

    private String getQueryProps() {
        MainEntityType dataEntityTypeDetail = MetadataServiceHelper.getDataEntityType((String)"hbpm_positionhr");
        DataEntityPropertyCollection props = dataEntityTypeDetail.getProperties();
        HashSet propCols = new HashSet(props.size());
        props.stream().forEach(prop -> {
            String name = prop.getName();
            if (!prop.isDbIgnore() && !PositionDetailConstants.EXCLUDEPROPS.contains(name)) {
                propCols.add(name);
            }
        });
        String result = StringUtils.join((Object[])propCols.toArray(), (String)",");
        result = result + "initdatasource,initstatus,initbatch,modifier,creator,createtime,modifytime,org,bsed";
        return result;
    }
}

