/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hrmp.hbpm.business.domain.repository.position.SyncPositionLogRepository;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;
import kd.hrmp.hbpm.common.enums.position.SyncStatusEnum;

public class PositionSynBosTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(PositionSynBosTask.class);
    private static final Integer MAX_RETRY_COUNT = 3;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("PositionSynBosTask_execute_start");
        SyncPositionLogRepository syncPosLogRep = SyncPositionLogRepository.getRepository();
        QFilter qFilter = new QFilter("syncstatus", "in", Arrays.asList(SyncStatusEnum.WAIT_SYNC.getCode(), SyncStatusEnum.SYNCING.getCode(), SyncStatusEnum.SYNC_FAILED.getCode(), SyncStatusEnum.PARENT_WAIT_SYNC.getCode()));
        qFilter.and("retrycount", "<", (Object)MAX_RETRY_COUNT);
        DynamicObject[] dys = syncPosLogRep.queryOriginalArray("position,parent,servicename", new QFilter[]{qFilter});
        LOGGER.info("query_result:{}", dys != null ? Integer.valueOf(dys.length) : "null");
        if (dys != null && dys.length > 0) {
            Map<String, List<DynamicObject>> synLogMap = Arrays.stream(dys).collect(Collectors.groupingBy(val -> val.getString("servicename")));
            List<DynamicObject> list = synLogMap.get("addOrUpdatePosition");
            if (list != null) {
                List<DynamicObject> sortList = this.sortFromHighToLow(list);
                List<Long> positionIds = sortList.stream().map(val -> val.getLong("position")).collect(Collectors.toList());
                IBosPositionService.getInstance().addOrUpdatePositions(positionIds);
            }
            for (Map.Entry<String, List<DynamicObject>> entry : synLogMap.entrySet()) {
                String serviceName = entry.getKey();
                LOGGER.info("syn_serviceName:{}, size:{}", (Object)serviceName, (Object)entry.getValue().size());
                if ("addOrUpdatePosition".equals(serviceName)) continue;
                List<Long> positionIds = entry.getValue().stream().map(val -> val.getLong("position")).collect(Collectors.toList());
                if ("enablePosition".equals(serviceName)) {
                    IBosPositionService.getInstance().enablePositions(positionIds);
                    continue;
                }
                if ("disablePosition".equals(serviceName)) {
                    IBosPositionService.getInstance().disablePositions(positionIds);
                    continue;
                }
                LOGGER.warn("not_support_type:{}", (Object)serviceName);
            }
        }
        LOGGER.info("PositionSynBosTask_execute_end");
    }

    private List<DynamicObject> sortFromHighToLow(List<DynamicObject> syncPosLogs) {
        HashMap posIdToDataMap = Maps.newHashMapWithExpectedSize((int)syncPosLogs.size());
        HashMap posIdToParentMap = Maps.newHashMapWithExpectedSize((int)syncPosLogs.size());
        for (DynamicObject pos : syncPosLogs) {
            posIdToParentMap.put(pos.getLong("position"), pos.getLong("parent"));
            posIdToDataMap.put(pos.getLong("position"), pos);
        }
        ArrayList sortDataList = Lists.newArrayListWithExpectedSize((int)syncPosLogs.size());
        HashSet<Long> inCrurentCreateSets = new HashSet<Long>(syncPosLogs.size());
        for (DynamicObject pos : syncPosLogs) {
            long posId = pos.getLong("position");
            this.addDataFromHighToLow(posId, posIdToParentMap, posIdToDataMap, sortDataList, inCrurentCreateSets);
        }
        return sortDataList;
    }

    private void addDataFromHighToLow(long posId, Map<Long, Long> posParentBoIdMap, Map<Long, DynamicObject> posIdToDataMap, List<DynamicObject> sortDataList, Set<Long> inCrurentCreateSets) {
        inCrurentCreateSets.add(posId);
        DynamicObject data = posIdToDataMap.get(posId);
        Long parent = posParentBoIdMap.get(posId);
        if (parent == null || parent == 0L) {
            if (!sortDataList.contains(data)) {
                sortDataList.add(data);
            }
            return;
        }
        DynamicObject parentData = posIdToDataMap.get(parent);
        if (parentData == null || sortDataList.contains(parentData)) {
            if (!sortDataList.contains(data)) {
                sortDataList.add(data);
            }
            return;
        }
        if (inCrurentCreateSets.contains(parent)) {
            LOGGER.info("inCrurentCreateSets:{}", (Object)parent);
        } else {
            this.addDataFromHighToLow(parent, posParentBoIdMap, posIdToDataMap, sortDataList, inCrurentCreateSets);
        }
        if (!sortDataList.contains(data)) {
            sortDataList.add(data);
        }
    }
}

