/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.task;

import java.util.Arrays;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hrmp.hbpm.business.domain.repository.position.PositionTplFieldRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionTplRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionTplTypeRepository;

public class PositionTplUpgradeTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(PositionTplUpgradeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("start execute positionTplUpgrade");
        Long rootOrgId = this.getRootOrgId();
        if (rootOrgId == 0L) {
            LOGGER.info("execute positionTplUpgrade terminal ");
            return;
        }
        try (TXHandle required = TX.required();){
            try {
                this.upgradePositionTpl(rootOrgId);
                this.upgradePositionTplType(rootOrgId);
            }
            catch (Exception ex) {
                required.markRollback();
                LOGGER.error("PositionTplUpgradeTask upgrade error", (Throwable)ex);
            }
        }
        LOGGER.info("start disable task");
        this.disableTask();
        LOGGER.info("end disable task");
    }

    private Long getRootOrgId() {
        LOGGER.info("start getRootOrgId");
        long rootOrgId = 0L;
        try {
            OrgTreeParam param = new OrgTreeParam();
            param.setOrgViewNumber("21");
            Map rootInfoMap = OrgUnitServiceHelper.getTreeRootNodeMapById((OrgTreeParam)param);
            rootOrgId = rootInfoMap.getOrDefault("id", 0L);
        }
        catch (Exception exception) {
            LOGGER.error("getRootOrgId error errorinfo:", (Throwable)exception);
        }
        return rootOrgId;
    }

    private void upgradePositionTpl(Long orgId) {
        DynamicObject[] tplDatas = PositionTplRepository.getInstance().queryUpgradeData();
        if (tplDatas == null || tplDatas.length == 0) {
            return;
        }
        DynamicObject[] fields = PositionTplFieldRepository.getInstance().queryAll();
        Arrays.asList(tplDatas).forEach(temp -> {
            temp.set("org", (Object)orgId);
            temp.set("status", (Object)"C");
            temp.set("issetscope", (Object)"1");
            temp.set("ablemodifyfield", (Object)"1");
            DynamicObjectCollection fieldrangeDynCollection = temp.getDynamicObjectCollection("fieldrange");
            fieldrangeDynCollection.clear();
            DynamicObjectType fieldrangeDynType = fieldrangeDynCollection.getDynamicObjectType();
            for (DynamicObject field : fields) {
                DynamicObject fieldrangeDyn = new DynamicObject(fieldrangeDynType);
                fieldrangeDyn.set("fbasedataid", (Object)temp.getLong("id"));
                fieldrangeDyn.set("fbasedataid_id", (Object)field.getLong("id"));
                fieldrangeDynCollection.add((Object)fieldrangeDyn);
            }
            DynamicObjectCollection applicationscope = temp.getDynamicObjectCollection("applicationscope");
            applicationscope.clear();
            DynamicObjectType applicationscopeType = applicationscope.getDynamicObjectType();
            DynamicObject dynamicObject = new DynamicObject(applicationscopeType);
            dynamicObject.set("adminorg", (Object)orgId);
            dynamicObject.set("containssubordinate", (Object)"1");
            applicationscope.add((Object)dynamicObject);
        });
        PositionTplRepository.getInstance().update(tplDatas);
    }

    private void upgradePositionTplType(Long orgId) {
        DynamicObject[] tplTypeDatas = PositionTplTypeRepository.getInstance().queryUpgradeData();
        Arrays.asList(tplTypeDatas).forEach(temp -> {
            temp.set("createorg", (Object)orgId);
            temp.set("org", (Object)orgId);
            temp.set("useorg", (Object)orgId);
            temp.set("ctrlstrategy", (Object)"5");
            temp.set("status", (Object)"C");
        });
        PositionTplTypeRepository.getInstance().updateTplType(tplTypeDatas);
    }

    private void disableTask() {
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob("3QR42V9Z8FSZ");
        scheduleManager.disableSchedule("3QR47UQ=613Y");
    }
}

