/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.domain.repository.position.HBPMMsgRepository;
import kd.hrmp.hbpm.common.constants.PublishConstants;

public class PublishTask
extends AbstractTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(PublishTask.class);
    private List<DynamicObject> msgList;
    private Map<Long, List<Map<String, String>>> actionConsumerMap = Maps.newHashMapWithExpectedSize((int)8);

    public PublishTask() {
    }

    public PublishTask(List<DynamicObject> msgList) {
        this.msgList = msgList;
    }

    @Override
    public void run() {
        this.publish(this.msgList, false);
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] syncMsgList = HBPMMsgRepository.getInstance().querySyncData();
        this.syncRecStatus(syncMsgList);
        DynamicObject[] sendstateSyncList = HBPMMsgRepository.getInstance().querySendstateSyncData();
        this.syncSendstate(sendstateSyncList);
    }

    private void syncRecStatus(DynamicObject[] msgList) {
        if (msgList == null) {
            return;
        }
        Map<String, Map<String, Object>> msgNoToDataMapMap = this.getMsgCenterData(msgList);
        for (DynamicObject msg : msgList) {
            Map<String, Object> dataMap;
            String msgNo = msg.getString("number");
            DynamicObjectCollection entry = msg.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entry) || (dataMap = msgNoToDataMapMap.get(msgNo)) == null) continue;
            List subList = (List)dataMap.get("dataList");
            for (Map sub : subList) {
                long subscribeBD = (Long)sub.get("subscribeBD");
                String recStatus = (String)sub.get("recStatus");
                for (DynamicObject entryDyn : entry) {
                    long entrySubscribebd = entryDyn.getLong("subscribebd.id");
                    if (entrySubscribebd != subscribeBD) continue;
                    entryDyn.set("recstatus", (Object)recStatus);
                }
            }
        }
        HBPMMsgRepository.getInstance().saveBatch(Arrays.asList(msgList));
    }

    private Map<String, Map<String, Object>> getMsgCenterData(DynamicObject[] msgList) {
        if (msgList == null || msgList.length == 0) {
            return new HashMap<String, Map<String, Object>>();
        }
        ArrayList paramsList = Lists.newArrayListWithExpectedSize((int)msgList.length);
        for (DynamicObject msg : msgList) {
            String msgNo = msg.getString("number");
            long actionId = this.getMsgActionId(msg);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("msgNumber", msgNo);
            paramMap.put("actionId", actionId);
            paramsList.add(paramMap);
        }
        if (paramsList.size() == 0) {
            return new HashMap<String, Map<String, Object>>();
        }
        List<Map<String, Object>> dataList = this.getSubRecStatus(paramsList);
        return dataList.stream().collect(Collectors.toMap(o -> o.get("msgNumber").toString(), o -> o, (o1, o2) -> o2));
    }

    private void syncSendstate(DynamicObject[] msgList) {
        Map<String, Map<String, Object>> msgNoToDataMapMap = this.getMsgCenterData(msgList);
        for (DynamicObject msg : msgList) {
            String msgNo = msg.getString("number");
            Map<String, Object> dataMap = msgNoToDataMapMap.get(msgNo);
            if (dataMap == null) continue;
            msg.set("sendstate", (Object)"1");
        }
        HBPMMsgRepository.getInstance().saveBatch(Arrays.asList(msgList));
    }

    public void publish(List<DynamicObject> msgList, boolean retry) {
        logger.info("msg_publish_start msg {}", (Object)msgList.size());
        if (CollectionUtils.isEmpty(msgList)) {
            return;
        }
        Date now = new Date();
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(msgList.size());
        String groupNumber = UUID.randomUUID().toString().replace("-", "");
        for (DynamicObject msg : msgList) {
            logger.info("msg_publish_start_foreach msg {}", (Object)msg.getLong("id"));
            if (retry) {
                msg.set("retrytimes", (Object)(msg.getInt("retrytimes") + 1));
                groupNumber = null;
            }
            int step = 0;
            long actionId = this.getMsgActionId(msg);
            try {
                logger.info("msg_publish_foreach_try");
                Map<String, Object> actionInfo = this.getPublishInfoMap(msg, now, groupNumber);
                List<Map<String, String>> subInfoList = this.getSubinfo(actionId);
                ++step;
                HRProducerServiceHelper.publishAction(actionInfo);
                this.setConsumerEntry(msg, subInfoList);
                msg.set("sendstate", (Object)"1");
            }
            catch (Exception ex) {
                if (step > 0 && this.isSendSuccess(msg.getString("number"), actionId)) {
                    msg.set("sendstate", (Object)"1");
                }
                String errorMsg = ex.getMessage();
                msg.set("sendstate", (Object)"2");
                logger.error(errorMsg);
                logger.error("pubmsg-error");
            }
            msg.set("lastsendtime", (Object)now);
            saveList.add(msg);
        }
        logger.info("msg_publish_end_foreach");
        HBPMMsgRepository.getInstance().saveBatch(saveList);
    }

    private List<Map<String, String>> getSubinfo(long actionId) {
        List subInfoList = this.actionConsumerMap.get(actionId);
        if (subInfoList == null) {
            Map<String, Object> pubAndSubInfo = this.getSimplePubAndSubInfo((String)PublishConstants.msgPubNoMap.get(actionId));
            subInfoList = (List)pubAndSubInfo.get("subInfoList");
            if (subInfoList == null) {
                subInfoList = Lists.newArrayListWithExpectedSize((int)8);
            }
            this.actionConsumerMap.put(actionId, subInfoList);
            return subInfoList;
        }
        return subInfoList;
    }

    private void setConsumerEntry(DynamicObject msg, List<Map<String, String>> subInfoList) {
        if (CollectionUtils.isEmpty(subInfoList)) {
            return;
        }
        DynamicObjectCollection consumerEntry = msg.getDynamicObjectCollection("entryentity");
        for (Map<String, String> consumer : subInfoList) {
            DynamicObjectType entryType = consumerEntry.getDynamicObjectType();
            DynamicObject row = new DynamicObject(entryType);
            row.set("consumercloud", (Object)consumer.get("consumerCloudId"));
            row.set("consumerapp", (Object)consumer.get("consumerAppId"));
            row.set("subscribebd", (Object)consumer.get("businessTypeId"));
            row.set("recstatus", (Object)"C");
            consumerEntry.add((Object)row);
        }
    }

    private Map<String, Object> getSimplePubAndSubInfo(String msgPubNo) {
        return (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSMsgService", (String)"getSimplePubAndSubInfo", (Object[])new Object[]{msgPubNo});
    }

    private List<Map<String, Object>> getSubRecStatus(List<Map<String, Object>> paramsList) {
        List list = Lists.partition(paramsList, (int)500);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)paramsList.size());
        for (List paramsSubList : list) {
            try {
                result.addAll((Collection)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSMsgService", (String)"getMsgCenterListInfo", (Object[])new Object[]{paramsSubList}));
            }
            catch (Exception ex) {
                return Lists.newArrayListWithExpectedSize((int)8);
            }
        }
        return result;
    }

    private boolean isSendSuccess(String msgNumber, long actionId) {
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)8);
        filters.add(new QFilter("number", "=", (Object)msgNumber));
        filters.add(new QFilter("action", "=", (Object)actionId));
        return (Boolean)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSMsgService", (String)"validateMsgIsDuplicate", (Object[])new Object[]{filters.toArray(new QFilter[0])});
    }

    private Map<String, Object> getPublishInfoMap(DynamicObject msg, Date now, String groupNumber) {
        String msgNumber = msg.getString("number");
        long actionId = this.getMsgActionId(msg);
        String msgTitle = msg.getString("msgtitle");
        String msgTag = msg.getString("msgtag");
        String msgDesc = msg.getString("msgdesc");
        HashMap actionInfo = Maps.newHashMapWithExpectedSize((int)16);
        actionInfo.put("msgNumber", msgNumber);
        actionInfo.put("actionId", actionId);
        actionInfo.put("senderId", 1L);
        actionInfo.put("sendTime", now);
        actionInfo.put("msgPubNo", PublishConstants.msgPubNoMap.get(actionId));
        actionInfo.put("msgTitle", msgTitle);
        actionInfo.put("params", msg.getString("msgparams"));
        actionInfo.put("msgDesc", msgDesc);
        actionInfo.put("msgTag", msgTag);
        if (HRStringUtils.isNotEmpty((String)groupNumber)) {
            actionInfo.put("groupNumber", groupNumber);
        }
        return actionInfo;
    }

    private long getMsgActionId(DynamicObject msg) {
        return (Long)PublishConstants.operateActionMap.get(msg.getLong("changeoperate.id"));
    }
}

