/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.utils;

import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hrmp.hbpm.business.utils.WorkRoleNewHisUtils;

public class DynamicObjectBuilder {
    private DynamicObject sourceDy;
    private DynamicObject targetDy;

    private DynamicObjectBuilder(String entityName) {
        this.targetDy = BusinessDataServiceHelper.newDynamicObject((String)entityName);
    }

    private DynamicObjectBuilder(String entityName, DynamicObject sourceDy) {
        this.targetDy = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        this.sourceDy = sourceDy;
    }

    public static DynamicObjectBuilder createBuilder(String entityName) {
        return new DynamicObjectBuilder(entityName);
    }

    public static DynamicObjectBuilder createBuilderWithSource(String entityName, DynamicObject sourceDy) {
        return new DynamicObjectBuilder(entityName, sourceDy);
    }

    public DynamicObjectBuilder set(String propName, Object value) {
        this.targetDy.set(propName, value);
        return this;
    }

    public DynamicObjectBuilder same(String propName) {
        this.targetDy.set(propName, this.sourceDy.get(propName));
        return this;
    }

    public DynamicObjectBuilder setFromSource(String targetPropName, String sourcePropName) {
        this.targetDy.set(targetPropName, this.sourceDy.get(sourcePropName));
        return this;
    }

    public DynamicObjectBuilder set(String targetPropName, Function<DynamicObject, Object> getValueFromSource) {
        this.targetDy.set(targetPropName, getValueFromSource.apply(this.sourceDy));
        return this;
    }

    public DynamicObjectBuilder setOnlyId(String targetPropName, String sourcePropName) {
        this.targetDy.set(targetPropName, (Object)WorkRoleNewHisUtils.smartGetId(this.sourceDy, sourcePropName));
        return this;
    }

    public DynamicObjectBuilder setOrg(String targetPropName, String sourcePropName) {
        this.targetDy.set(targetPropName, (Object)WorkRoleNewHisUtils.smartGetId(this.sourceDy, sourcePropName));
        return this;
    }

    public DynamicObject build() {
        return this.targetDy;
    }
}

