/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.utils;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class JobLevelAndJobGradeUtil {
    public static Map<String, Object> queryStdPostionOrPositionLevelAndGrade(DynamicObject[] positonDyns) {
        if (positonDyns == null || positonDyns.length == 0) {
            return JobLevelAndJobGradeUtil.buildSuccessResult(203, "can't find any position ,please give the correct positionIds", null);
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)positonDyns.length);
        HashSet<Long> allJobLevelScms = new HashSet<Long>();
        HashSet<Long> allJobGradeScms = new HashSet<Long>();
        HashMap positionToJobLevelScm = Maps.newHashMapWithExpectedSize((int)positonDyns.length);
        HashMap positionToJobGradeScm = Maps.newHashMapWithExpectedSize((int)positonDyns.length);
        Arrays.stream(positonDyns).forEach(dyn -> JobLevelAndJobGradeUtil.fillResultMap(map, allJobLevelScms, allJobGradeScms, positionToJobLevelScm, positionToJobGradeScm, dyn));
        if (allJobLevelScms.size() == 0 && allJobGradeScms.size() == 0) {
            return JobLevelAndJobGradeUtil.buildSuccessResult(200, "", map);
        }
        Map<Long, List<DynamicObject>> rangeOfJobLevel = JobLevelAndJobGradeUtil.queryRangeOfJobLevelOrGrade(allJobLevelScms, "hbjm_joblevelhr");
        Map<Long, List<DynamicObject>> rangeOfJobLGrade = JobLevelAndJobGradeUtil.queryRangeOfJobLevelOrGrade(allJobGradeScms, "hbjm_jobgradehr");
        for (Map.Entry longMapEntry : map.entrySet()) {
            Long positionId = (Long)longMapEntry.getKey();
            for (Map.Entry<String, List<DynamicObject>> entry : ((Map)longMapEntry.getValue()).entrySet()) {
                if (CollectionUtils.isEmpty((Collection)((Collection)entry.getValue())) || ((List)entry.getValue()).size() != 2) continue;
                List<DynamicObject> rangeList = JobLevelAndJobGradeUtil.getRangeList(((String)entry.getKey()).equals("joblevel") ? positionToJobLevelScm : positionToJobGradeScm, ((String)entry.getKey()).equals("joblevel") ? rangeOfJobLevel : rangeOfJobLGrade, positionId, entry);
                ((Map)longMapEntry.getValue()).put(entry.getKey(), rangeList);
            }
        }
        return JobLevelAndJobGradeUtil.buildSuccessResult(200, "", map);
    }

    private static Map<Long, List<DynamicObject>> queryRangeOfJobLevelOrGrade(Set<Long> ids, String entityName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        Map<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>();
        QFilter qFilter = null;
        DynamicObject[] dynamicObjects = null;
        switch (entityName) {
            case "hbjm_joblevelhr": {
                qFilter = new QFilter("joblevelscm", "in", ids);
                dynamicObjects = serviceHelper.query("id, number, name, description, enable, txtsimplename, entryboid, joblevelscm, joblevelseq", new QFilter[]{qFilter}, "joblevelseq asc");
                result = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dyn -> dyn.getLong("joblevelscm.id")));
                break;
            }
            case "hbjm_jobgradehr": {
                qFilter = new QFilter("jobgradescm", "in", ids);
                dynamicObjects = serviceHelper.query("id, number, name, description, enable, txtfsimplename, entryboid, jobgradescm, jobgradeseq", new QFilter[]{qFilter}, "jobgradeseq asc");
                result = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dyn -> dyn.getLong("jobgradescm.id")));
                break;
            }
        }
        return result;
    }

    private static void fillResultMap(Map<Long, Map<String, List<DynamicObject>>> map, Set<Long> allJobLevelScms, Set<Long> allJobGradeScms, Map<Long, Long> positionToJobLevelScm, Map<Long, Long> positionToJobGradeScm, DynamicObject dyn) {
        Map allData = map.getOrDefault(dyn.getLong("id"), new HashMap());
        List joblevel = allData.getOrDefault("joblevel", new ArrayList());
        List jobgrade = allData.getOrDefault("jobgrade", new ArrayList());
        DynamicObject lowjoblevel = dyn.getDynamicObject("lowjoblevel");
        DynamicObject highjoblevel = dyn.getDynamicObject("highjoblevel");
        DynamicObject lowjobgrade = dyn.getDynamicObject("lowjobgrade");
        DynamicObject highjobgrade = dyn.getDynamicObject("highjobgrade");
        JobLevelAndJobGradeUtil.putJobLevelOrJobGrade(allJobLevelScms, positionToJobLevelScm, dyn, joblevel, lowjoblevel, highjoblevel, "joblevelscm");
        JobLevelAndJobGradeUtil.putJobLevelOrJobGrade(allJobGradeScms, positionToJobGradeScm, dyn, jobgrade, lowjobgrade, highjobgrade, "jobgradescm");
        allData.put("joblevel", joblevel);
        allData.put("jobgrade", jobgrade);
        map.put(dyn.getLong("id"), allData);
    }

    private static void putJobLevelOrJobGrade(Set<Long> scms, Map<Long, Long> positionToJobLevelScm, DynamicObject dyn, List<DynamicObject> joblevel, DynamicObject lowjoblevel, DynamicObject highjoblevel, String whatScm) {
        if (!Objects.isNull(lowjoblevel) && lowjoblevel.getLong("id") != 0L && !Objects.isNull(highjoblevel) && highjoblevel.getLong("id") != 0L) {
            Long highId;
            Long lowId = lowjoblevel.getLong("id");
            if (lowId.equals(highId = Long.valueOf(highjoblevel.getLong("id")))) {
                joblevel.add(lowjoblevel);
            } else {
                joblevel.add(lowjoblevel);
                joblevel.add(highjoblevel);
                positionToJobLevelScm.put(dyn.getLong("id"), lowjoblevel.getDynamicObject(whatScm).getLong("id"));
                scms.add(lowjoblevel.getDynamicObject(whatScm).getLong("id"));
            }
        } else if ((Objects.isNull(lowjoblevel) || lowjoblevel.getLong("id") == 0L) && !Objects.isNull(highjoblevel) && highjoblevel.getLong("id") != 0L) {
            joblevel.add(highjoblevel);
        } else if ((Objects.isNull(highjoblevel) || highjoblevel.getLong("id") == 0L) && !Objects.isNull(lowjoblevel) && lowjoblevel.getLong("id") != 0L) {
            joblevel.add(lowjoblevel);
        }
    }

    private static List<DynamicObject> getRangeList(Map<Long, Long> positionTolScm, Map<Long, List<DynamicObject>> rangeOfJob, Long positionId, Map.Entry<String, List<DynamicObject>> idLists) {
        List<DynamicObject> dynamicObjects = rangeOfJob.get(positionTolScm.get(positionId));
        List<DynamicObject> value = idLists.getValue();
        Long startId = value.get(0).getLong("id");
        Long endId = value.get(1).getLong("id");
        ArrayList<DynamicObject> rangeList = new ArrayList<DynamicObject>();
        boolean start = false;
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (endId.equals(dynamicObject.getLong("id"))) {
                rangeList.add(dynamicObject);
                break;
            }
            if (startId.equals(dynamicObject.getLong("id"))) {
                start = true;
                rangeList.add(dynamicObject);
                continue;
            }
            if (!start) continue;
            rangeList.add(dynamicObject);
        }
        return rangeList;
    }

    public static Map<String, Object> buildSuccessResult(int code, String errMsg, Object data) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        result.put("code", code);
        result.put("ErrMsg", errMsg);
        result.put("data", data);
        return result;
    }
}

