/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.common.constants.JobLevelGradeRangeEnum;
import kd.hrmp.hbpm.common.constants.JobLevelGradeTextEnum;
import kd.hrmp.hbpm.common.util.HRDyObjectUtils;

public class JobLevelGradeRangeCheck {
    private static final Log LOGGER = LogFactory.getLog(JobLevelGradeRangeCheck.class);
    private static Map<String, Supplier<String>> maps = Maps.newHashMapWithExpectedSize((int)14);

    public JobLevelGradeRangeCheck() {
        this.initMessageTips();
    }

    public List<String> checkJobSystemRelatedInfo(DynamicObject dy, HasPermOrgResult posHasPermOrg, Map<Long, Map<String, List<Long>>> scmBu) {
        Long bu = dy.getLong("orgdesignbu.id");
        DynamicObject jobScm = dy.getDynamicObject("jobscm");
        Map<Object, Object> map = Maps.newHashMap();
        List list = Lists.newArrayListWithExpectedSize((int)10);
        LinkedList<String> results = new LinkedList<String>();
        if (bu != 0L) {
            List org;
            if (!(posHasPermOrg.hasAllOrgPerm() || !CollectionUtils.isEmpty((Collection)(org = posHasPermOrg.getHasPermOrgs())) && org.contains(bu))) {
                results.add(ResManager.loadKDString((String)"\u804c\u4f4d\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u7684\u201c\u7f16\u7801\u201d\u65e0\u6548\u3002", (String)"JobLevelGradeRangeUtil_21", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                return results;
            }
            if (!CollectionUtils.isEmpty(scmBu)) {
                map = scmBu.get(bu);
            }
            if (null != jobScm && (CollectionUtils.isEmpty((Map)map) || CollectionUtils.isEmpty((Collection)(list = (List)map.get("hbjm_jobscmhr"))) || !list.contains(jobScm.getLong("id")))) {
                results.add(ResManager.loadKDString((String)"\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u7684\u201c\u7f16\u7801\u201d\u4e0e\u804c\u4f4d\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u7684\u201c\u7f16\u7801\u201d\u4e0d\u5339\u914d\u3002", (String)"JobLevelGradeRangeUtil_22", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                return results;
            }
        } else if (this.isContainedFiledNotEmpty(dy, "jobscm,jobgradescm,joblevelscm").booleanValue()) {
            results.add(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u804c\u4f4d\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"JobLevelGradeRangeUtil_2", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            return results;
        }
        if (!this.checkLevelGradeInputText(dy, JobLevelGradeTextEnum.LEVEL)) {
            results.add(ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7ea7\u201d\u201c\u6700\u9ad8\u804c\u7ea7\u201d\u65e0\u6548\u3002", (String)"JobLevelGradeRangeUtil_4", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        }
        if (!this.checkLevelGradeInputText(dy, JobLevelGradeTextEnum.GRADE)) {
            results.add(ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7b49\u201d\u201c\u6700\u9ad8\u804c\u7b49\u201d\u65e0\u6548\u3002", (String)"JobLevelGradeRangeUtil_5", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        }
        if (!results.isEmpty()) {
            return results;
        }
        DynamicObject jobGradeScm = dy.getDynamicObject("jobgradescm");
        DynamicObject jobLevelScm = dy.getDynamicObject("joblevelscm");
        if (Objects.isNull(jobScm)) {
            if (this.isContainedFiledNotEmpty(dy, "job").booleanValue()) {
                results.add(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u201d\u3002", (String)"JobLevelGradeRangeUtil_3", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                return results;
            }
            if (Objects.isNull(jobGradeScm) && this.isContainedFiledNotEmpty(dy, "lowjobgrade,lowjobgradetext,highjobgrade,highjobgradetext,jobgraderange").booleanValue()) {
                results.add(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u201d\u6216\u201c\u804c\u7b49\u65b9\u6848\u201d\u3002", (String)"JobLevelGradeRangeUtil_1", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
            if (Objects.isNull(jobLevelScm) && this.isContainedFiledNotEmpty(dy, "lowjoblevel,highjoblevel,lowjobleveltext,highjobleveltext,joblevelrange").booleanValue()) {
                results.add(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u201d\u6216\u201c\u804c\u7b49\u65b9\u6848\u201d\u3002", (String)"JobLevelGradeRangeUtil_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
            if (!results.isEmpty()) {
                return results;
            }
        } else {
            if (Objects.nonNull(jobLevelScm)) {
                results.add(ResManager.loadKDString((String)"\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u7684\u201c\u7f16\u7801\u201d\u548c\u804c\u7ea7\u65b9\u6848\u7684\u201c\u7f16\u7801\u201d\u4e0d\u80fd\u540c\u65f6\u6709\u503c\u3002", (String)"JobLevelGradeRangeUtil_19", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
            if (Objects.nonNull(jobGradeScm)) {
                results.add(ResManager.loadKDString((String)"\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u7684\u201c\u7f16\u7801\u201d\u548c\u804c\u7b49\u65b9\u6848\u7684\u201c\u7f16\u7801\u201d\u4e0d\u80fd\u540c\u65f6\u6709\u503c\u3002", (String)"JobLevelGradeRangeUtil_20", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
            if (!results.isEmpty()) {
                return results;
            }
            Long jobScmId = dy.getLong("job.jobscm.id");
            if (jobScmId != 0L && !jobScmId.equals(jobScm.getLong("id"))) {
                results.add(ResManager.loadKDString((String)"\u804c\u4f4d\u7684\u201c\u7f16\u7801\u201d\u4e0e\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u7684\u201c\u7f16\u7801\u201d\u4e0d\u5339\u914d\u3002", (String)"JobLevelGradeRangeUtil_12", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                return results;
            }
        }
        if (!CollectionUtils.isEmpty(scmBu)) {
            map = scmBu.get(bu);
        }
        if (null != jobGradeScm && (CollectionUtils.isEmpty(map) || CollectionUtils.isEmpty((Collection)(list = (List)map.get("hbjm_jobgradescmhr"))) || !list.contains(jobGradeScm.getLong("id")))) {
            results.add(ResManager.loadKDString((String)"\u804c\u7b49\u65b9\u6848\u7684\u201c\u7f16\u7801\u201d\u4e0e\u804c\u4f4d\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u7684\u201c\u7f16\u7801\u201d\u4e0d\u5339\u914d\u3002", (String)"JobLevelGradeRangeUtil_23", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        }
        if (null != jobLevelScm && (CollectionUtils.isEmpty(map) || CollectionUtils.isEmpty((Collection)(list = (List)map.get("hbjm_joblevelscmhr"))) || !list.contains(jobLevelScm.getLong("id")))) {
            results.add(ResManager.loadKDString((String)"\u804c\u7ea7\u65b9\u6848\u7684\u201c\u7f16\u7801\u201d\u4e0e\u804c\u4f4d\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u7684\u201c\u7f16\u7801\u201d\u4e0d\u5339\u914d\u3002", (String)"JobLevelGradeRangeUtil_24", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        }
        return results;
    }

    protected boolean checkLevelGradeInputText(DynamicObject dy, JobLevelGradeTextEnum enu) {
        String value = dy.getString(enu.getTextSign());
        String lowText = value.contains(enu.getLowTextNullSign()) ? "NULL" : dy.getString(enu.getLowTextSign());
        String highText = value.contains(enu.getHighTextNullSign()) ? "NULL" : dy.getString(enu.getHighTextSign());
        if (HRStringUtils.equals((String)lowText, (String)"NULL") && HRStringUtils.equals((String)highText, (String)"NULL")) {
            dy.set(enu.getLowSign(), null);
            dy.set(enu.getHighSign(), null);
            return true;
        }
        if (HRStringUtils.equalsIgnoreCase((String)lowText, (String)"NULL") && !HRStringUtils.equalsIgnoreCase((String)highText, (String)"NULL") || !HRStringUtils.equalsIgnoreCase((String)lowText, (String)"NULL") && HRStringUtils.equalsIgnoreCase((String)highText, (String)"NULL")) {
            LOGGER.info(MessageFormat.format("JobLevelGradeRangeCheck:{4},checkLevelGradeInputText errInfo {0}:{1},{2}:{3}", enu.getLowSign(), lowText, enu.getHighSign(), highText), (Object)dy.getString("number"));
            return false;
        }
        if (HRStringUtils.isNotEmpty((String)lowText) && HRStringUtils.isEmpty((String)highText)) {
            if (HRObjectUtils.isEmpty((Object)dy.getDynamicObject(enu.getHighSign()))) {
                dy.set(enu.getHighTextSign(), (Object)lowText);
            } else {
                dy.set(enu.getHighTextSign(), (Object)dy.getDynamicObject(enu.getHighSign()).getString("name"));
            }
        } else if (HRStringUtils.isNotEmpty((String)highText) && HRStringUtils.isEmpty((String)lowText)) {
            if (HRObjectUtils.isEmpty((Object)dy.getDynamicObject(enu.getLowSign()))) {
                dy.set(enu.getLowTextSign(), (Object)highText);
            } else {
                dy.set(enu.getLowTextSign(), (Object)dy.getDynamicObject(enu.getLowSign()).getString("name"));
            }
        }
        return true;
    }

    public void insertOldLevelGradeScm(DynamicObject dy, JobLevelGradeTextEnum enu) {
        String value = dy.getString(enu.getTextSign());
        String lowText = value.contains(enu.getLowTextNullSign()) ? "NULL" : dy.getString(enu.getLowTextSign());
        String highText = value.contains(enu.getHighTextNullSign()) ? "NULL" : dy.getString(enu.getHighTextSign());
        DynamicObject low = dy.getDynamicObject(enu.getLowSign());
        if (!HRObjectUtils.isEmpty((Object)dy.getDynamicObject(enu.getScmSign()))) {
            return;
        }
        if (!HRObjectUtils.isEmpty((Object)dy.getDynamicObject("jobscm"))) {
            return;
        }
        if (HRObjectUtils.isEmpty((Object)low)) {
            return;
        }
        if (HRStringUtils.equals((String)lowText, (String)"NULL") || HRStringUtils.equals((String)highText, (String)"NULL")) {
            return;
        }
        dy.set(enu.getScmSign(), (Object)low.getDynamicObject(enu.getScmSign()));
    }

    public String checkJobLevelGradeRangeValid(DynamicObject dy, JobLevelGradeRangeEnum rangeEnum) {
        DynamicObject low = dy.getDynamicObject(rangeEnum.getLowSign());
        DynamicObject high = dy.getDynamicObject(rangeEnum.getHighSign());
        if (Objects.isNull(low) && Objects.isNull(high)) {
            LOGGER.info(MessageFormat.format("JobLevelGradeRangeCheck:{2},checkJobLevelGradeRangeValid errInfo {0},{1} is null", rangeEnum.getLowSign(), rangeEnum.getHighSign()), (Object)dy.getString("number"));
            return maps.get(rangeEnum.getSign() + "AllNotFound").get();
        }
        if (Objects.isNull(low)) {
            LOGGER.info(MessageFormat.format("JobLevelGradeRangeCheck:{1},checkJobLevelGradeRangeValid errInfo {0} is null", rangeEnum.getLowSign()), (Object)dy.getString("number"));
            return maps.get(rangeEnum.getSign() + "LowNotFound").get();
        }
        if (Objects.isNull(high)) {
            LOGGER.info(MessageFormat.format("JobLevelGradeRangeCheck:{1},checkJobLevelGradeRangeValid errInfo {0} is null", rangeEnum.getHighSign()), (Object)dy.getString("number"));
            return maps.get(rangeEnum.getSign() + "HighNotFound").get();
        }
        if (this.getSeq(rangeEnum.getSeqSign(), low) > this.getSeq(rangeEnum.getSeqSign(), high)) {
            return maps.get(rangeEnum.getSign() + "HighLessThanLow").get();
        }
        return null;
    }

    public String checkJobRangeValid(JobLevelGradeRangeEnum rangeEnum, DynamicObject low, DynamicObject high) {
        if (Objects.isNull(low) && Objects.isNull(high)) {
            LOGGER.info(MessageFormat.format("checkJobRangeValid errInfo {0},{1} is null", rangeEnum.getLowSign(), rangeEnum.getHighSign()));
            return maps.get(rangeEnum.getSign() + "AllNotFound").get();
        }
        if (Objects.isNull(low)) {
            LOGGER.info(MessageFormat.format("checkJobRangeValid errInfo {0} is null", rangeEnum.getLowSign()));
            return maps.get(rangeEnum.getSign() + "LowNotFound").get();
        }
        if (Objects.isNull(high)) {
            LOGGER.info(MessageFormat.format("checkJobRangeValid errInfo {0} is null", rangeEnum.getHighSign()));
            return maps.get(rangeEnum.getSign() + "HighNotFound").get();
        }
        return null;
    }

    public String checkLevelGradeScmValid(DynamicObject levelGradeScm, String low, String high, JobLevelGradeRangeEnum rangeEnum) {
        if (HRObjectUtils.isEmpty((Object)levelGradeScm) && (HRStringUtils.isNotEmpty((String)low) || HRStringUtils.isNotEmpty((String)high))) {
            return maps.get(rangeEnum.getSign() + "AllNotFound").get();
        }
        return null;
    }

    public List<String> checkRangeWithInJobRange(DynamicObject dy, DynamicObject scmDy, DynamicObject jobByQuery, JobLevelGradeRangeEnum rangeEnum) {
        DynamicObject low = dy.getDynamicObject(rangeEnum.getLowSign());
        DynamicObject high = dy.getDynamicObject(rangeEnum.getHighSign());
        if (Objects.isNull(low) || Objects.isNull(high)) {
            return null;
        }
        LinkedList<String> result = new LinkedList<String>();
        DynamicObject rangeScm = dy.getDynamicObject(rangeEnum.getScmSign());
        if (Objects.isNull(rangeScm) && (Objects.isNull(scmDy) || Objects.isNull(rangeScm = scmDy.getDynamicObject(rangeEnum.getScmSign())))) {
            LOGGER.info(MessageFormat.format("JobLevelGradeRangeCheck:{0},checkRangeWithInJobRange high large than job", dy.getString("number")));
            result.add(maps.get(rangeEnum.getSign() + "ScmNotMatch").get());
            return result;
        }
        if (!HRObjectUtils.equals((Object)rangeScm, (Object)this.getLevelGradeParent(rangeEnum, low)) || !HRObjectUtils.equals((Object)rangeScm, (Object)this.getLevelGradeParent(rangeEnum, high))) {
            LOGGER.info(MessageFormat.format("JobLevelGradeRangeCheck:{3},checkRangeWithInJobRange errInfo :{0},{1},{2}", rangeScm.getPkValue(), low.getPkValue(), high.getPkValue()), (Object)dy.getString("number"));
            result.add(maps.get(rangeEnum.getSign() + "ScmNotMatch").get());
            return result;
        }
        if (Objects.nonNull(jobByQuery)) {
            DynamicObject lowQuery = jobByQuery.getDynamicObject(rangeEnum.getLowSign());
            DynamicObject highQuery = jobByQuery.getDynamicObject(rangeEnum.getHighSign());
            if (lowQuery != null && this.getSeq(rangeEnum.getSeqSign(), low) < this.getSeq(rangeEnum.getSeqSign(), lowQuery)) {
                LOGGER.info(MessageFormat.format("JobLevelGradeRangeCheck:{0},checkRangeWithInJobRange low less than job", dy.getString("number")));
                result.add(maps.get(rangeEnum.getSign() + "LowLessThanJob").get());
            }
            if (highQuery != null && this.getSeq(rangeEnum.getSeqSign(), high) > this.getSeq(rangeEnum.getSeqSign(), highQuery)) {
                LOGGER.info(MessageFormat.format("JobLevelGradeRangeCheck:{0},checkRangeWithInJobRange high large than job", dy.getString("number")));
                result.add(maps.get(rangeEnum.getSign() + "HighLargeThanJob").get());
            }
            if (!result.isEmpty()) {
                return result;
            }
        }
        return null;
    }

    private DynamicObject getLevelGradeParent(JobLevelGradeRangeEnum rangeEnum, DynamicObject dy) {
        return Objects.nonNull(dy.getParent()) ? (DynamicObject)dy.getParent() : dy.getDynamicObject(rangeEnum.getScmSign());
    }

    private int getSeq(String seqSign, DynamicObject low) {
        try {
            return low.getInt(seqSign);
        }
        catch (Exception e) {
            return low.getInt(seqSign.replace("_", ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMessageTips() {
        if (maps.size() > 0) {
            return;
        }
        JobLevelGradeRangeCheck jobLevelGradeRangeCheck = this;
        synchronized (jobLevelGradeRangeCheck) {
            if (maps.size() > 0) {
                return;
            }
            maps.put("joblevelAllNotFound", () -> ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7ea7\u201d\u201c\u6700\u9ad8\u804c\u7ea7\u201d\u65e0\u6548\u3002", (String)"JobLevelGradeRangeUtil_4", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            maps.put("jobgradeAllNotFound", () -> ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7b49\u201d\u201c\u6700\u9ad8\u804c\u7b49\u201d\u65e0\u6548\u3002", (String)"JobLevelGradeRangeUtil_5", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            maps.put("joblevelLowNotFound", () -> ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7ea7\u201d\u65e0\u6548\u3002", (String)"JobLevelGradeRangeUtil_6", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            maps.put("jobgradeLowNotFound", () -> ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7b49\u201d\u65e0\u6548\u3002", (String)"JobLevelGradeRangeUtil_7", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            maps.put("joblevelHighNotFound", () -> ResManager.loadKDString((String)"\u201c\u6700\u9ad8\u804c\u7ea7\u201d\u65e0\u6548\u3002", (String)"JobLevelGradeRangeUtil_8", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            maps.put("jobgradeHighNotFound", () -> ResManager.loadKDString((String)"\u201c\u6700\u9ad8\u804c\u7b49\u201d\u65e0\u6548\u3002", (String)"JobLevelGradeRangeUtil_9", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            maps.put("joblevelHighLessThanLow", () -> ResManager.loadKDString((String)"\u201c\u6700\u9ad8\u804c\u7ea7\u201d\u5fc5\u987b\u5927\u4e8e\u201c\u6700\u4f4e\u804c\u7ea7\u201d\u3002", (String)"JobLevelGradeRangeUtil_10", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            maps.put("jobgradeHighLessThanLow", () -> ResManager.loadKDString((String)"\u201c\u6700\u9ad8\u804c\u7b49\u201d\u5fc5\u987b\u5927\u4e8e\u201c\u6700\u4f4e\u804c\u7b49\u201d\u3002", (String)"JobLevelGradeRangeUtil_11", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            maps.put("joblevelLowLessThanJob", maps.get("joblevelLowNotFound"));
            maps.put("jobgradeLowLessThanJob", maps.get("jobgradeLowNotFound"));
            maps.put("joblevelHighLargeThanJob", maps.get("joblevelHighNotFound"));
            maps.put("jobgradeHighLargeThanJob", maps.get("jobgradeHighNotFound"));
            maps.put("joblevelScmNotMatch", maps.get("joblevelAllNotFound"));
            maps.put("jobgradeScmNotMatch", maps.get("jobgradeAllNotFound"));
        }
    }

    public Boolean isContainedFiledNotEmpty(DynamicObject dy, String fields) {
        return HRDyObjectUtils.isContainedFiledNotEmpty((DynamicObject)dy, (String)fields);
    }
}

