/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.utils;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.service.position.PositionServiceHelper;
import kd.hrmp.hbpm.business.utils.PermHelper;
import kd.hrmp.hbpm.common.constants.JobLevelGradeTextEnum;

public class JobLevelGradeRangeUtil {
    public static JobLevelGradeRangeUtil getInstance() {
        return CommonQueryInstance.INSTANCE;
    }

    public void registerListener(IFormView view, AbstractFormPlugin formPlugin, BeforeF7SelectListener listener) {
        formPlugin.addClickListeners(new String[]{"joblevelrange", "jobgraderange"});
        BasedataEdit jobScmEdit = (BasedataEdit)view.getControl("jobscm");
        jobScmEdit.addBeforeF7SelectListener(listener);
        BasedataEdit jobEdit = (BasedataEdit)view.getControl("job");
        jobEdit.addBeforeF7SelectListener(listener);
        BasedataEdit jobGradeScmEdit = (BasedataEdit)view.getControl("jobgradescm");
        jobGradeScmEdit.addBeforeF7SelectListener(listener);
        BasedataEdit jobLevelScmEdit = (BasedataEdit)view.getControl("joblevelscm");
        jobLevelScmEdit.addBeforeF7SelectListener(listener);
        BasedataEdit orgdesignbu = (BasedataEdit)view.getControl("orgdesignbu");
        orgdesignbu.addBeforeF7SelectListener(listener);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt, IDataModel model, IFormView view) {
        String fieldKey = evt.getProperty().getName();
        DynamicObject dataEntity = model.getDataEntity();
        if (Arrays.asList("jobscm", "joblevelscm", "jobgradescm").contains(fieldKey)) {
            Object bu = dataEntity.get("orgdesignbu");
            if (Objects.isNull(bu)) {
                evt.setCancel(true);
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u804c\u4f4d\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"JobLevelGradeRangeUtil_2", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
        } else if (HRStringUtils.equals((String)"job", (String)fieldKey)) {
            DynamicObject jobScm = dataEntity.getDynamicObject("jobscm");
            if (HRObjectUtils.isEmpty((Object)jobScm)) {
                evt.setCancel(true);
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u201d\u3002", (String)"JobLevelGradeRangeUtil_3", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getShowParameter().setCustomParam("selectedJobscmid", (Object)jobScm.getLong("id"));
            QFilter qFilter = new QFilter("jobscm", "=", (Object)jobScm.getLong("id"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else if (HRStringUtils.equals((String)"orgdesignbu", (String)fieldKey)) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(PermHelper.getHrPermFilter("homs_positionbill", "id"));
            showParameter.setCustomParam("isOrgF7TitleCustomized", (Object)"true");
            showParameter.setCustomParam("ServiceAppId", (Object)"hbpm");
            showParameter.setFormId("hbpm_burenamelistf7");
        }
    }

    public void closedCallBack(IDataModel model, Map<String, Object> returnData, String actionId) {
        if (returnData == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)"hjm_joblevelrange", (CharSequence)actionId)) {
            DynamicObject lowJobLevel = (DynamicObject)returnData.get("lowjoblevel");
            DynamicObject highJobLevel = (DynamicObject)returnData.get("highjoblevel");
            this.setFieldRange("joblevelrange", lowJobLevel, "lowjoblevel", highJobLevel, "highjoblevel", model);
        } else if (StringUtils.equals((CharSequence)"hjm_jobgraderange", (CharSequence)actionId)) {
            DynamicObject lowJobGrade = (DynamicObject)returnData.get("lowjobgrade");
            DynamicObject highJobGrade = (DynamicObject)returnData.get("highjobgrade");
            this.setFieldRange("jobgraderange", lowJobGrade, "lowjobgrade", highJobGrade, "highjobgrade", model);
        }
    }

    public void afterBindData(IDataModel model, IFormView view) {
        model.beginInit();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject jobScm = dataEntity.getDynamicObject("jobscm");
        DynamicObject highJobLevel = dataEntity.getDynamicObject("highjoblevel");
        DynamicObject lowJobLevel = dataEntity.getDynamicObject("lowjoblevel");
        DynamicObject highJobGrade = dataEntity.getDynamicObject("highjobgrade");
        DynamicObject lowJobGrade = dataEntity.getDynamicObject("lowjobgrade");
        if (Objects.isNull(jobScm)) {
            if (Objects.nonNull(highJobGrade)) {
                model.setValue("jobgradescm", (Object)highJobGrade.getLong("jobgradescm.id"));
            } else if (Objects.nonNull(lowJobGrade)) {
                model.setValue("jobgradescm", (Object)lowJobGrade.getLong("jobgradescm.id"));
            }
            if (Objects.nonNull(highJobLevel)) {
                model.setValue("joblevelscm", (Object)highJobLevel.getLong("joblevelscm.id"));
            } else if (Objects.nonNull(lowJobLevel)) {
                model.setValue("joblevelscm", (Object)lowJobLevel.getLong("joblevelscm.id"));
            }
        }
        this.setFieldRange("joblevelrange", lowJobLevel, "lowjoblevel", highJobLevel, "highjoblevel", model);
        this.setFieldRange("jobgraderange", lowJobGrade, "lowjobgrade", highJobGrade, "highjobgrade", model);
        view.updateView("joblevelrange");
        view.updateView("jobgraderange");
        this.dealWithGradeLevelScmView(model, view);
        model.endInit();
        model.setDataChanged(false);
    }

    public void propertyChanged(IDataModel model, IFormView view, String operationKey) {
        String value;
        if (HRStringUtils.equals((String)operationKey, (String)"orgdesignbu")) {
            model.setValue("jobscm", null);
            view.updateView("jobscm");
            this.clearFieldValueWithJobScm(model, view);
        } else if (HRStringUtils.equals((String)operationKey, (String)"jobscm")) {
            this.clearFieldValueWithJobScm(model, view);
        } else if (HRStringUtils.equals((String)operationKey, (String)"job")) {
            this.clearFieldValueWithJob(model, view);
        } else if (HRStringUtils.equals((String)operationKey, (String)"jobgradescm")) {
            this.clearJobGradeValue(model, view);
        } else if (HRStringUtils.equals((String)operationKey, (String)"joblevelscm")) {
            this.clearJobLevelValue(model, view);
        } else if (HRStringUtils.equals((String)operationKey, (String)"jobgraderange")) {
            String value2 = model.getDataEntity().getString("jobgraderange");
            if (HRStringUtils.isEmpty((String)value2)) {
                this.clearJobGradeValue(model, view);
            }
        } else if (HRStringUtils.equals((String)operationKey, (String)"joblevelrange") && HRStringUtils.isEmpty((String)(value = model.getDataEntity().getString("joblevelrange")))) {
            this.clearJobLevelValue(model, view);
        }
    }

    public void beforeImportData(DynamicObject dy, Map<String, Object> sourceData) {
        StringBuilder sb = new StringBuilder();
        this.appendNullTextSign(JobLevelGradeTextEnum.LEVEL, sb, sourceData);
        this.appendNullTextSign(JobLevelGradeTextEnum.GRADE, sb, sourceData);
        dy.set("levelgradetext", (Object)sb.toString());
    }

    private void appendNullTextSign(JobLevelGradeTextEnum enu, StringBuilder sb, Map<String, Object> sourceData) {
        if (sourceData.containsKey(enu.getLowTextSign()) && sourceData.get(enu.getLowTextSign()) == null) {
            sb.append(enu.getLowTextNullSign());
        }
        if (sourceData.containsKey(enu.getHighTextSign()) && sourceData.get(enu.getHighTextSign()) == null) {
            sb.append(enu.getHighTextNullSign());
        }
    }

    private void dealWithGradeLevelScmView(IDataModel model, IFormView view) {
        Boolean isEnabled = Boolean.TRUE;
        if (model.getDataEntity().getLong("jobscm.id") != 0L) {
            isEnabled = Boolean.FALSE;
        }
        view.setVisible(isEnabled, new String[]{"jobgradescm", "joblevelscm"});
        view.updateView("jobgradescm");
        view.updateView("joblevelscm");
    }

    private void clearFieldValueWithJobScm(IDataModel model, IFormView view) {
        model.setValue("job", null);
        view.updateView("job");
        model.setValue("jobgradescm", null);
        view.updateView("jobgradescm");
        model.setValue("joblevelscm", null);
        view.updateView("joblevelscm");
        this.dealWithGradeLevelScmView(model, view);
        this.clearFieldValueWithJob(model, view);
    }

    private void clearFieldValueWithJob(IDataModel model, IFormView view) {
        DynamicObject job = (DynamicObject)model.getValue("job");
        if (job != null) {
            DynamicObject lowJobLevel = job.getDynamicObject("lowjoblevel");
            DynamicObject highJobLevel = job.getDynamicObject("highjoblevel");
            this.setFieldRange("joblevelrange", lowJobLevel, "lowjoblevel", highJobLevel, "highjoblevel", model);
            view.updateView("joblevelrange");
            DynamicObject lowJobGrade = job.getDynamicObject("lowjobgrade");
            DynamicObject highJobGrade = job.getDynamicObject("highjobgrade");
            this.setFieldRange("jobgraderange", lowJobGrade, "lowjobgrade", highJobGrade, "highjobgrade", model);
            view.updateView("jobgraderange");
        } else {
            this.clearJobGradeValue(model, view);
            this.clearJobLevelValue(model, view);
        }
    }

    private void clearJobGradeValue(IDataModel model, IFormView view) {
        model.setValue("jobgraderange", null);
        model.setValue("highjobgrade", null);
        model.setValue("lowjobgrade", null);
        view.updateView("jobgraderange");
    }

    private void clearJobLevelValue(IDataModel model, IFormView view) {
        model.setValue("joblevelrange", null);
        model.setValue("highjoblevel", null);
        model.setValue("lowjoblevel", null);
        view.updateView("joblevelrange");
    }

    public void click(IDataModel model, IFormView view, String operationKey, IFormPlugin formPlugin) {
        if (StringUtils.equals((CharSequence)"joblevelrange", (CharSequence)operationKey) || StringUtils.equals((CharSequence)"jobgraderange", (CharSequence)operationKey)) {
            boolean isLevelEmpty;
            DynamicObject jobScm = model.getDataEntity().getDynamicObject("jobscm");
            DynamicObject jobGradeScm = model.getDataEntity().getDynamicObject("jobgradescm");
            DynamicObject jobLevelScm = model.getDataEntity().getDynamicObject("joblevelscm");
            boolean isGradeScmEmpty = StringUtils.equals((CharSequence)"jobgraderange", (CharSequence)operationKey) && Objects.isNull(jobGradeScm);
            boolean bl = isLevelEmpty = StringUtils.equals((CharSequence)"joblevelrange", (CharSequence)operationKey) && Objects.isNull(jobLevelScm);
            if (HRObjectUtils.isEmpty((Object)jobScm) && (isGradeScmEmpty || isLevelEmpty)) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u201d\u6216\u201c\u804c\u7b49\u65b9\u6848\u201d\u3002", (String)"JobLevelGradeRangeUtil_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
                if (isGradeScmEmpty) {
                    msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u201d\u6216\u201c\u804c\u7b49\u65b9\u6848\u201d\u3002", (String)"JobLevelGradeRangeUtil_1", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
                }
                view.showTipNotification(msg);
            } else {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.setCustomParamByJobRange(model, formPlugin, operationKey, showParameter);
                view.showForm(showParameter);
            }
        }
    }

    private void setCustomParamByJobRange(IDataModel model, IFormPlugin formPlugin, String operationKey, FormShowParameter showParameter) {
        DynamicObject position = model.getDataEntity();
        this.setPositionCustomParam(showParameter, position, "jobscmid", "jobscm.id");
        this.setPositionCustomParam(showParameter, position, "job", "job.id");
        if (StringUtils.equals((CharSequence)"joblevelrange", (CharSequence)operationKey)) {
            this.setPositionCustomParam(showParameter, position, "lowjoblevel", "lowjoblevel.id");
            this.setPositionCustomParam(showParameter, position, "highjoblevel", "highjoblevel.id");
            this.setPositionCustomParam(showParameter, position, "joblevelscm", "joblevelscm.id");
            showParameter.setFormId("hjm_joblevelrange");
            showParameter.setCloseCallBack(new CloseCallBack(formPlugin, "hjm_joblevelrange"));
        } else {
            this.setPositionCustomParam(showParameter, position, "lowjobgrade", "lowjobgrade.id");
            this.setPositionCustomParam(showParameter, position, "highjobgrade", "highjobgrade.id");
            this.setPositionCustomParam(showParameter, position, "jobgradescm", "jobgradescm.id");
            showParameter.setFormId("hjm_jobgraderange");
            showParameter.setCloseCallBack(new CloseCallBack(formPlugin, "hjm_jobgraderange"));
        }
    }

    private void setPositionCustomParam(FormShowParameter showParameter, DynamicObject dy, String key, String field) {
        if (Objects.isNull(dy)) {
            return;
        }
        Object value = dy.get(field);
        if (Objects.isNull(value)) {
            return;
        }
        if (value instanceof Long && (Long)value != 0L) {
            showParameter.setCustomParam(key, value);
        } else if (value instanceof Integer && (Integer)value != 0) {
            showParameter.setCustomParam(key, value);
        } else if (value instanceof String && !((String)value).isEmpty()) {
            showParameter.setCustomParam(key, value);
        }
    }

    public void setFieldRange(String fieldPositionObject, DynamicObject lowObject, String lowField, DynamicObject highObject, String highField, IDataModel model) {
        String lowPositionString = "";
        String highPositionString = "";
        if (lowObject != null) {
            lowPositionString = PositionServiceHelper.getLocalValue(lowObject, "name");
            model.setValue(lowField, (Object)lowObject.getLong("id"));
        }
        if (highObject != null) {
            highPositionString = PositionServiceHelper.getLocalValue(highObject, "name");
            model.setValue(highField, (Object)highObject.getLong("id"));
        }
        if (HRStringUtils.isEmpty((String)highPositionString) && HRStringUtils.isEmpty((String)lowPositionString)) {
            model.setValue(fieldPositionObject, (Object)"");
        } else if (HRStringUtils.isEmpty((String)highPositionString)) {
            model.setValue(fieldPositionObject, (Object)lowPositionString);
        } else if (HRStringUtils.isEmpty((String)lowPositionString)) {
            model.setValue(fieldPositionObject, (Object)highPositionString);
        } else if (HRStringUtils.equals((String)lowPositionString, (String)highPositionString)) {
            model.setValue(fieldPositionObject, (Object)highPositionString);
        } else {
            model.setValue(fieldPositionObject, (Object)(lowPositionString + "-" + highPositionString));
        }
    }

    private static class CommonQueryInstance {
        private static JobLevelGradeRangeUtil INSTANCE = new JobLevelGradeRangeUtil();

        private CommonQueryInstance() {
        }
    }
}

