/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.utils;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hrmp.hbpm.common.util.LocalDateRange;

public class LocalDateRangeUtils {
    public static LocalDateRange getEffectRange(DynamicObject dynamicObject) {
        return LocalDateRange.ofClosed((Date)dynamicObject.getDate("bsed"), (Date)dynamicObject.getDate("bsled"));
    }

    public static void setEffectRange(DynamicObject dynamicObject, LocalDateRange localDateRange) {
        dynamicObject.set("bsed", (Object)LocalDateRangeUtils.getStartDate(localDateRange));
        dynamicObject.set("bsled", (Object)LocalDateRangeUtils.getEndInclusiveDate(localDateRange));
    }

    public static Date getStartDate(LocalDateRange localDateRange) {
        return LocalDateRangeUtils.getDate(localDateRange.getStart());
    }

    public static Date getEndInclusiveDate(LocalDateRange localDateRange) {
        return LocalDateRangeUtils.getDate(localDateRange.getEndInclusive());
    }

    public static Date getDate(LocalDate localDate) {
        return Date.from(ZonedDateTime.of(localDate, LocalTime.MIN, ZoneId.systemDefault()).toInstant());
    }

    public static Date getMinDate(List<Date> dateList) {
        if (dateList != null && dateList.size() > 0) {
            if (dateList.size() > 1) {
                Optional minOpt = dateList.stream().reduce((bsed, bsed2) -> bsed.before((Date)bsed2) ? bsed : bsed2);
                return (Date)minOpt.get();
            }
            return dateList.get(0);
        }
        return null;
    }
}

