/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hrmp.hbpm.business.application.impl.projectrole.ProjectRoleApplicationImpl;
import kd.hrmp.hbpm.business.domain.repository.position.ProjectRoleQueryRepository;
import kd.hrmp.hbpm.business.domain.service.projectrole.ProRoleMsgService;
import kd.hrmp.hbpm.business.service.projectrole.ProjRoleChangeEvent;
import kd.hrmp.hbpm.business.utils.DynamicObjectBuilder;
import kd.hrmp.hbpm.business.utils.DynamicObjectChanger;
import kd.hrmp.hbpm.business.utils.WorkRoleConverter;
import kd.hrmp.hbpm.business.utils.WorkRoleNewHisUtils;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;

public class PRJRoleUtils
implements ProjectRoleConstants {
    private static final Log logger = LogFactory.getLog(PRJRoleUtils.class);

    public static DynamicObject createDutyRole4New(DynamicObject projectRole) {
        return DynamicObjectBuilder.createBuilderWithSource("hbpm_dutyworkroles", projectRole).same("name").same("number").same("enable").same("bsed").same("bsled").set("orgtype", 1020L).set("teamtype", 1010L).setFromSource("id", "boid").build();
    }

    public static DynamicObject createWorkRole4New(DynamicObject projectRole) {
        return DynamicObjectBuilder.createBuilderWithSource("hbpm_workroleshr", projectRole).same("id").same("name").same("number").same("enable").same("bsed").same("bsled").set("rolesourcetype", 1030L).set("orgtype", 1020L).set("teamtype", 1010L).setFromSource("mainpeoincharge", "isdutypers").setFromSource("roletype", "rolestype").setOnlyId("adminorg", "projteam").setOnlyId("position", "boid").setOrg("org", "org").set("rolesourcetype", ROLE_SOURCE_PROJECT).set("initstatus", "2").build();
    }

    public static DynamicObject createAdministrativeRelation4New(DynamicObject projectRole) {
        return DynamicObjectBuilder.createBuilderWithSource("hbpm_reportingrelation", projectRole).same("enable").same("bsed").same("bsled").set("reportingtype", 1010L).set("role", projectRole.getLong("boid")).set("parent", WorkRoleNewHisUtils.smartGetId(projectRole, "superroles")).set("sourcetype", 1030L).set("initstatus", "2").build();
    }

    public static List<DynamicObject> createNonAdministrativeRelation4New(DynamicObject projectRole, WorkRoleConverter workRoleConverter) {
        DynamicObjectCollection entry = projectRole.getDynamicObjectCollection("entryentity");
        List<DynamicObject> relations = entry.stream().map(PRJRoleUtils::createNonAdministrativeRelationFromEntry4New).collect(Collectors.toList());
        Object effectDate = projectRole.get("bsed");
        for (DynamicObject relation : relations) {
            relation.set("role", (Object)workRoleConverter.getWorkRoleId(projectRole.getLong("boid")));
            relation.set("enable", (Object)projectRole.getString("enable"));
            relation.set("bsed", effectDate);
            relation.set("initstatus", (Object)"2");
        }
        return relations;
    }

    public static DynamicObject createNonAdministrativeRelationFromEntry4New(DynamicObject projectRoleEntryRow) {
        return DynamicObjectBuilder.createBuilderWithSource("hbpm_reportingrelation", projectRoleEntryRow).same("parent").set("sourcetype", 1030L).setFromSource("reportingtype", "reportcoreltype").build();
    }

    public static void changeDutyRoles(DynamicObject dutyRole, DynamicObject projectRole) {
        DynamicObjectChanger.createChanger(dutyRole, projectRole).same("name").same("number").same("bsed").same("bsled");
    }

    public static void changeWorkRoles(DynamicObject workRole, DynamicObject projectRole) {
        DynamicObjectChanger.createChanger(workRole, projectRole).same("name").same("number").same("org").same("bsed").same("bsled").setFromSource("mainpeoincharge", "isdutypers").setFromSource("roletype", "rolestype").setOnlyId("adminorg", "projteam");
    }

    public static void changeAdministrativeRelation(DynamicObject relation, DynamicObject projectRole) {
        DynamicObjectChanger.createChanger(relation, projectRole).same("bsed").same("bsled").same("enable").set("parent", WorkRoleNewHisUtils.smartGetId(projectRole, "superroles")).set("parent_id", WorkRoleNewHisUtils.smartGetId(projectRole, "superroles"));
    }

    public static void changeNonAdministrativeRelation(DynamicObject relation, DynamicObject projectRoleEntryRow) {
        DynamicObjectChanger.createChanger(relation, projectRoleEntryRow).same("parent").setFromSource("bsed", "effectdate").setFromSource("reportingtype", "reportcoreltype");
    }

    public static void changeDy4Disable(DynamicObject targetDy, DynamicObject sourceDy) {
        DynamicObjectChanger.createChanger(targetDy, sourceDy).same("changedesc").same("changereason").same("changetype").same("bsed").set("disabledate", sourceDy.getDate("bsed")).set("enable", "0").set("createtime", new Date());
    }

    public static DynamicObject createProjectRoleFromPlanRole(DynamicObject rolePlanEntryRow) {
        return DynamicObjectBuilder.createBuilderWithSource("hbpm_projectroles", rolePlanEntryRow).setFromSource("name", "planname").setFromSource("number", "plannumber").same("rolestype").same("isdutypers").build();
    }

    public static void changeProjectRoleByRolePlanPage(DynamicObject roleProjectPageModel, DynamicObject projectRole) {
        DynamicObjectChanger.createChanger(roleProjectPageModel, projectRole).same("projteam").setFromSource("bsed", "bsed").setFromSource("design", "bsed").set("status", "C").set("enable", "1");
    }

    public static Map<Long, DynamicObject> getTeamIdVsMainRoleMap(List<Long> projectTeamIdList) {
        DynamicObject[] projectRoles = ProjectRoleQueryRepository.getInstance().queryMainRoleByProjectTeam(projectTeamIdList);
        return Arrays.stream(projectRoles).collect(Collectors.toMap(dy -> dy.getLong("projteam.id"), dy -> dy, (projectRole1, projectRole2) -> {
            throw new RuntimeException(String.format("multiple main role in the same project team, project team id:%s", projectRole1.getLong("projteam.id")));
        }));
    }

    public static Map<Long, List<DynamicObject>> getSuperRoleIdVsRoleMap(List<Long> roleIdList) {
        DynamicObject[] projectRoles = ProjectRoleQueryRepository.getInstance().queryBySuperRole(roleIdList);
        return Arrays.stream(projectRoles).collect(Collectors.groupingBy(dy -> WorkRoleNewHisUtils.smartGetId(dy, "superroles")));
    }

    public static Map<Long, List<DynamicObject>> getTeamIdVsSubLevelNonSuperMainRoleMap(List<Long> projectTeamIdList) {
        DynamicObject[] projectRoles = ProjectRoleQueryRepository.getInstance().querySubLevelNonSuperMainRoleByProjectTeam(projectTeamIdList);
        return Arrays.stream(projectRoles).collect(Collectors.groupingBy(dy -> dy.getLong("projteam.parentorg.id")));
    }

    public static boolean isDuty(DynamicObject projectRole) {
        return "true".equals(projectRole.getString("isdutypers"));
    }

    public static boolean isDutyOnlyWithPage(DynamicObject projectRole) {
        HRBaseServiceHelper roleHelper = new HRBaseServiceHelper("hbpm_projectroles");
        QFilter qFilter = new QFilter("id", "=", (Object)projectRole.getLong("id"));
        qFilter.and(new QFilter("isdutypers", "=", (Object)Boolean.TRUE));
        boolean exists = roleHelper.isExists(qFilter);
        boolean isDuty = "true".equals(projectRole.getString("isdutypers"));
        return !exists && isDuty;
    }

    public static Map<String, List<DynamicObject>> getProjectRoleByChangeMainDutyRole(DynamicObject newMainDutyRole, DynamicObject dbMainRole) {
        Date now = new Date();
        HashMap<String, List<DynamicObject>> changeMap = new HashMap<String, List<DynamicObject>>();
        ArrayList<DynamicObject> needChangeProjectRoleList = new ArrayList<DynamicObject>();
        long teamId = newMainDutyRole.getLong("projteam.id");
        if (dbMainRole != null) {
            dbMainRole.set("isdutypers", (Object)"0");
            dbMainRole.set("bsed", (Object)now);
            PRJRoleUtils.setRoleTypeDynByMainHead(dbMainRole, Boolean.FALSE);
            needChangeProjectRoleList.add(dbMainRole);
            ArrayList duty = Lists.newArrayListWithExpectedSize((int)8);
            duty.add(dbMainRole);
            changeMap.put("isdutypers", duty);
            long dbMainRoleId = dbMainRole.getLong("id");
            Map<Long, List<DynamicObject>> roleIdVsRolesMap = PRJRoleUtils.getSuperRoleIdVsRoleMap(Collections.singletonList(dbMainRoleId));
            List projectRoleList = roleIdVsRolesMap.getOrDefault(dbMainRoleId, new ArrayList());
            projectRoleList.forEach(dy -> {
                dy.set("superroles", (Object)newMainDutyRole);
                dy.set("bsed", (Object)now);
            });
            needChangeProjectRoleList.addAll(projectRoleList);
        } else {
            Map<Long, List<DynamicObject>> teamIdVsNonSuperNonMainRoleMap = PRJRoleUtils.getTeamIdVsSubLevelNonSuperMainRoleMap(Collections.singletonList(teamId));
            List projectRoleList = teamIdVsNonSuperNonMainRoleMap.getOrDefault(teamId, new ArrayList());
            projectRoleList.forEach(dy -> dy.set("superroles", (Object)newMainDutyRole));
            needChangeProjectRoleList.addAll(projectRoleList);
        }
        changeMap.put("allRole", needChangeProjectRoleList);
        return changeMap;
    }

    public static DynamicObject getDbMainDutyRoleDyn(Long proTeamId) {
        Map<Long, DynamicObject> teamIdVsMainRoleMap = PRJRoleUtils.getTeamIdVsMainRoleMap(Collections.singletonList(proTeamId));
        return teamIdVsMainRoleMap.get(proTeamId);
    }

    public static void setRoleTypeDynByMainHead(DynamicObject proRole, Boolean isMainHead) {
        HRBaseServiceHelper roleTypeHelper = new HRBaseServiceHelper("hbpm_roletype");
        DynamicObject roleTypeDyn = roleTypeHelper.generateEmptyDynamicObject();
        if (isMainHead.booleanValue()) {
            roleTypeDyn.set("id", (Object)1010L);
        } else {
            roleTypeDyn.set("id", (Object)1030L);
        }
        proRole.set("rolestype", (Object)roleTypeDyn);
    }

    public static HisResponse<VersionChangeRespData> newMainRoleWithSubstituteMainRole(DynamicObject mainRole, Long changeOperate, List<DynamicObject> hisRetDataList, Map<String, Object> mainDutyProRoleMap) {
        ProjectRoleApplicationImpl projectRoleApplication = ProjectRoleApplicationImpl.getInstance();
        long proTeamId = mainRole.getLong("projteam.id");
        DynamicObject dbMainDutyRoleDyn = PRJRoleUtils.getDbMainDutyRoleDyn(proTeamId);
        Map<String, List<DynamicObject>> changeMap = PRJRoleUtils.getProjectRoleByChangeMainDutyRole(mainRole, dbMainDutyRoleDyn);
        List<DynamicObject> needChangeProjectRoleList = changeMap.get("allRole");
        ArrayList<DynamicObject> eventDataList = new ArrayList<DynamicObject>(16);
        Long oldMainDutyProRoleId = null;
        HashMap<Long, Long> changeSceneSubMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> changeSceneMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> changeTypeIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> changeOperateIdMap = new HashMap<Long, Long>(16);
        HisResponse<VersionChangeRespData> hisResponse = projectRoleApplication.saveProjectRoles(Collections.singletonList(mainRole));
        List<DynamicObject> hisRetDynList = Arrays.asList(((VersionChangeRespData)hisResponse.getData()).getNewDynamicObjects());
        eventDataList.addAll(hisRetDynList);
        Long newMainDutyProRoleBoId = mainRole.getLong("id");
        changeTypeIdMap.put(newMainDutyProRoleBoId, CHANGE_TYPE_NEW);
        changeSceneMap.put(newMainDutyProRoleBoId, PR_CHANGE_SCENE_ADD);
        changeOperateIdMap.put(newMainDutyProRoleBoId, changeOperate);
        if (dbMainDutyRoleDyn != null) {
            oldMainDutyProRoleId = dbMainDutyRoleDyn.getLong("boid");
            changeSceneSubMap.put(oldMainDutyProRoleId, PR_CHANGE_SUB_SCENE_DUTY_REPLACE);
            changeSceneSubMap.put(newMainDutyProRoleBoId, PR_CHANGE_SUB_SCENE_DUTY_BE_REPLACE);
        }
        if (!CollectionUtils.isEmpty(needChangeProjectRoleList)) {
            WorkRoleNewHisUtils.setNewId(needChangeProjectRoleList);
            HisResponse<VersionChangeRespData> response = projectRoleApplication.changeProjectRolesOnlyADRelation(needChangeProjectRoleList);
            for (DynamicObject dyn : ((VersionChangeRespData)response.getData()).getNewDynamicObjects()) {
                long boId = dyn.getLong("boid");
                changeTypeIdMap.put(boId, CHANGE_TYPE_INFO);
                changeOperateIdMap.put(boId, CHANGE_OPERATE_INFO);
                changeSceneMap.put(boId, PR_CHANGE_SCENE_UPDATE);
                eventDataList.add(dyn);
                hisRetDataList.add(dyn);
            }
        }
        mainDutyProRoleMap.put("newMainDutyProRoleBoId", newMainDutyProRoleBoId);
        mainDutyProRoleMap.put("oldMainDutyProRoleId", oldMainDutyProRoleId);
        mainDutyProRoleMap.put("effDate", mainRole.getDate("bsed"));
        long changeReasonId = mainRole.getLong("changereason.id");
        ProjRoleChangeEvent.getInstance().handleProRoleEvent(eventDataList, changeSceneMap, changeSceneSubMap, changeTypeIdMap, changeOperateIdMap, oldMainDutyProRoleId, newMainDutyProRoleBoId, changeReasonId);
        return hisResponse;
    }

    public static QFilter getOrgTeamTypeFilter(DynamicObject pjDyn, String reportCorelTypeEntity, String reportCorelTypeFilterPro, Long filterVal) {
        QFilter qFilter = new QFilter("org.id", "!=", (Object)-1L);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(reportCorelTypeEntity);
        DynamicObject[] dynArr = helper.queryOriginalArray("id", new QFilter[]{new QFilter(reportCorelTypeFilterPro, "=", (Object)filterVal)});
        if (dynArr != null) {
            List idList = Arrays.stream(dynArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
            qFilter.and(new QFilter("id", "in", idList));
        }
        return qFilter;
    }

    public static boolean checkCanDisable(List<Long> idList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_projectrolesdetail");
        QFilter idFilter = new QFilter("id", "in", idList);
        QFilter[] filters = new QFilter[]{idFilter, new QFilter("enable", "=", (Object)"0")};
        DynamicObject[] disableDynArr = helper.queryOriginalArray("id", filters);
        return disableDynArr != null && disableDynArr.length != idList.size();
    }

    public static boolean checkIsEnable(Long proRoleId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_projectrolesdetail");
        QFilter idFilter = new QFilter("id", "=", (Object)proRoleId);
        idFilter.and(new QFilter("enable", "=", (Object)"1"));
        return helper.isExists(idFilter);
    }

    public static QFilter getProRoleCoopOrgPermFilter(String appIdOrNum, String entityNumber, String filed) {
        AuthorizedOrgTeamResult authorizedOrgResult = (AuthorizedOrgTeamResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedOrgTeamsF7", (Object[])new Object[]{RequestContext.get().getCurrUserId(), PermCommonUtil.getAppIdFromSuspectedAppNum((String)appIdOrNum), entityNumber, "47150e89000000ac", filed});
        if (!authorizedOrgResult.isHasAllOrgPerm()) {
            Map hasPermOrgTeamMap = authorizedOrgResult.getHasPermOrgTeamMap();
            HashSet boIdSet = new HashSet(16);
            hasPermOrgTeamMap.forEach((key, val) -> boIdSet.addAll(val));
            return new QFilter("boid", "in", boIdSet);
        }
        return new QFilter("boid", "!=", (Object)-1);
    }

    public static void assemblyProRoleMsgParams(List<DynamicObject> proRoleDynList, List<Map<String, Object>> msgMapList) {
        proRoleDynList.forEach(dyn -> {
            if (!dyn.getBoolean("iscurrentversion")) {
                Long boId = dyn.getLong("boid");
                HashMap<String, Object> msgMap = new HashMap<String, Object>(8);
                msgMap.put("id", dyn.getLong("id"));
                msgMap.put("boid", dyn.getLong("boid"));
                msgMap.put("number", dyn.getString("number"));
                msgMap.put("name", dyn.getString("name"));
                msgMap.put("dataType", PR_CHANGE_SCENE_UPDATE);
                msgMapList.add(msgMap);
            }
        });
    }

    public static void proRoleUpSendMsg(List<Map<String, Object>> msgMapList, Map<String, Object> mainDutyProRoleMap) {
        if (!ObjectUtils.isEmpty(msgMapList)) {
            Long newMainDutyProRoleBoId = null;
            Long oldMainDutyProRoleBoId = null;
            Date effDate = null;
            if (mainDutyProRoleMap != null) {
                newMainDutyProRoleBoId = (Long)mainDutyProRoleMap.get("newMainDutyProRoleBoId");
                oldMainDutyProRoleBoId = (Long)mainDutyProRoleMap.get("oldMainDutyProRoleBoId");
                effDate = (Date)mainDutyProRoleMap.get("effDate");
            }
            logger.info("proRoleUpSendMsg sendMsg start, oldMainDutyProRoleId={}, newMainDutyProRoleBoId={}", oldMainDutyProRoleBoId, (Object)newMainDutyProRoleBoId);
            try {
                ProRoleMsgService.getInstance().sendProRoleChgMsg(msgMapList, newMainDutyProRoleBoId, oldMainDutyProRoleBoId, effDate);
            }
            catch (Exception exception) {
                logger.error("proRoleUpSendMsg sendProRoleChgMsg is Exception", (Throwable)exception);
            }
            logger.info("proRoleUpSendMsg sendMsg end.");
        }
    }
}

