/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.domain.repository.position.MserviceQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class PositionHisQueryPageUtil {
    public static void batchPositionHisList(String fields, DynamicObjectCollection pageData, Date date) {
        if (Objects.isNull(pageData) || pageData.isEmpty()) {
            return;
        }
        List fieldList = null;
        if (HRStringUtils.isNotEmpty((String)fields)) {
            fieldList = Arrays.stream(fields.split(",")).collect(Collectors.toList());
        }
        if (null == fieldList || fieldList.contains("adminorg")) {
            List<Long> orgIds = pageData.stream().map(dy -> dy.getLong("adminorg.id")).collect(Collectors.toList());
            Map<String, Map<String, Object>> orgMaps = MserviceQueryRepository.getInstance().queryOrg(orgIds, date);
            if (!CollectionUtils.isEmpty(orgMaps)) {
                pageData.forEach(dy -> {
                    DynamicObject org = dy.getDynamicObject("adminorg");
                    if (!HRObjectUtils.isEmpty((Object)org)) {
                        PositionHisQueryPageUtil.fillAdminOrgHis(orgMaps, org);
                    }
                });
            }
        }
        if (null == fieldList || fieldList.contains("parent")) {
            List<Long> parentIds = pageData.stream().map(dy -> dy.getLong("parent.id")).filter(id -> id != 0L).collect(Collectors.toList());
            DynamicObject[] dys = PositionQueryRepository.getInstance().queryPositionHisInfo(parentIds, date);
            if (!PositionUtils.isArrayEmpty(dys).booleanValue()) {
                Map<Long, DynamicObject> positions = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy, (v1, v2) -> v2));
                pageData.forEach(dy -> {
                    DynamicObject pageParent = dy.getDynamicObject("parent");
                    DynamicObject po = (DynamicObject)positions.get("parent.id");
                    if (Objects.nonNull(po)) {
                        pageParent.set("name", (Object)po.getString("name"));
                        pageParent.set("number", (Object)po.getString("number"));
                    }
                });
            }
        }
    }

    private static void fillAdminOrgHis(Map<String, Map<String, Object>> orgMaps, DynamicObject org) {
        String orgId = org.getString("id");
        Map<String, Object> orgMap = orgMaps.get(orgId);
        if (!CollectionUtils.isEmpty(orgMap)) {
            org.set("id", orgMap.get("vid"));
            org.set("name", orgMap.get("name"));
            org.set("number", orgMap.get("number"));
        }
    }

    public static void positionHisFieldFill(String fields, IDataModel model, Date date) {
        DynamicObject[] parent;
        DynamicObject parentDy;
        Map<String, Map<String, Object>> orgMaps;
        DynamicObject org;
        List fieldList = null;
        if (HRStringUtils.isNotEmpty((String)fields)) {
            fieldList = Arrays.stream(fields.split(",")).collect(Collectors.toList());
        }
        if (Objects.isNull(date)) {
            date = new Date();
        }
        DynamicObject position = model.getDataEntity();
        if ((null == fieldList || fieldList.contains("adminorg")) && Objects.nonNull(org = position.getDynamicObject("adminorg")) && !CollectionUtils.isEmpty(orgMaps = MserviceQueryRepository.getInstance().queryOrg(Collections.singletonList(org.getLong("id")), date))) {
            PositionHisQueryPageUtil.fillAdminOrgHis(orgMaps, org);
        }
        if ((null == fieldList || fieldList.contains("parent")) && Objects.nonNull(parentDy = position.getDynamicObject("parent")) && !PositionUtils.isArrayEmpty(parent = PositionQueryRepository.getInstance().queryPositionHisInfo(Collections.singletonList(parentDy.getLong("id")), date)).booleanValue()) {
            parentDy.set("id", (Object)parent[0].getLong("id"));
            parentDy.set("name", (Object)parent[0].getString("name"));
            parentDy.set("number", (Object)parent[0].getString("number"));
        }
    }
}

