/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.domain.repository.position.MserviceQueryRepository;

public class PositionJobRangeServiceHelper {
    private static final Log LOG = LogFactory.getLog(PositionJobRangeServiceHelper.class);
    private Set<Long> jobIds;
    private Set<Long> jobScmIds;
    private Set<Long> jobFamilyIds;
    private Map<Long, Map<String, List<DynamicObject>>> jobScmAndRangeMap = Maps.newHashMap();
    private Map<Long, Map<String, List<DynamicObject>>> jobAndRangeMap = Maps.newHashMap();
    private Map<Long, Map<String, List<DynamicObject>>> jobFamilyAndRangeMap = Maps.newHashMap();
    private MserviceQueryRepository mserviceQueryRepository = MserviceQueryRepository.getInstance();

    public void initData(Set<Long> jobScmIds, Set<Long> jobIds, Set<Long> jobFamilyIds) {
        this.jobScmIds = jobScmIds;
        this.jobIds = jobIds;
        this.jobFamilyIds = jobFamilyIds;
        this.parseJobScmAndJobFamilyRange(this.jobScmIds, this.jobFamilyIds);
        this.parseJobRange(this.jobIds);
    }

    public Map<String, List<DynamicObject>> getLevelAndGradeRange(DynamicObject levelScm, DynamicObject gradeScm, DynamicObject job, DynamicObject jobScm) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        if (!HRObjectUtils.isEmpty((Object)levelScm) || !HRObjectUtils.isEmpty((Object)gradeScm)) {
            LOG.info("the class PositionJobRangeServiceHelper getLevelAndGradeRange from levelAndGradeSCM ");
            return this.getLevelAndGradeRangeByScm(levelScm, gradeScm);
        }
        if (!HRObjectUtils.isEmpty((Object)job)) {
            LOG.info("the class PositionJobRangeServiceHelper getLevelAndGradeRange from jobOrJobFamily ");
            return this.getLevelAndGradeRangeByJob(job.getLong("id"), job.getLong("jobfamily.id"), job.getLong("jobscm.id"));
        }
        if (!HRObjectUtils.isEmpty((Object)jobScm)) {
            LOG.info("the class PositionJobRangeServiceHelper getLevelAndGradeRange from jobScm ");
            return this.getLevelAndGradeRangeByJobScm(jobScm.getLong("id"));
        }
        return result;
    }

    private Map<String, List<DynamicObject>> getLevelAndGradeRangeByJob(Long jobId, Long jobFamily, Long jobScm) {
        ArrayList jobGradeRange = Lists.newArrayList();
        ArrayList jobLevelRange = Lists.newArrayList();
        HashMap levelAndGradeRangeMap = Maps.newHashMapWithExpectedSize((int)4);
        if (!ObjectUtils.isEmpty((Object)jobId)) {
            Map<String, List<DynamicObject>> jobRange = this.jobAndRangeMap.get(jobId);
            if (!CollectionUtils.isEmpty(jobRange)) {
                List<DynamicObject> jobGradeScm = jobRange.get("jobgradescm");
                List<DynamicObject> jobLevelScm = jobRange.get("joblevelscm");
                if (!CollectionUtils.isEmpty(jobGradeScm)) {
                    jobGradeRange.addAll(jobGradeScm);
                }
                if (!CollectionUtils.isEmpty(jobLevelScm)) {
                    jobLevelRange.addAll(jobLevelScm);
                }
            }
            LOG.info("the class PositionJobRangeServiceHelper getLevelAndGradeRange from job ");
        }
        if ((jobGradeRange.isEmpty() || jobLevelRange.isEmpty()) && !ObjectUtils.isEmpty((Object)jobFamily)) {
            Map<String, List<DynamicObject>> jobFamilyRange = this.jobFamilyAndRangeMap.get(jobFamily);
            if (!CollectionUtils.isEmpty(jobFamilyRange)) {
                if (jobGradeRange.isEmpty()) {
                    List<Object> list = jobGradeRange = CollectionUtils.isEmpty((Collection)jobFamilyRange.get("jobgradescm")) ? jobGradeRange : jobFamilyRange.get("jobgradescm");
                }
                if (jobLevelRange.isEmpty()) {
                    jobLevelRange = CollectionUtils.isEmpty((Collection)jobFamilyRange.get("joblevelscm")) ? jobLevelRange : jobFamilyRange.get("joblevelscm");
                }
            }
            LOG.info("the class PositionJobRangeServiceHelper getLevelAndGradeRange from jobFamily ");
        }
        if ((jobGradeRange.isEmpty() || jobLevelRange.isEmpty()) && !ObjectUtils.isEmpty((Object)jobScm)) {
            Map<String, List<DynamicObject>> jobScmRangeMap = this.jobScmAndRangeMap.get(jobScm);
            if (!CollectionUtils.isEmpty(jobScmRangeMap)) {
                if (jobGradeRange.isEmpty()) {
                    List<Object> list = jobGradeRange = CollectionUtils.isEmpty((Collection)jobScmRangeMap.get("jobgradescm")) ? jobGradeRange : jobScmRangeMap.get("jobgradescm");
                }
                if (jobLevelRange.isEmpty()) {
                    jobLevelRange = CollectionUtils.isEmpty((Collection)jobScmRangeMap.get("joblevelscm")) ? jobLevelRange : jobScmRangeMap.get("joblevelscm");
                }
            }
            LOG.info("the class PositionJobRangeServiceHelper getLevelAndGradeRange from jobFamily ");
        }
        levelAndGradeRangeMap.put("jobgradescm", jobGradeRange);
        levelAndGradeRangeMap.put("joblevelscm", jobLevelRange);
        return levelAndGradeRangeMap;
    }

    private Map<String, List<DynamicObject>> getLevelAndGradeRangeByJobScm(Long jobScmId) {
        HashMap levelAndGradeRangeMap = Maps.newHashMapWithExpectedSize((int)4);
        if (ObjectUtils.isEmpty((Object)jobScmId)) {
            return levelAndGradeRangeMap;
        }
        Map<String, List<DynamicObject>> rangeMap = this.jobScmAndRangeMap.get(jobScmId);
        if (CollectionUtils.isEmpty(rangeMap)) {
            return levelAndGradeRangeMap;
        }
        return rangeMap;
    }

    private Map<String, List<DynamicObject>> getLevelAndGradeRangeByScm(DynamicObject levelScm, DynamicObject gradeScm) {
        ArrayList jobGradeRange = Lists.newArrayList();
        ArrayList jobLevelRange = Lists.newArrayList();
        HashMap levelAndGradeRangeMap = Maps.newHashMapWithExpectedSize((int)4);
        if (!HRObjectUtils.isEmpty((Object)levelScm)) {
            this.jobLevelOrGradeEntryToBasedata(levelScm, jobLevelRange, "hbjm_joblevelhr");
        }
        if (!HRObjectUtils.isEmpty((Object)gradeScm)) {
            this.jobLevelOrGradeEntryToBasedata(gradeScm, jobGradeRange, "hbjm_jobgradehr");
        }
        levelAndGradeRangeMap.put("jobgradescm", jobGradeRange);
        levelAndGradeRangeMap.put("joblevelscm", jobLevelRange);
        return levelAndGradeRangeMap;
    }

    private void jobLevelOrGradeEntryToBasedata(DynamicObject levelOrGradeScm, List<DynamicObject> jobLevelOrGradeRange, String pageJobLevelOrGrade) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)pageJobLevelOrGrade);
        for (DynamicObject levelOrGradeEntry : levelOrGradeScm.getDynamicObjectCollection("entryentity")) {
            DynamicObject levelOrGrade = new DynamicObject((DynamicObjectType)dataEntityType);
            HRDynamicObjectUtils.copy((DynamicObject)levelOrGradeEntry, (DynamicObject)levelOrGrade);
            levelOrGrade.set("id", levelOrGradeEntry.get("id"));
            if ("hbjm_joblevelhr".equals(pageJobLevelOrGrade)) {
                levelOrGrade.set("number", levelOrGradeEntry.get("joblevel_number"));
                levelOrGrade.set("name", levelOrGradeEntry.get("joblevel_name"));
                levelOrGrade.set("joblevelseq", levelOrGradeEntry.get("joblevel_seq"));
                levelOrGrade.set("joblevelscm", (Object)levelOrGradeScm);
            } else if ("hbjm_jobgradehr".equals(pageJobLevelOrGrade)) {
                levelOrGrade.set("number", levelOrGradeEntry.get("jobgrade_number"));
                levelOrGrade.set("name", levelOrGradeEntry.get("jobgrade_name"));
                levelOrGrade.set("jobgradeseq", levelOrGradeEntry.get("jobgrade_seq"));
                levelOrGrade.set("jobgradescm", (Object)levelOrGradeScm);
            }
            jobLevelOrGradeRange.add(levelOrGrade);
        }
    }

    private void parseJobScmAndJobFamilyRange(Set<Long> jobScmIds, Set<Long> jobFamilyIds) {
        if (CollectionUtils.isEmpty(jobScmIds)) {
            return;
        }
        ArrayList<Long> jobScmIdList = new ArrayList<Long>(jobScmIds);
        ArrayList<Long> jobFamilyList = new ArrayList<Long>(jobFamilyIds);
        Map<Long, Map<Long, DynamicObject>> jobScmRelationRange = this.mserviceQueryRepository.getJobLevelGrade(jobScmIdList, jobFamilyList);
        if (CollectionUtils.isEmpty(jobScmRelationRange)) {
            return;
        }
        for (Long jobScmId : jobScmIds) {
            Map<Long, DynamicObject> jobScmOrJobFamilyMaps = jobScmRelationRange.get(jobScmId);
            if (CollectionUtils.isEmpty(jobScmOrJobFamilyMaps)) continue;
            this.parseJobFamilyRange(jobFamilyIds, jobScmOrJobFamilyMaps);
            this.parseJobScmRange(jobScmId, jobScmOrJobFamilyMaps);
        }
    }

    private void parseJobRange(Set<Long> jobIds) {
        if (CollectionUtils.isEmpty(jobIds)) {
            return;
        }
        ArrayList<Long> jobList = new ArrayList<Long>(jobIds);
        Map<String, Object> jobLevelGradeRangeInfo = this.mserviceQueryRepository.getJobLevelGradeRangeInfo(jobList);
        for (Long jobId : jobIds) {
            Map<String, List<DynamicObject>> levelGradeRangeByJob = this.getLevelGradeRangeByJobId(jobLevelGradeRangeInfo, String.valueOf(jobId));
            if (levelGradeRangeByJob == null || levelGradeRangeByJob.isEmpty()) continue;
            HashMap levelAndGradeRangeMap = Maps.newHashMapWithExpectedSize((int)4);
            levelAndGradeRangeMap.put("jobgradescm", levelGradeRangeByJob.get("jobgrade"));
            levelAndGradeRangeMap.put("joblevelscm", levelGradeRangeByJob.get("joblevel"));
            this.jobAndRangeMap.put(jobId, levelAndGradeRangeMap);
        }
    }

    private void parseJobFamilyRange(Set<Long> jobFamilyIds, Map<Long, DynamicObject> jobScmOrJobFamilyMaps) {
        if (CollectionUtils.isEmpty(jobFamilyIds)) {
            return;
        }
        for (Long jobFamilyId : jobFamilyIds) {
            Map<String, List<DynamicObject>> levelAndGradeRange = this.getLevelAndGradeRange(jobFamilyId, jobScmOrJobFamilyMaps);
            this.jobFamilyAndRangeMap.put(jobFamilyId, levelAndGradeRange);
        }
    }

    private void parseJobScmRange(Long jobScmId, Map<Long, DynamicObject> jobScmOrJobFamilyMaps) {
        Map<String, List<DynamicObject>> levelAndGradeRange = this.getLevelAndGradeRange(jobScmId, jobScmOrJobFamilyMaps);
        this.jobScmAndRangeMap.put(jobScmId, levelAndGradeRange);
    }

    private Map<String, List<DynamicObject>> getLevelAndGradeRange(Long jobScmIdOrJobFamily, Map<Long, DynamicObject> jobScmOrJobFamilyMaps) {
        DynamicObject jobScm = jobScmOrJobFamilyMaps.get(jobScmIdOrJobFamily);
        HashMap levelAndGradeRangeMap = Maps.newHashMapWithExpectedSize((int)4);
        if (!HRObjectUtils.isEmpty((Object)jobScm)) {
            DynamicObject gradeScm;
            ArrayList jobGradeRange = Lists.newArrayList();
            ArrayList jobLevelRange = Lists.newArrayList();
            DynamicObject levelScm = jobScm.getDynamicObject("joblevelscm");
            if (!HRObjectUtils.isEmpty((Object)levelScm)) {
                this.jobLevelOrGradeEntryToBasedata(levelScm, jobLevelRange, "hbjm_joblevelhr");
            }
            if (!HRObjectUtils.isEmpty((Object)(gradeScm = jobScm.getDynamicObject("jobgradescm")))) {
                this.jobLevelOrGradeEntryToBasedata(gradeScm, jobGradeRange, "hbjm_jobgradehr");
            }
            levelAndGradeRangeMap.put("jobgradescm", jobGradeRange);
            levelAndGradeRangeMap.put("joblevelscm", jobLevelRange);
        }
        return levelAndGradeRangeMap;
    }

    public boolean isFillLevelGradeRange(String lowLevelText, String highLevelText, String lowGradeText, String highGradeText) {
        return HRStringUtils.isNotEmpty((String)lowLevelText) || HRStringUtils.isNotEmpty((String)highLevelText) || HRStringUtils.isNotEmpty((String)lowGradeText) || HRStringUtils.isNotEmpty((String)highGradeText);
    }

    private Map<String, List<DynamicObject>> getLevelGradeRangeByJobId(Map<String, Object> jobLevelGradeRangeInfo, String jobId) {
        if (HRStringUtils.isEmpty((String)jobId) || CollectionUtils.isEmpty(jobLevelGradeRangeInfo)) {
            return null;
        }
        Map data = (Map)jobLevelGradeRangeInfo.get("data");
        if (CollectionUtils.isEmpty((Map)data)) {
            return null;
        }
        return (Map)data.get(jobId);
    }
}

