/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.common.util.HRDyObjectUtils;

public class PositionJobRelationCheckUtil {
    private static final Log LOGGER = LogFactory.getLog(PositionJobRelationCheckUtil.class);

    public static PositionJobRelationCheckUtil getInstance() {
        return CommonQueryInstance.INSTANCE;
    }

    public List<String> checkJobSystemRelated(DynamicObject dy) {
        Long jobScmId;
        LinkedList<String> results = new LinkedList<String>();
        long bu = dy.getLong("orgdesignbu.id");
        DynamicObject jobScm = dy.getDynamicObject("jobscm");
        DynamicObject jobGradeScm = dy.getDynamicObject("jobgradescm");
        DynamicObject jobLevelScm = dy.getDynamicObject("joblevelscm");
        if (bu == 0L && HRDyObjectUtils.isContainedFiledNotEmpty((DynamicObject)dy, (String)"jobscm,jobgradescm,joblevelscm").booleanValue()) {
            results.add(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u804c\u4f4d\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"JobLevelGradeRangeUtil_2", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            return results;
        }
        if (!HRObjectUtils.isEmpty((Object)jobScm)) {
            if (Objects.nonNull(jobLevelScm)) {
                results.add(ResManager.loadKDString((String)"\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u7684\u201c\u7f16\u7801\u201d\u548c\u804c\u7ea7\u65b9\u6848\u7684\u201c\u7f16\u7801\u201d\u4e0d\u80fd\u540c\u65f6\u6709\u503c\u3002", (String)"JobLevelGradeRangeUtil_19", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
            if (Objects.nonNull(jobGradeScm)) {
                results.add(ResManager.loadKDString((String)"\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u7684\u201c\u7f16\u7801\u201d\u548c\u804c\u7b49\u65b9\u6848\u7684\u201c\u7f16\u7801\u201d\u4e0d\u80fd\u540c\u65f6\u6709\u503c\u3002", (String)"JobLevelGradeRangeUtil_20", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        if (HRObjectUtils.isEmpty((Object)jobScm)) {
            if (HRDyObjectUtils.isContainedFiledNotEmpty((DynamicObject)dy, (String)"job").booleanValue()) {
                results.add(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u201d\u3002", (String)"JobLevelGradeRangeUtil_3", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
            if (Objects.isNull(jobGradeScm) && HRDyObjectUtils.isContainedFiledNotEmpty((DynamicObject)dy, (String)"lowjobgrade,highjobgrade").booleanValue()) {
                results.add(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u201d\u6216\u201c\u804c\u7b49\u65b9\u6848\u201d\u3002", (String)"JobLevelGradeRangeUtil_1", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
            if (Objects.isNull(jobLevelScm) && HRDyObjectUtils.isContainedFiledNotEmpty((DynamicObject)dy, (String)"lowjoblevel,highjoblevel").booleanValue()) {
                results.add(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u201d\u6216\u201c\u804c\u7b49\u65b9\u6848\u201d\u3002", (String)"JobLevelGradeRangeUtil_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        if (HRDyObjectUtils.isContainedFiledNotEmpty((DynamicObject)dy, (String)"job").booleanValue() && !HRObjectUtils.isEmpty((Object)jobScm) && (jobScmId = Long.valueOf(dy.getLong("job.jobscm.id"))) != 0L && !jobScmId.equals(jobScm.getLong("id"))) {
            results.add(ResManager.loadKDString((String)"\u804c\u4f4d\u7684\u201c\u7f16\u7801\u201d\u4e0e\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u7684\u201c\u7f16\u7801\u201d\u4e0d\u5339\u914d\u3002", (String)"JobLevelGradeRangeUtil_12", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            return results;
        }
        return results;
    }

    public List<String> checkJobLevelGradeRange(DynamicObject dy, Map<String, List<DynamicObject>> jobLevelGradeRange) {
        LinkedList<String> results = new LinkedList<String>();
        this.checkJobGradeRange(results, jobLevelGradeRange, dy.getDynamicObject("lowjobgrade"), dy.getDynamicObject("highjobgrade"));
        this.checkJobLevelRange(results, jobLevelGradeRange, dy.getDynamicObject("lowjoblevel"), dy.getDynamicObject("highjoblevel"));
        return results;
    }

    public List<String> checkJobGradeRange(List<String> results, Map<String, List<DynamicObject>> jobLevelGradeRange, DynamicObject lowJobGrade, DynamicObject highJobGrade) {
        if (!HRObjectUtils.isEmpty((Object)lowJobGrade) || !HRObjectUtils.isEmpty((Object)highJobGrade)) {
            if (CollectionUtils.isEmpty(jobLevelGradeRange) || CollectionUtils.isEmpty((Collection)jobLevelGradeRange.get("jobgradescm"))) {
                LOGGER.info("the validate from PositionJobRelationCheckUtil checkJobGradeRange");
                results.add(ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7b49\u201d\u201c\u6700\u9ad8\u804c\u7b49\u201d\u65e0\u6548\u3002", (String)"JobLevelGradeRangeUtil_5", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                return results;
            }
            List<DynamicObject> jobGradeCollection = jobLevelGradeRange.get("jobgradescm");
            ArrayList jobGradeList = Lists.newArrayListWithExpectedSize((int)jobGradeCollection.size());
            for (DynamicObject jobGrade : jobGradeCollection) {
                jobGradeList.add(jobGrade.getLong("id"));
            }
            if (!HRObjectUtils.isEmpty((Object)lowJobGrade) && !jobGradeList.contains(lowJobGrade.getLong("id"))) {
                LOGGER.info("the validate from PositionJobRelationCheckUtil checkJobGradeRange");
                results.add(ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7b49\u201d\u65e0\u6548\u3002", (String)"JobLevelGradeRangeUtil_7", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
            if (!HRObjectUtils.isEmpty((Object)highJobGrade) && !jobGradeList.contains(highJobGrade.getLong("id"))) {
                LOGGER.info("the validate from PositionJobRelationCheckUtil checkJobGradeRange");
                results.add(ResManager.loadKDString((String)"\u201c\u6700\u9ad8\u804c\u7ea7\u201d\u65e0\u6548\u3002", (String)"JobLevelGradeRangeUtil_8", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
            if (!HRObjectUtils.isEmpty((Object)lowJobGrade) && !HRObjectUtils.isEmpty((Object)highJobGrade)) {
                LOGGER.info("the validate from PositionJobRelationCheckUtil checkJobGradeRange");
                if (this.getSeq("jobgrade_seq", lowJobGrade) > this.getSeq("jobgrade_seq", highJobGrade)) {
                    results.add(ResManager.loadKDString((String)"\u201c\u6700\u9ad8\u804c\u7b49\u201d\u5fc5\u987b\u5927\u4e8e\u201c\u6700\u4f4e\u804c\u7b49\u201d\u3002", (String)"JobLevelGradeRangeUtil_11", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                }
            }
        }
        return results;
    }

    public List<String> checkJobLevelRange(List<String> results, Map<String, List<DynamicObject>> jobLevelGradeRange, DynamicObject lowJobLevel, DynamicObject highJobLevel) {
        if (!HRObjectUtils.isEmpty((Object)lowJobLevel) || !HRObjectUtils.isEmpty((Object)highJobLevel)) {
            if (CollectionUtils.isEmpty(jobLevelGradeRange) || CollectionUtils.isEmpty((Collection)jobLevelGradeRange.get("joblevelscm"))) {
                LOGGER.info("the validate from PositionJobRelationCheckUtil checkJobLevelRange");
                results.add(ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7ea7\u201d\u201c\u6700\u9ad8\u804c\u7ea7\u201d\u65e0\u6548\u3002", (String)"JobLevelGradeRangeUtil_4", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                return results;
            }
            List<DynamicObject> jobLevelCollection = jobLevelGradeRange.get("joblevelscm");
            ArrayList jobLevelList = Lists.newArrayListWithExpectedSize((int)jobLevelCollection.size());
            for (DynamicObject jobLevel : jobLevelCollection) {
                jobLevelList.add(jobLevel.getLong("id"));
            }
            if (!HRObjectUtils.isEmpty((Object)lowJobLevel) && !jobLevelList.contains(lowJobLevel.getLong("id"))) {
                LOGGER.info("the validate from PositionJobRelationCheckUtil checkJobLevelRange");
                results.add(ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7ea7\u201d\u65e0\u6548\u3002", (String)"JobLevelGradeRangeUtil_6", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
            if (!HRObjectUtils.isEmpty((Object)highJobLevel) && !jobLevelList.contains(highJobLevel.getLong("id"))) {
                LOGGER.info("the validate from PositionJobRelationCheckUtil checkJobLevelRange");
                results.add(ResManager.loadKDString((String)"\u201c\u6700\u9ad8\u804c\u7ea7\u201d\u65e0\u6548\u3002", (String)"JobLevelGradeRangeUtil_8", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
            if (!HRObjectUtils.isEmpty((Object)lowJobLevel) && !HRObjectUtils.isEmpty((Object)highJobLevel) && this.getSeq("joblevel_seq", lowJobLevel) > this.getSeq("joblevel_seq", highJobLevel)) {
                LOGGER.info("the validate from PositionJobRelationCheckUtil checkJobLevelRange");
                results.add(ResManager.loadKDString((String)"\u201c\u6700\u9ad8\u804c\u7ea7\u201d\u5fc5\u987b\u5927\u4e8e\u201c\u6700\u4f4e\u804c\u7ea7\u201d\u3002", (String)"JobLevelGradeRangeUtil_10", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
        }
        return results;
    }

    public Map<String, List<DynamicObject>> getJobLevelGradeRange(DynamicObject dy, DynamicObject jobScm, Map<String, List<DynamicObject>> levelGradeRangeByJobId) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)8);
        if (this.isHandleJobLevelGradeRange(dy, "lowjobgrade", "highjobgrade")) {
            List<DynamicObject> jobGradeScm = this.getLevelOrGradeScm(dy, "jobgradescm", jobScm, levelGradeRangeByJobId, "jobgrade");
            result.put("jobgradescm", jobGradeScm);
        }
        if (this.isHandleJobLevelGradeRange(dy, "lowjoblevel", "highjoblevel")) {
            List<DynamicObject> jobLevelScm = this.getLevelOrGradeScm(dy, "joblevelscm", jobScm, levelGradeRangeByJobId, "joblevel");
            result.put("joblevelscm", jobLevelScm);
        }
        return result;
    }

    public List<DynamicObject> getLevelOrGradeScm(DynamicObject dy, String levelGradeScm, DynamicObject jobScm, Map<String, List<DynamicObject>> levelGradeRangeByJobId, String levelGradeSign) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)8);
        if (!HRObjectUtils.isEmpty((Object)dy.getDynamicObject(levelGradeScm))) {
            LOGGER.info("PositionJobRelationCheckUtil getLevelOrGradeScm from levelGradeScm");
            DynamicObject levelScm = dy.getDynamicObject(levelGradeScm);
            DynamicObjectCollection dynamicObjectCollection = levelScm.getDynamicObjectCollection("entryentity");
            if (Objects.isNull(dynamicObjectCollection)) {
                return result;
            }
            result.addAll(dynamicObjectCollection);
            return result;
        }
        if (!HRObjectUtils.isEmpty((Object)dy.getDynamicObject("job"))) {
            LOGGER.info("PositionJobRelationCheckUtil getLevelOrGradeScm from job");
            if (!CollectionUtils.isEmpty(levelGradeRangeByJobId)) {
                List<Object> list = result = levelGradeRangeByJobId.get(levelGradeSign) == null ? result : levelGradeRangeByJobId.get(levelGradeSign);
            }
            if (!CollectionUtils.isEmpty((Collection)result)) {
                return result;
            }
        }
        if (!HRObjectUtils.isEmpty((Object)dy.getDynamicObject("jobscm"))) {
            LOGGER.info("PositionJobRelationCheckUtil getLevelOrGradeScm from jobScm");
            DynamicObject dynamicObject = jobScm.getDynamicObject(levelGradeScm);
            if (!Objects.isNull(dynamicObject)) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                if (Objects.isNull(dynamicObjectCollection)) {
                    return result;
                }
                result.addAll(dynamicObjectCollection);
            }
            return result;
        }
        return result;
    }

    private boolean isHandleJobLevelGradeRange(DynamicObject dy, String lowSign, String highSign) {
        DynamicObject low = dy.getDynamicObject(lowSign);
        DynamicObject high = dy.getDynamicObject(highSign);
        return !HRObjectUtils.isEmpty((Object)low) || !HRObjectUtils.isEmpty((Object)high);
    }

    public DynamicObject getJobScmByCollects(DynamicObject entity, Map<Long, Map<Long, DynamicObject>> collects) {
        Long scmId = entity.getLong("jobscm.id");
        Long familyId = entity.getLong("job.jobfamily.id");
        if (scmId == 0L) {
            return null;
        }
        Map<Long, DynamicObject> familyOrScmMaps = collects.get(scmId);
        if (Objects.isNull(familyOrScmMaps)) {
            return null;
        }
        DynamicObject jobFamilyScm = familyOrScmMaps.get(familyId);
        if (Objects.isNull(jobFamilyScm)) {
            return familyOrScmMaps.get(scmId);
        }
        if (Objects.isNull(jobFamilyScm.getDynamicObject("jobgradescm")) && !Objects.isNull(familyOrScmMaps.get(scmId))) {
            jobFamilyScm.set("jobgradescm", (Object)familyOrScmMaps.get(scmId).getDynamicObject("jobgradescm"));
        }
        if (Objects.isNull(jobFamilyScm.getDynamicObject("joblevelscm")) && !Objects.isNull(familyOrScmMaps.get(scmId))) {
            jobFamilyScm.set("joblevelscm", (Object)familyOrScmMaps.get(scmId).getDynamicObject("joblevelscm"));
        }
        return jobFamilyScm;
    }

    public Map<String, List<DynamicObject>> getLevelGradeRangeByJobId(Map<String, Object> jobLevelGradeRangeInfo, String jobId) {
        if (HRStringUtils.isEmpty((String)jobId)) {
            return null;
        }
        Map data = (Map)jobLevelGradeRangeInfo.get("data");
        if (CollectionUtils.isEmpty((Map)data)) {
            return null;
        }
        return (Map)data.get(jobId);
    }

    private int getSeq(String seqSign, DynamicObject low) {
        try {
            return low.getInt(seqSign);
        }
        catch (Exception e) {
            return low.getInt(seqSign.replace("_", ""));
        }
    }

    private static class CommonQueryInstance {
        private static PositionJobRelationCheckUtil INSTANCE = new PositionJobRelationCheckUtil();

        private CommonQueryInstance() {
        }
    }
}

