/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.utils;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class PositionUtils {
    private static final Log logger = LogFactory.getLog(PositionUtils.class);

    public static Date getCurrentDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return HRDateTimeUtils.parseDate((String)dateFormat.format(new Date()));
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static Long createId(String pageValue) {
        return ORM.create().genLongId(pageValue);
    }

    public static Date formatDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return HRDateTimeUtils.parseDate((String)dateFormat.format(date));
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
            return date;
        }
    }

    public static Date formatDate(String date) {
        if (HRStringUtils.isEmpty((String)date)) {
            return null;
        }
        try {
            return HRDateTimeUtils.parseDate((String)date, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
            return PositionUtils.getCurrentDate();
        }
    }

    public static Boolean checkLongValue(Object value) {
        Long valueId;
        if (Objects.isNull(value)) {
            return Boolean.FALSE;
        }
        try {
            valueId = (Long)value;
        }
        catch (ClassCastException ex) {
            return Boolean.FALSE;
        }
        if (valueId.equals(0L)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean checkDateValue(Object value) {
        if (Objects.isNull(value)) {
            return Boolean.FALSE;
        }
        try {
            Date date = (Date)value;
        }
        catch (ClassCastException ex) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static <T> Boolean isArrayEmpty(T[] values) {
        if (Objects.isNull(values) || values.length == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void reNameF7Capture(String pageNum, String keys, BeforeF7SelectEvent evt) {
        if (HRStringUtils.isEmpty((String)pageNum) || HRStringUtils.isEmpty((String)keys)) {
            return;
        }
        String fieldKey = evt.getProperty().getName();
        if (HRStringUtils.isEmpty((String)fieldKey) || !keys.contains("," + fieldKey + ",")) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(',').append(fieldKey).append(',');
        if (!keys.contains(sb.toString())) {
            return;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)pageNum);
        if (Objects.isNull(dataEntityType)) {
            return;
        }
        Map allFields = dataEntityType.getAllFields();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFields.get(fieldKey);
        if (iDataEntityProperty != null) {
            showParameter.setCaption(iDataEntityProperty.getDisplayName().getLocaleValue());
        }
    }

    public static Map<Long, DynamicObject> listToMap(List<DynamicObject> dynamicObjects, String id) {
        return dynamicObjects.stream().collect(Collectors.toMap(dy -> dy.getLong(id), dy -> dy));
    }

    public static Map<Long, Date> buildBoIdAndBSedMap(List<DynamicObject> dataEntities) {
        Map<Long, Date> boIdAndBSedMap = null;
        if (!CollectionUtils.isEmpty(dataEntities)) {
            boIdAndBSedMap = dataEntities.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getDate("bsed"), (v1, v2) -> v1));
        }
        return boIdAndBSedMap;
    }

    public static Map<String, Object> buildSuccessResult(int code, String ErrMsg, Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", code);
        result.put("ErrMsg", ErrMsg);
        result.put("data", data);
        return result;
    }

    public static Map<String, Object> dynamicObjectToMap(DynamicObject dynamicObject) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        if (dynamicObject != null) {
            DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                map.put(property.getName(), dynamicObject.get(property));
            }
        }
        return map;
    }

    public static QFilter getHisFilter(Date date) {
        if (Objects.nonNull(date)) {
            QFilter filter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
            filter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
            filter.and(new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)date)));
            filter.and(new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)date)));
            return filter;
        }
        return null;
    }
}

