/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.utils;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hbpm.business.domain.repository.position.ProjectRoleQueryRepository;
import kd.hrmp.hbpm.common.model.ProjectRoleCodeRuleModel;

public class ProjectRoleCodeRuleHelper {
    public static boolean isExist(ProjectRoleCodeRuleModel model) {
        return CodeRuleServiceHelper.isExist((String)model.getEntityNumber(), (DynamicObject)ProjectRoleCodeRuleHelper.getEmptyDataInfo(model), (String)model.getOrgId());
    }

    public static boolean isModify(ProjectRoleCodeRuleModel model) {
        return CodeRuleServiceHelper.isModifiable((String)model.getEntityNumber(), (DynamicObject)ProjectRoleCodeRuleHelper.getEmptyDataInfo(model), (String)model.getOrgId());
    }

    public static String[] getBatchNumber(ProjectRoleCodeRuleModel model, int count) {
        String[] batchNumber;
        try {
            batchNumber = CodeRuleServiceHelper.getBatchNumber((String)model.getEntityNumber(), (DynamicObject)ProjectRoleCodeRuleHelper.getEmptyDataInfo(model), (String)model.getOrgId(), (int)count);
        }
        catch (KDException e) {
            throw new KDBizException(e.getMessage());
        }
        return batchNumber;
    }

    public static void recycleNumber(ProjectRoleCodeRuleModel model, boolean collectAll) {
        String[] numbers = ProjectRoleCodeRuleHelper.getNeed2RecycleNumbers(model, collectAll);
        if ((numbers = ProjectRoleCodeRuleHelper.removeExist(numbers)) != null && numbers.length > 0) {
            DynamicObject[] dynamicObjects = (DynamicObject[])IntStream.range(0, numbers.length).mapToObj(i -> ProjectRoleCodeRuleHelper.getEmptyDataInfo(model)).toArray(DynamicObject[]::new);
            CodeRuleServiceHelper.recycleBatchNumber((String)"hbpm_projectrolesdetail", (DynamicObject[])dynamicObjects, (String)model.getOrgId(), (String[])numbers);
        }
    }

    private static String[] removeExist(String[] numbers) {
        if (numbers != null && numbers.length != 0) {
            Set<String> numberSet = Arrays.stream(numbers).collect(Collectors.toSet());
            DynamicObject[] projectRoles = ProjectRoleQueryRepository.getInstance().queryOriginalByNumber("number", numberSet);
            Arrays.stream(projectRoles).forEach(dy -> numberSet.remove(dy.getString("number")));
            return numberSet.toArray(new String[0]);
        }
        return numbers;
    }

    private static String[] getNeed2RecycleNumbers(ProjectRoleCodeRuleModel model, boolean recycleAll) {
        String[] numbers = model.getNumbers();
        if (numbers != null && numbers.length > 0) {
            if (recycleAll) {
                return numbers;
            }
            return ProjectRoleCodeRuleHelper.getUnusedNumbers(model.getCurrentNumbers(), numbers);
        }
        return new String[0];
    }

    private static String[] getUnusedNumbers(String[] currentNumbers, String[] numbers) {
        if (currentNumbers != null && currentNumbers.length > 0) {
            Set<String> numberSet = Arrays.stream(numbers).collect(Collectors.toSet());
            numberSet.removeAll(Arrays.asList(currentNumbers));
            return numberSet.toArray(new String[0]);
        }
        return numbers;
    }

    public static DynamicObject getEmptyDataInfo(ProjectRoleCodeRuleModel model) {
        return new HRBaseServiceHelper(model.getEntityNumber()).generateEmptyDynamicObject();
    }
}

