/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hrmp.hbpm.business.domain.repository.position.WorkRoleQueryRepository;
import kd.hrmp.hbpm.business.utils.WorkRoleNewHisUtils;

public class WorkRoleConverter {
    List<Long> dutyRoleIds;
    Map<Long, DynamicObject> result;

    public WorkRoleConverter(List<Long> dutyRoleIds) {
        this.dutyRoleIds = dutyRoleIds;
        this.initResult();
    }

    final void initResult() {
        List<Long> noZeroDistinctIdList = this.dutyRoleIds.stream().filter(id -> id != 0L).distinct().collect(Collectors.toList());
        DynamicObject[] dynamicObjects = WorkRoleQueryRepository.getInstance().queryByDutyRoleIds(noZeroDistinctIdList);
        this.result = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> WorkRoleNewHisUtils.smartGetId(dy, "position"), dy -> dy, (workRole1, workRole2) -> {
            throw new RuntimeException(String.format("same duty work role map to different work role\uff08id1\uff1a%s\uff0cid2\uff1a%s\uff09", workRole1.getLong("id"), workRole2.getLong("id")));
        }));
    }

    public long getWorkRoleId(long dutyRoleId) {
        DynamicObject workRole = this.result.get(dutyRoleId);
        if (workRole == null) {
            return 0L;
        }
        return WorkRoleNewHisUtils.smartGetId(workRole, "boid");
    }
}

