/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.utils;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.enable.HisEnableParamBo;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hbpm.business.service.DutyAndOrgSynServiceHelper;

public class WorkRoleNewHisUtils {
    public static final List<String> SYSTEM_DEFAULT_VALUE_LIST = Arrays.asList("createtime", "creator", "modifier", "modifytime", "disabledate");
    public static final String EVENT_ID = "eventid";
    public static final String DATE_FORMAT_yyyy_MM_dd = "yyyy-MM-dd";
    public static final String OP_CUSTOM_EFFECT_DATE = "ODC_customEffectDate";
    private static final Log LOGGER = LogFactory.getLog(WorkRoleNewHisUtils.class);

    public static void newHisBatchSave(List<DynamicObject> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        Map<Long, List<DynamicObject>> eventVsDyList = saveList.stream().collect(Collectors.groupingBy(dy -> dy.getLong(EVENT_ID)));
        WorkRoleNewHisUtils.saveHisByEvent(eventVsDyList);
    }

    public static void changeEnableAndDisableStatus(String entityNumber, List<Long> boIdList, boolean isDisabled, Date effectDate) {
        HisBaseBo hisBaseBo = new HisBaseBo();
        hisBaseBo.setEntityNumber(entityNumber);
        hisBaseBo.setBoIdList(boIdList);
        HisEnableParamBo hisEnableParamBo = new HisEnableParamBo();
        hisEnableParamBo.setHisBaseBo(hisBaseBo);
        hisEnableParamBo.setEffectDate(effectDate);
        hisEnableParamBo.setDisabled(isDisabled);
        HisModelController.getInstance().disableOrEnableBo(hisEnableParamBo);
    }

    public static void deleteBo(String entityNumber, List<Long> boIdList) {
        HisBaseBo hisBaseBo = new HisBaseBo();
        hisBaseBo.setEntityNumber(entityNumber);
        hisBaseBo.setBoIdList(boIdList);
        HisModelController.getInstance().deleteBo(hisBaseBo);
    }

    private static void saveHisByEvent(Map<Long, List<DynamicObject>> eventVsDyList) {
        eventVsDyList.forEach((eventId, dyList) -> {
            if (eventId == null || eventId == 0L) {
                WorkRoleNewHisUtils.saveHis(dyList);
            } else {
                HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
                hisVersionParamBo.setHisDyns(dyList.toArray(new DynamicObject[0]));
                hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
                hisVersionParamBo.setEntityNumber(((DynamicObject)dyList.get(0)).getDataEntityType().getName());
                hisVersionParamBo.setAtomicTrans(false);
                HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
                hisVersionParamListBo.setEventId(eventId);
                hisVersionParamListBo.setAtomicTrans(false);
                hisVersionParamListBo.setListHisVersionParamBo(new ArrayList<HisVersionParamBo>(Collections.singletonList(hisVersionParamBo)));
                HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
            }
        });
    }

    public static void saveHis(List<DynamicObject> dyList) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setHisDyns(dyList.toArray(new DynamicObject[0]));
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setEntityNumber(dyList.get(0).getDataEntityType().getName());
        hisVersionParamBo.setAtomicTrans(false);
        HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
    }

    public static void setNewId(List<DynamicObject> dynamicObjectList) {
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return;
        }
        long[] ids = ORM.create().genLongIds(dynamicObjectList.get(0).getDynamicObjectType().getName(), dynamicObjectList.size());
        int i = 0;
        for (DynamicObject dynamicObject : dynamicObjectList) {
            dynamicObject.set("id", (Object)ids[i++]);
        }
    }

    public static void fillId(List<DynamicObject> dynamicObjectList) {
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return;
        }
        long[] ids = ORM.create().genLongIds(dynamicObjectList.get(0).getDynamicObjectType().getName(), dynamicObjectList.size());
        int i = 0;
        for (DynamicObject dynamicObject : dynamicObjectList) {
            if (dynamicObject.getLong("id") != 0L) continue;
            dynamicObject.set("id", (Object)ids[i++]);
        }
    }

    public static List<DynamicObject> newDysFromDys(List<DynamicObject> dynamicObjectList) {
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> resultDyList = new ArrayList<DynamicObject>(dynamicObjectList.size());
        for (DynamicObject dynamicObject : dynamicObjectList) {
            DynamicObject newDy = HistoryEntityUtils.copyHisDynamicObjectWithIgnoreKeySet((DynamicObject)dynamicObject, (Set)Collections.EMPTY_SET);
            resultDyList.add(newDy);
        }
        return resultDyList;
    }

    public static void setPrefixNumber(List<DynamicObject> dynamicObjectList) {
        DutyAndOrgSynServiceHelper dutyAndOrgSynServiceHelper = new DutyAndOrgSynServiceHelper();
        dynamicObjectList.stream().filter(dy -> StringUtils.isNotBlank((CharSequence)dy.getString("number"))).forEach(dutyRole -> {
            String number = dutyRole.getString("number");
            String dutyNumber = dutyAndOrgSynServiceHelper.getNumberByNumberPrefix(number, "DUTYWORKROLES", dutyRole.getLong("teamtype.id"), dutyRole.getLong("orgtype.id"));
            dutyRole.set("number", (Object)dutyNumber);
        });
    }

    public static OperationResult callOp(String opKey, DynamicObject[] dynamicObjects) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        return opImpl.localInvokeOperation(opKey, dynamicObjects, operateOption);
    }

    public static OperationResult callOp(String opKey, DynamicObject[] dynamicObjects, OperateOption operateOption) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        return opImpl.localInvokeOperation(opKey, dynamicObjects, operateOption);
    }

    public static List<DynamicObject> getDy4New(List<DynamicObject> dynamicObjectList) {
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return new ArrayList<DynamicObject>();
        }
        WorkRoleNewHisUtils.fillId(dynamicObjectList);
        return dynamicObjectList;
    }

    public static List<DynamicObject> getDy4ChgProp(List<DynamicObject> dynamicObjectList) {
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return new ArrayList<DynamicObject>();
        }
        List<DynamicObject> newDynamicObjects = WorkRoleNewHisUtils.newDysFromDys(dynamicObjectList);
        WorkRoleNewHisUtils.setNewId(newDynamicObjects);
        return newDynamicObjects;
    }

    public static void loadReference(List<DynamicObject> dynamicObjectList, List<String> keyList) {
        if (CollectionUtils.isEmpty(dynamicObjectList) || CollectionUtils.isEmpty(keyList)) {
            return;
        }
        DynamicObjectType dynamicObjectType = dynamicObjectList.get(0).getDynamicObjectType();
        for (String key : keyList) {
            DynamicProperty property = dynamicObjectType.getProperty(key);
            if (property instanceof BasedataProp) {
                Set<Long> idSet = WorkRoleNewHisUtils.getBaseDataIdSet(dynamicObjectList, key);
                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                QFilter idFilter = new QFilter("id", "in", idSet);
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(baseEntityId);
                DynamicObject[] dynamicObjects = hrBaseServiceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
                Map idVsDy = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
                dynamicObjectList.stream().filter(dynamicObject -> !(dynamicObject.get(key) instanceof DynamicObject)).forEach(dynamicObject -> Optional.ofNullable(idVsDy.get(WorkRoleNewHisUtils.smartGetId(dynamicObject, key))).ifPresent(baseDataDy -> dynamicObject.set(key, baseDataDy)));
                continue;
            }
            throw new KDBizException(key + " is not a basedata in " + dynamicObjectType.getName());
        }
    }

    public static Set<Long> getBaseDataIdSet(List<DynamicObject> dynamicObjectList, String key) {
        if (CollectionUtils.isEmpty(dynamicObjectList) || StringUtils.isBlank((CharSequence)key)) {
            return new HashSet<Long>();
        }
        return dynamicObjectList.stream().map(dynamicObject -> WorkRoleNewHisUtils.smartGetId(dynamicObject, key)).filter(id -> id != 0L).collect(Collectors.toSet());
    }

    public static long smartGetId(DynamicObject dynamicObject, String key) {
        Object obj = dynamicObject.get(key);
        return WorkRoleNewHisUtils.smartGetId(obj);
    }

    public static long smartGetId(Object obj) {
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id");
        }
        if (obj instanceof String) {
            return Long.parseLong((String)obj);
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return 0L;
    }

    public static List<DynamicObject> createSysReportRelFromWorkRole(List<DynamicObject> workRoleList) {
        if (CollectionUtils.isEmpty(workRoleList)) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> reportRelList = new ArrayList<DynamicObject>(workRoleList.size());
        ArrayList<DynamicObject> workRoles = new ArrayList<DynamicObject>(workRoleList.size());
        for (DynamicObject workRole : workRoleList) {
            if (workRole.get("parentrole") == null) continue;
            DynamicObject reportRelation = BusinessDataServiceHelper.newDynamicObject((String)"hbpm_reportingrelation");
            reportRelation.set("sourcetype", (Object)1010L);
            reportRelation.set("reportingtype", (Object)1010L);
            reportRelation.set("role", (Object)workRole);
            DynamicObject workRoleParent = workRole.getDynamicObject("parentrole");
            reportRelation.set("parent", (Object)workRoleParent);
            reportRelation.set("enable", (Object)workRole.getString("enable"));
            reportRelation.set("initstatus", (Object)workRole.getString("initstatus"));
            reportRelation.set("initdatasource", (Object)workRole.getString("initdatasource"));
            reportRelation.set("initbatch", (Object)workRole.getLong("initbatch"));
            reportRelList.add(reportRelation);
            workRoles.add(workRole);
        }
        WorkRoleNewHisUtils.copyValueByField(reportRelList, workRoles, SYSTEM_DEFAULT_VALUE_LIST);
        WorkRoleNewHisUtils.copyValueByField(reportRelList, workRoles, Arrays.asList(EVENT_ID, "bsed", "bsled"));
        return reportRelList;
    }

    public static DynamicObject createSysReportRelFromWorkRoleForRevise(DynamicObject reportRelation, DynamicObject workRole) {
        if (reportRelation == null) {
            reportRelation = BusinessDataServiceHelper.newDynamicObject((String)"hbpm_reportingrelation");
            reportRelation.set("sourcetype", (Object)1010L);
            reportRelation.set("reportingtype", (Object)1010L);
            reportRelation.set("role", (Object)workRole.getLong("id"));
            reportRelation.set("initstatus", (Object)workRole.getString("initstatus"));
            reportRelation.set("initdatasource", (Object)workRole.getString("initdatasource"));
            reportRelation.set("initbatch", (Object)workRole.getLong("initbatch"));
        }
        DynamicObject workRoleParent = workRole.getDynamicObject("parentrole");
        reportRelation.set("parent", (Object)workRoleParent);
        reportRelation.set("enable", (Object)workRole.getString("enable"));
        if (workRoleParent == null) {
            reportRelation.set("enable", (Object)"0");
        }
        List<DynamicObject> reportRelList = Collections.singletonList(reportRelation);
        List<DynamicObject> workRoles = Collections.singletonList(workRole);
        WorkRoleNewHisUtils.copyValueByField(reportRelList, workRoles, SYSTEM_DEFAULT_VALUE_LIST);
        WorkRoleNewHisUtils.copyValueByField(reportRelList, workRoles, Arrays.asList(EVENT_ID, "bsed", "bsled"));
        return reportRelation;
    }

    private static void copyValueByField(List<DynamicObject> toList, List<DynamicObject> fromList, List<String> whiteList) {
        if (CollectionUtils.isEmpty(whiteList) || CollectionUtils.isEmpty(toList) || CollectionUtils.isEmpty(fromList)) {
            return;
        }
        if (toList.size() != fromList.size()) {
            throw new RuntimeException("toList size != fromList size.");
        }
        DynamicObjectType toDyType = toList.get(0).getDynamicObjectType();
        DynamicObjectType fromDyType = fromList.get(0).getDynamicObjectType();
        for (String key : whiteList) {
            DynamicProperty toProperty = toDyType.getProperty(key);
            DynamicProperty fromProperty = fromDyType.getProperty(key);
            for (int i = 0; i < toList.size(); ++i) {
                toProperty.setValue((Object)toList.get(i), fromProperty.getValue((Object)fromList.get(i)));
            }
        }
    }

    public static void deleteHisData4Api(List<Long> idList, String entityName, ApiResult result) {
        try (TXHandle required = TX.required();){
            try {
                WorkRoleNewHisUtils.deleteBo(entityName, idList);
            }
            catch (Exception ex) {
                required.markRollback();
                result.setSuccess(false);
                result.setMessage(ex.getMessage());
            }
        }
    }

    public static List<Long> queryReportRelationByWorkRole(List<Long> workRoleIdLists) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter roleFilter = new QFilter("role", "in", workRoleIdLists);
        QFilter parentFilter = new QFilter("parent", "in", workRoleIdLists);
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.queryOriginalArray("id", new QFilter[]{roleFilter.or(parentFilter)});
        return Arrays.stream(dynamicObjects).map(dy -> WorkRoleNewHisUtils.smartGetId(dy, "id")).collect(Collectors.toList());
    }

    public static Date parseDate(String dateStr) {
        if (dateStr == null) {
            return null;
        }
        try {
            return HRDateTimeUtils.parseDate((String)dateStr);
        }
        catch (ParseException e) {
            LOGGER.error((Throwable)e);
            throw new KDBizException(String.format("parse date fail with exception: %s", e.getMessage()));
        }
    }

    public static String format(Date date) {
        if (date == null) {
            return null;
        }
        return HRDateTimeUtils.format((Date)date, (String)DATE_FORMAT_yyyy_MM_dd);
    }

    public static OperateOption createEffectDateOption(Date date) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue(OP_CUSTOM_EFFECT_DATE, WorkRoleNewHisUtils.format(date));
        return operateOption;
    }

    public static Date getEffectDateFromOption(OperateOption option) {
        String effectDate = option.getVariableValue(OP_CUSTOM_EFFECT_DATE, null);
        return WorkRoleNewHisUtils.parseDate(effectDate);
    }
}

