/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.utils.model;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.entity.ExtendedDataEntity;

public class PositionNodeEntity {
    private final ExtendedDataEntity extendedDataEntity;
    private final Long id;
    private final Long parentId;
    private boolean errorFlag;
    private List<PositionNodeEntity> subNodeList;

    public PositionNodeEntity(Long id, Long parentId, ExtendedDataEntity extendedDataEntity) {
        this.id = id;
        this.parentId = parentId;
        this.extendedDataEntity = extendedDataEntity;
        this.subNodeList = new ArrayList<PositionNodeEntity>();
    }

    public void setErrorByParent(Set<Long> set) {
        ArrayDeque<PositionNodeEntity> queue = new ArrayDeque<PositionNodeEntity>();
        if (set.contains(this.getId())) {
            return;
        }
        queue.offer(this);
        set.add(this.getId());
        while (!queue.isEmpty()) {
            PositionNodeEntity parentNode = (PositionNodeEntity)queue.poll();
            List<PositionNodeEntity> subNodeList = parentNode.getSubNodeList();
            subNodeList.forEach(sub -> {
                if (!set.contains(sub.getId())) {
                    sub.errorFlag = true;
                    queue.offer((PositionNodeEntity)sub);
                    set.add(sub.getId());
                }
            });
        }
    }

    public boolean isErrorFlag() {
        return this.errorFlag;
    }

    public Long getId() {
        return this.id;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public List<PositionNodeEntity> getSubNodeList() {
        return this.subNodeList;
    }

    public ExtendedDataEntity getExtendedDataEntity() {
        return this.extendedDataEntity;
    }
}

