/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.utils.translate;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hbpm.business.utils.translate.TranslateResult;
import kd.hrmp.hbpm.business.utils.translate.ValueHandlerContext;
import kd.hrmp.hbpm.business.utils.translate.ValueTranslatorManager;

public class DynamicObjectTranslator<T> {
    private static final Log LOG = LogFactory.getLog(DynamicObjectTranslator.class);
    private final List<T> models;
    private final String entityNumber;
    private final Class<?> clazz;
    private HRBaseServiceHelper baseServiceHelper;
    private DynamicObjectType dynamicObjectType;
    private DataEntityPropertyCollection properties;
    private long[] ids;
    private List<Map<String, Object>> needTranslateMap;

    public DynamicObjectTranslator(List<T> models, String entityNumber, Class<T> clazz, List<Map<String, Object>> needTranslateMap) {
        this.models = models;
        this.entityNumber = entityNumber;
        this.clazz = clazz;
        this.needTranslateMap = needTranslateMap;
        this.baseServiceHelper = new HRBaseServiceHelper(entityNumber);
        this.dynamicObjectType = this.baseServiceHelper.generateEmptyDynamicObject().getDynamicObjectType();
        this.properties = this.dynamicObjectType.getProperties();
    }

    private <T> List<TranslateResult<T>> doTranslate(T t) {
        return this.mapTransToDynamicObject(this.needTranslateMap);
    }

    public <T> List<TranslateResult<T>> mapTransToDynamicObject(List<Map<String, Object>> objects) {
        HashSet<String> inputProperties = new HashSet<String>(this.properties.size());
        ArrayListMultimap propertyValueMap = ArrayListMultimap.create();
        DynamicObjectTranslator.traversalProperties(inputProperties, (Multimap<String, Object>)propertyValueMap, objects);
        Set originalProperties = this.properties.stream().map(IMetadata::getName).collect(Collectors.toSet());
        for (String inputProperty : inputProperties) {
            if (originalProperties.contains(inputProperty)) continue;
            throw new IllegalArgumentException("this entity has not this " + inputProperty + " property, please check your params");
        }
        ArrayList<DynamicObject> resultDynamicObjects = new ArrayList<DynamicObject>(objects.size());
        ValueHandlerContext typeHandlerContext = new ValueHandlerContext(this.dynamicObjectType, (Multimap<String, Object>)propertyValueMap, this.properties);
        Map<String, Class<?>> propertyTypeMap = typeHandlerContext.getPropertyTypeMap();
        this.ids = ORM.create().genLongIds(this.entityNumber, objects.size());
        for (int idx = 0; idx < objects.size(); ++idx) {
            DynamicObject obj = this.baseServiceHelper.generateEmptyDynamicObject();
            this.fillUpValue(objects, typeHandlerContext, propertyTypeMap, this.ids, idx, obj);
            resultDynamicObjects.add(obj);
        }
        ArrayList<TranslateResult<T>> resultList = new ArrayList<TranslateResult<T>>(this.models.size());
        Map<Integer, List<String>> errorsMsg = typeHandlerContext.getErrorsMsg();
        for (int idx = 0; idx < this.models.size(); ++idx) {
            resultList.add(new TranslateResult<T>((DynamicObject)resultDynamicObjects.get(idx), errorsMsg.get(idx) == null || errorsMsg.get(idx).size() == 0, errorsMsg.get(idx), this.models.get(idx)));
        }
        return resultList;
    }

    public List<TranslateResult<T>> translate() {
        if (this.models == null || this.models.size() <= 0) {
            throw new IllegalArgumentException("this models must rather than 0, please check your models parameters");
        }
        return this.doTranslate(this.models.get(0));
    }

    private void fillUpValue(List<Map<String, Object>> objects, ValueHandlerContext typeHandlerContext, Map<String, Class<?>> propertyTypeMap, long[] ids, int idx, DynamicObject obj) {
        for (Map.Entry<String, Object> entry : objects.get(idx).entrySet()) {
            ILocaleString localeString;
            String key = entry.getKey();
            Object value = entry.getValue();
            if ("id".equals(key)) {
                if (value instanceof Long && !value.equals(0L)) {
                    Long idValue = (Long)value;
                    ids[idx] = idValue;
                }
                obj.set(key, (Object)ids[idx]);
                continue;
            }
            obj.set(key, value == null ? null : ValueTranslatorManager.whatValueTranslator(propertyTypeMap.get(key)).translate(typeHandlerContext, idx, key, value, value.getClass()));
            if (value == null || propertyTypeMap.get(key) == null || propertyTypeMap.get(key) != ILocaleString.class || (localeString = obj.getLocaleString(key)) == null || localeString.size() != 0) continue;
            obj.set(key, (Object)"1");
            obj.set(key, (Object)"");
            obj.getLocaleString(key).setItem("zh_CN", (Object)"Blank");
            obj.getLocaleString(key).setItem("zh_TW", (Object)"Blank");
            obj.getLocaleString(key).setItem("en_US", (Object)"Blank");
            obj.getLocaleString(key).remove((Object)"zh_CN");
            obj.getLocaleString(key).remove((Object)"zh_TW");
            obj.getLocaleString(key).remove((Object)"en_US");
        }
    }

    private static void traversalProperties(Set<String> inputProperties, Multimap<String, Object> propertyValueMap, List<Map<String, Object>> objects) {
        for (Map<String, Object> object : objects) {
            object.forEach((key, value) -> {
                inputProperties.add((String)key);
                propertyValueMap.put(key, value);
            });
        }
    }
}

