/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.utils.translate;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;

public class ValueHandlerContext {
    private static final Log log = LogFactory.getLog(ValueHandlerContext.class);
    private Map<String, HRBaseServiceHelper> baseDataServiceHelperMap;
    private final DynamicObjectType dt;
    private final Multimap<String, Object> propertyValueMap;
    private Multimap<Class<?>, String> typeEntityMap;
    private Map<String, Class<?>> propertyTypeMap;
    private Map<String, String> propertyNameToOrm = new HashMap<String, String>(16);
    private Map<Integer, List<String>> errorsMsg = new HashMap<Integer, List<String>>(16);
    private Map<String, Map<String, List<DynamicObject>>> preBaseData = new HashMap<String, Map<String, List<DynamicObject>>>(16);
    private Map<String, Set<String>> numberToEnumValue = new HashMap<String, Set<String>>(16);
    private Map<String, String> numberToSelectFiled = new HashMap<String, String>(16);

    public ValueHandlerContext(DynamicObjectType dt, Multimap<String, Object> propertyValueMap, DataEntityPropertyCollection properties) {
        this.propertyValueMap = propertyValueMap;
        this.dt = dt;
        this.initializeSelf();
        this.loadDataFromDB();
    }

    private void initializeSelf() {
        DataEntityPropertyCollection properties = this.dt.getProperties();
        this.typeEntityMap = ArrayListMultimap.create();
        this.propertyTypeMap = new HashMap();
        for (IDataEntityProperty property : properties) {
            if (property.getPropertyType() == DynamicObject.class) {
                this.typeEntityMap.put((Object)property.getPropertyType(), (Object)((BasedataProp)property).getBaseEntityId());
                this.propertyNameToOrm.put(property.getName(), ((BasedataProp)property).getBaseEntityId());
                String allSelectedFields = ((BasedataProp)property).getComplexType().toString();
                String selectedFields = allSelectedFields.substring(allSelectedFields.indexOf("[") + 1, allSelectedFields.lastIndexOf("]"));
                this.numberToSelectFiled.computeIfAbsent(property.getName(), x -> selectedFields);
            }
            if (property instanceof ComboProp) {
                Set enumValues = this.numberToEnumValue.computeIfAbsent(property.getName(), x -> new HashSet());
                List comboItems = ((ComboProp)property).getComboItems();
                for (ValueMapItem valueMapItem : comboItems) {
                    enumValues.add(valueMapItem.getValue());
                }
            }
            this.propertyTypeMap.put(property.getName(), property.getPropertyType());
        }
        this.baseDataServiceHelperMap = new HashMap<String, HRBaseServiceHelper>(16);
        this.typeEntityMap.get(DynamicObject.class).forEach(entity -> this.baseDataServiceHelperMap.computeIfAbsent((String)entity, x -> new HRBaseServiceHelper(entity)));
    }

    private void loadDataFromDB() {
        this.propertyNameToOrm.forEach((key, value) -> {
            Collection objects = this.propertyValueMap.get(key);
            if (objects != null && !objects.isEmpty()) {
                try {
                    String entityType = HisCommonService.getInstance().entityInhRelation(value);
                    if (EnumEntityTpl.COMMON_TPL.getNumber().equals(entityType)) {
                        this.preBaseData.put((String)key, Arrays.stream(this.baseDataServiceHelperMap.get(value).query(this.numberToSelectFiled.get(key), new QFilter[]{new QFilter("number", "in", (Object)objects)})).collect(Collectors.groupingBy(dyn -> dyn.getString("number"))));
                    } else {
                        this.preBaseData.put((String)key, Arrays.stream(this.baseDataServiceHelperMap.get(value).query(this.numberToSelectFiled.get(key), new QFilter[]{new QFilter("number", "in", (Object)objects), new QFilter("iscurrentversion", "=", (Object)"1")})).collect(Collectors.groupingBy(dyn -> dyn.getString("number"))));
                    }
                }
                catch (Exception ex) {
                    log.error("this {} can not load dynamic object from db", key, (Object)ex);
                    throw new KDException(new ErrorCode("error", "this " + key + " can not load dynamic object from db"), new Object[0]);
                }
            }
        });
    }

    public Map<Integer, List<String>> getErrorsMsg() {
        return this.errorsMsg;
    }

    public Map<String, Class<?>> getPropertyTypeMap() {
        return this.propertyTypeMap;
    }

    public Map<String, Map<String, List<DynamicObject>>> getPreBaseData() {
        return this.preBaseData;
    }

    public Map<String, Set<String>> getNumberToEnumValue() {
        return this.numberToEnumValue;
    }

    public Map<String, HRBaseServiceHelper> getBaseDataServiceHelperMap() {
        return this.baseDataServiceHelperMap;
    }

    public Map<String, String> getPropertyNameToOrm() {
        return this.propertyNameToOrm;
    }
}

