/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.common.constants;

import java.util.Arrays;

public enum PositionHisEnum {
    ORG("adminorg", "haos_adminorghr", "haos_orgtreelistf7"),
    POSITION_TYPE("positiontype", "hbpm_positiontype", "bos_listf7"),
    POSITION_CLASSIFY("positionclassify", "hbpm_positionclassify", "bos_listf7"),
    GROUP("group", "hbpm_positiongroup", "bos_listf7"),
    KEY_POSITION("keyposition", "hbpm_keypositiontype", "bos_listf7"),
    DEPUTY_TYPE("deputytype", "hbpm_deputytype", "bos_listf7"),
    JOB_SCM("jobscm", "hbjm_jobscmhr", "bos_listf7"),
    JOB_SEQ("jobseq", "hbjm_jobseqhr", "hbp_hislistf7"),
    JOB_FAMILY("jobfamily", "hbjm_jobfamilyhr", "hbp_hislistf7"),
    JOB_CLASS("jobclass", "hbjm_jobclasshr", "hbjm_jobclasstreelistf7"),
    JOB("job", "hbjm_jobhr", "hbjm_jobtreelistf7"),
    MAIN_ORG("org", "bos_org", "bos_orgtreelistf7"),
    QUERY("query", "", ""),
    IS_LEADER("isleader", "", "");

    private String operateName;
    private String entityName;
    private String entityF7Name;

    private PositionHisEnum(String name, String entityName, String entityF7Name) {
        this.operateName = name;
        this.entityName = entityName;
        this.entityF7Name = entityF7Name;
    }

    public String getOperateName() {
        return this.operateName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityF7Name() {
        return this.entityF7Name;
    }

    public static PositionHisEnum getPositionHisByOperate(String operateName) {
        return Arrays.stream(PositionHisEnum.values()).filter(en -> en.operateName.equals(operateName)).findFirst().orElse(null);
    }
}

