/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.common.util;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;

public final class LocalDateRange
implements Serializable {
    private static final LocalDate MINP1 = LocalDate.MIN.plusDays(1L);
    private static final LocalDate MAXM1 = LocalDate.MAX.minusDays(1L);
    private static final long serialVersionUID = 3358656715467L;
    private final LocalDate start;
    private final LocalDate end;

    public static LocalDateRange ofClosed(Date startInclusive, Date endInclusive) {
        LocalDate startInclusiveLocalDate = ZonedDateTime.ofInstant(startInclusive.toInstant(), ZoneId.systemDefault()).toLocalDate();
        LocalDate endInclusiveLocalDate = ZonedDateTime.ofInstant(endInclusive.toInstant(), ZoneId.systemDefault()).toLocalDate();
        Objects.requireNonNull(startInclusiveLocalDate, "startInclusive");
        Objects.requireNonNull(endInclusiveLocalDate, "endInclusive");
        if (endInclusiveLocalDate.isBefore(startInclusiveLocalDate)) {
            throw new DateTimeException("Start date must be on or before end date");
        }
        LocalDate end = endInclusiveLocalDate.equals(LocalDate.MAX) ? LocalDate.MAX : endInclusiveLocalDate.plusDays(1L);
        return new LocalDateRange(startInclusiveLocalDate, end);
    }

    public static LocalDateRange ofUnboundedStart(LocalDate endExclusive) {
        return LocalDateRange.of(LocalDate.MIN, endExclusive);
    }

    public static LocalDateRange of(LocalDate startInclusive, LocalDate endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return new LocalDateRange(startInclusive, endExclusive);
    }

    private LocalDateRange(LocalDate startInclusive, LocalDate endExclusive) {
        if (endExclusive.isBefore(startInclusive) || startInclusive.equals(MAXM1) || endExclusive.equals(MINP1) || endExclusive.equals(LocalDate.MIN) || startInclusive.equals(LocalDate.MAX)) {
            throw new DateTimeException("date param wrong");
        }
        this.start = startInclusive;
        this.end = endExclusive;
    }

    public LocalDate getStart() {
        return this.start;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public LocalDate getEndInclusive() {
        if (this.isUnboundedEnd()) {
            return LocalDate.MAX;
        }
        return this.end.minusDays(1L);
    }

    public boolean isUnboundedEnd() {
        return this.end.equals(LocalDate.MAX);
    }

    public boolean isConnected(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        return this.equals(other) || this.start.compareTo(other.end) <= 0 && other.start.compareTo(this.end) <= 0;
    }

    public boolean overlaps(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        return other.equals(this) || this.start.compareTo(other.end) < 0 && other.start.compareTo(this.end) < 0;
    }

    public LocalDateRange intersection(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        if (!this.isConnected(other)) {
            throw new DateTimeException("Ranges do not connect: " + this + " and " + other);
        }
        int cmpStart = this.start.compareTo(other.start);
        int cmpEnd = this.end.compareTo(other.end);
        if (cmpStart >= 0 && cmpEnd <= 0) {
            return this;
        }
        if (cmpStart <= 0 && cmpEnd >= 0) {
            return other;
        }
        LocalDate newStart = cmpStart >= 0 ? this.start : other.start;
        LocalDate newEnd = cmpEnd <= 0 ? this.end : other.end;
        return LocalDateRange.of(newStart, newEnd);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LocalDateRange) {
            LocalDateRange other = (LocalDateRange)obj;
            return this.start.equals(other.start) && this.end.equals(other.end);
        }
        return false;
    }

    public int hashCode() {
        return this.start.hashCode() ^ this.end.hashCode();
    }

    public String toString() {
        return this.start.toString() + '/' + this.end.toString();
    }
}

