/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.formplugin.web.impt;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.newhismodel.impt.HisBatchImportPlugin;
import kd.hrmp.hbpm.formplugin.web.impt.PositionRelationImportPlugin;

public class PositionReviseImportPlugin
extends HisBatchImportPlugin {
    private static final Log LOG = LogFactory.getLog(PositionRelationImportPlugin.class);

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        String importType = (String)this.ctx.getOption().get("importtype");
        this.beforeCheck(importType, billdatas, logger);
        if (CollectionUtils.isEmpty(billdatas)) {
            return;
        }
        super.beforeSave(billdatas, logger);
    }

    private void beforeCheck(String importType, List<ImportBillData> billdatas, ImportLogger logger) {
        StringBuilder msg = new StringBuilder();
        if (!HRStringUtils.equals((String)importType, (String)"override")) {
            this.appendMsg(msg, ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u201d\u3002", (String)"PositionReviseImportPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
        }
        if (billdatas.get(0).getData().containsKey((Object)"entryentity")) {
            this.appendMsg(msg, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6a21\u677f\u4e2d\u542b\u6709\u534f\u4f5c\u5173\u7cfb\u5206\u5f55\uff0c\u66f4\u65b0\u534f\u4f5c\u5173\u7cfb\u8bf7\u4f7f\u7528\u201c\u534f\u4f5c\u5173\u7cfb\u5bfc\u5165\u201d\u529f\u80fd\u3002", (String)"PositionReviseImportPlugin_1", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
        }
        if (billdatas.get(0).getData().containsKey((Object)"positiontpl")) {
            this.appendMsg(msg, ResManager.loadKDString((String)"\u4fee\u8ba2\u5bfc\u5165\u65f6\u4e0d\u53ef\u7ef4\u62a4\u5c97\u4f4d\u6a21\u677f\u5b57\u6bb5\u3002", (String)"PositionReviseImportPlugin_2", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
        }
        Iterator<ImportBillData> it = billdatas.iterator();
        Date now = HRDateTimeUtils.getNowDate();
        while (it.hasNext()) {
            ImportBillData billdata = it.next();
            JSONObject data = billdata.getData();
            Date bsed = null;
            try {
                bsed = HRDateTimeUtils.parseDate((String)data.getString("bsed"), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                this.appendMsg(msg, ResManager.loadKDString((String)"\u201c\u751f\u6548\u65e5\u671f\u201d\u683c\u5f0f\u9519\u8bef\u3002", (String)"PositionReviseImportPlugin_3", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
            }
            if (bsed != null && bsed.after(now)) {
                this.appendMsg(msg, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionReviseImportPlugin_4", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
            }
            if (msg.toString().length() <= 0) continue;
            logger.log(Integer.valueOf(billdata.getStartIndex()), msg.toString());
            logger.fail();
            it.remove();
        }
    }

    private void appendMsg(StringBuilder msg, String appendMsg) {
        if (msg.toString().length() > 0) {
            msg.append("\uff1b");
        }
        msg.append(appendMsg);
    }

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            try {
                FormView formView = (FormView)view.get(ctx);
                formView.setVisible(Boolean.valueOf(false), new String[]{"radiofield", "radiofield2"});
                formView.setEnable(Boolean.valueOf(false), new String[]{"radiofield", "radiofield2", "keyfields"});
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        return super.setContext(rc, ctx, startArgs);
    }

    protected String getImportSaveOpNum() {
        return "reviseimportsave";
    }
}

