/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.formplugin.web.impt;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.formplugin.web.impt.PositionBaseImportPlugin;
import kd.hrmp.hbpm.formplugin.web.impt.PositionImportDataSaveNew;

public class PositionRuleNumberImportPlugin
extends PositionBaseImportPlugin {
    @Override
    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        String importType = (String)this.ctx.getOption().get("importtype");
        this.beforeCheck(importType, billdatas, logger);
        if (CollectionUtils.isEmpty(billdatas)) {
            return;
        }
        super.beforeSave(billdatas, logger);
        if (HRStringUtils.equals((String)importType, (String)"new")) {
            this.handelRuleNumber(billdatas, logger);
        }
    }

    private void beforeCheck(String importType, List<ImportBillData> billdatas, ImportLogger logger) {
        if (HRStringUtils.equals((String)importType, (String)"override") && billdatas.get(0).getData().containsKey((Object)"entryentity")) {
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6a21\u677f\u4e2d\u542b\u6709\u534f\u4f5c\u5173\u7cfb\u5206\u5f55\uff0c\u66f4\u65b0\u534f\u4f5c\u5173\u7cfb\u8bf7\u4f7f\u7528\u201c\u534f\u4f5c\u5173\u7cfb\u5bfc\u5165\u201d\u529f\u80fd\u3002", (String)"PositionRuleNumberImportPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]);
            Iterator<ImportBillData> it = billdatas.iterator();
            while (it.hasNext()) {
                ImportBillData billdata = it.next();
                logger.log(Integer.valueOf(billdata.getStartIndex()), msg);
                logger.fail();
                it.remove();
            }
            return;
        }
        if (CollectionUtils.isEmpty(billdatas)) {
            return;
        }
        boolean haveTplField = billdatas.get(0).getEntityMapping().getCols().containsKey("positiontpl");
        HashMap numberToFieldMap = new HashMap();
        String msg = ResManager.loadKDString((String)"\u5c97\u4f4d\u201c\u66f4\u65b0\u5bfc\u5165\u201d\u65f6\u4e0d\u53ef\u7ef4\u62a4\u5c97\u4f4d\u6a21\u677f\u5b57\u6bb5\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionRuleNumberImportPlugin_1", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]);
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            ImportBillData billdata = it.next();
            JSONObject jsonObject = billdata.getData();
            if (haveTplField && jsonObject.containsKey((Object)"positiontpl") && HRStringUtils.equals((String)importType, (String)"override")) {
                logger.log(Integer.valueOf(billdata.getStartIndex()), msg);
                logger.fail();
                it.remove();
                continue;
            }
            if (!HRStringUtils.equals((String)importType, (String)"override")) continue;
            numberToFieldMap.put(jsonObject.getString("number"), new ArrayList(jsonObject.keySet()));
        }
        if (CollectionUtils.isEmpty(billdatas)) {
            return;
        }
        if (HRStringUtils.equals((String)importType, (String)"override")) {
            HRAppCache.get((String)"hbpm").put("IMPORT_UPD_NUMBER_FIELDS" + RequestContext.get().getTraceId(), numberToFieldMap);
            HashMap fieldToDisplayNameMap = new HashMap();
            billdatas.get(0).getEntityMapping().getCols().forEach((key, value) -> fieldToDisplayNameMap.put(key, value.getDisplayName()));
            HRAppCache.get((String)"hbpm").put("IMPORT_UPD_FIELDS_NAME" + RequestContext.get().getTraceId(), fieldToDisplayNameMap);
        }
    }

    private void handelRuleNumber(List<ImportBillData> billdatas, ImportLogger logger) {
        long[] ids = ORM.create().genLongIds("hbpm_positionhr", billdatas.size());
        HashMap generateIds = Maps.newHashMapWithExpectedSize((int)billdatas.size());
        for (int index = 0; index < billdatas.size(); ++index) {
            JSONObject data = billdatas.get(index).getData();
            if (data.containsKey((Object)"number") && !StringUtils.isEmpty((CharSequence)data.getString("number"))) continue;
            data.put("number", (Object)String.valueOf(ids[index]));
            generateIds.put(String.valueOf(ids[index]), ids[index]);
        }
        HRAppCache.get((String)"hbpm").put("IMPORT_NEW_GENERATE_NUMBERS" + RequestContext.get().getTraceId(), (Object)generateIds);
    }

    public AbstractOperateWebApi getSaveWebApi() {
        super.getSaveWebApi();
        return new PositionImportDataSaveNew();
    }
}

