/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.formplugin.web.impt;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.domain.repository.position.PositionTplRepository;
import org.apache.commons.collections4.MapUtils;

public class PositionTplImportPlugin
extends BatchImportPlugin {
    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        boolean isNewType = this.isNewType();
        this.beforeCheck(isNewType, billdatas, logger);
    }

    private void beforeCheck(boolean isNewType, List<ImportBillData> billdatas, ImportLogger logger) {
        HashMap groupByNumberMap = new HashMap(billdatas.size() << 1);
        String langTag = RequestContext.get().getLang().toString();
        ArrayList numberList = new ArrayList(billdatas.size() << 1);
        ArrayList nameList = new ArrayList(billdatas.size() << 1);
        billdatas.forEach(temp -> {
            JSONObject data = temp.getData();
            ArrayList<ImportBillData> groupByList = (ArrayList<ImportBillData>)groupByNumberMap.get("number");
            if (groupByList == null) {
                groupByList = new ArrayList<ImportBillData>(16);
            }
            groupByList.add((ImportBillData)temp);
            groupByNumberMap.put(data.getString("number"), groupByList);
            numberList.add(data.getString("number"));
            Map tempNameMap = (Map)data.get((Object)"name");
            nameList.add(tempNameMap.get(langTag));
            this.handleGradeAndLevelField(data, "lowjobgrade");
            this.handleGradeAndLevelField(data, "highjobgrade");
            this.handleGradeAndLevelField(data, "lowjoblevel");
            this.handleGradeAndLevelField(data, "highjoblevel");
        });
        DynamicObject[] queryByNameTplList = PositionTplRepository.getInstance().queryEnablePositionTplByName(nameList);
        DynamicObject[] queryByNumberTplList = PositionTplRepository.getInstance().queryEnablePositionTplByNumber(numberList);
        Map<String, List<DynamicObject>> repeatNameInDb = Arrays.asList(queryByNameTplList).stream().collect(Collectors.groupingBy(temp -> temp.getString("name")));
        Map<String, List<DynamicObject>> repeatNumberInDb = Arrays.asList(queryByNumberTplList).stream().collect(Collectors.groupingBy(temp -> temp.getString("number")));
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            List<DynamicObject> dynamicObjects;
            boolean present;
            ImportBillData billdata = it.next();
            JSONObject data = billdata.getData();
            String tempNumber = data.getString("number");
            JSONObject orgJsonObj = data.getJSONObject("org");
            String orgNunmber = orgJsonObj.getString("number");
            List extendedDataEntities = (List)groupByNumberMap.get(tempNumber);
            StringBuilder errorMsg = new StringBuilder();
            boolean validateResult = true;
            if (isNewType && (extendedDataEntities.size() > 1 || repeatNumberInDb.get(tempNumber) != null)) {
                errorMsg.append(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u91cd\u590d;", (String)"", (String)"", (Object[])new Object[0]));
                validateResult = false;
            }
            Map tempNameMap = (Map)data.get((Object)"name");
            String tempName = (String)tempNameMap.get(langTag);
            if (isNewType && repeatNameInDb.get(tempName) != null) {
                errorMsg.append(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e0e\u5df2\u542f\u7528\u6570\u636e\u91cd\u590d;", (String)"", (String)"", (Object[])new Object[0]));
                validateResult = false;
            }
            if (!isNewType && repeatNameInDb.get(tempName) != null && (present = (dynamicObjects = repeatNameInDb.get(tempName)).stream().filter(temp -> !tempNumber.equals(temp.getString("number"))).findFirst().isPresent())) {
                errorMsg.append(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e0e\u5df2\u542f\u7528\u6570\u636e\u91cd\u590d;", (String)"", (String)"", (Object[])new Object[0]));
                validateResult = false;
            }
            if (!this.validateSepecialString(tempName)) {
                errorMsg.append(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08!_/\\\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"", (String)"", (Object[])new Object[0]));
                validateResult = false;
            }
            if (!isNewType) {
                dynamicObjects = repeatNumberInDb.get(tempNumber);
                if (dynamicObjects == null) {
                    return;
                }
                present = dynamicObjects.stream().filter(temp -> !temp.getString("org.number").equals(orgNunmber)).findFirst().isPresent();
                if (present) {
                    errorMsg.append(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"", (String)"", (Object[])new Object[0]));
                    validateResult = false;
                }
            }
            if (validateResult) continue;
            logger.log(Integer.valueOf(billdata.getStartIndex()), errorMsg.toString());
            logger.fail();
            it.remove();
        }
    }

    private void handleGradeAndLevelField(JSONObject data, String field) {
        if (!data.containsKey((Object)field)) {
            return;
        }
        JSONObject importField = data.getJSONObject(field);
        if (importField == null) {
            data.remove((Object)field);
            data.put(field + "text", null);
            return;
        }
        String importprop = importField.getString("importprop");
        if (!HRStringUtils.equals((String)importprop, (String)"name")) {
            return;
        }
        String value = importField.getString(importprop);
        data.remove((Object)field);
        data.put(field + "text", (Object)value);
    }

    private boolean validateSepecialString(String name) {
        if (name == null) {
            return true;
        }
        return !name.contains("!") && !name.contains("_") && !name.contains("\\") && !name.contains("/");
    }

    private boolean isNewType() {
        Map option = this.ctx.getOption();
        if (MapUtils.isEmpty((Map)option)) {
            return false;
        }
        Object importtype = option.get("importtype");
        return StringUtils.isBlank(importtype) ? false : StringUtils.equals((CharSequence)"new", (CharSequence)importtype.toString());
    }
}

