/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.formplugin.web.position;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hbpm.business.domain.repository.position.PositionBillQueryRepository;
import kd.hrmp.hbpm.business.utils.PositionHisQueryPageUtil;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class OrgPositionListPlugin
extends HRDataBaseList {
    private static final Log logger = LogFactory.getLog(OrgPositionListPlugin.class);
    public static String ORDER_BY = "isleader asc,index asc,number asc";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        args.getCommonFilterColumns().stream().filter(filterColumn -> "enable".equals(filterColumn.getFieldName())).findAny().ifPresent(filterColumn -> filterColumn.setDefaultValue("1"));
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        QFilter hisFilter;
        super.setFilter(setFilterEvent);
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        List qFilters = setFilterEvent.getQFilters();
        if (Objects.nonNull(formShowParameter.getCustomParam("currentObjectPKId"))) {
            Long adminorg = Long.parseLong((String)formShowParameter.getCustomParam("currentObjectPKId"));
            qFilters.add(new QFilter("adminorg.id", "=", (Object)adminorg));
        }
        Map maps = (Map)this.getView().getFormShowParameter().getCustomParam("customvariables");
        Date date = new Date();
        if (!CollectionUtils.isEmpty((Map)maps)) {
            date = PositionUtils.formatDate((String)((String)maps.get("searchdate")));
        }
        if (Objects.nonNull(hisFilter = PositionUtils.getHisFilter((Date)date))) {
            qFilters.add(hisFilter);
        } else {
            qFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        }
        qFilters.add(new QFilter("enable", "in", (Object)new String[]{"1", "0"}));
        qFilters.add(new QFilter("createmode", "!=", (Object)"3"));
        setFilterEvent.setOrderBy(ORDER_BY);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        for (IListColumn iListColumn : columns) {
            if (!"number".equals(iListColumn.getListFieldKey()) && !"name".equals(iListColumn.getListFieldKey())) continue;
            iListColumn.setFixed(true);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        Object primaryKeyValue = list.getFocusRowPkId();
        this.clickDataDeal(primaryKeyValue);
    }

    private void clickDataDeal(Object primaryKeyValue) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_positionhr");
        boolean existsFlag = serviceHelper.isExists(primaryKeyValue);
        if (existsFlag) {
            this.showPositionPage();
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"PositionTreeList_3", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showPositionPage() {
        Date date;
        IListView listview = (IListView)this.getView();
        String positionId = listview.getFocusRowPkId().toString();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("homs_positionbill");
        DynamicObject positionBill = PositionBillQueryRepository.getInstance().queryPositionBillByPositionId(Long.valueOf(positionId));
        showParameter.setCustomParam("position", (Object)positionId);
        showParameter.setCustomParam("operationStatus", (Object)"readOnly");
        showParameter.setCustomParam("skiporigin", (Object)"hbpm_positionlist");
        Map maps = (Map)this.getView().getFormShowParameter().getCustomParam("customvariables");
        if (maps != null && Objects.nonNull(date = PositionUtils.formatDate((String)((String)maps.get("searchdate"))))) {
            showParameter.setCustomParam("operationStatus", (Object)"showHistory");
            showParameter.setCustomParam("historyDate", (Object)date);
            showParameter.setCustomParam("historyField", (Object)"adminorg,parent");
        }
        if (positionBill == null || "showHistory".equals(showParameter.getCustomParam("operationStatus"))) {
            showParameter.setCustomParam("hasPositionBill", (Object)"false");
            long currUserId = RequestContext.get().getCurrUserId();
            boolean hasViewPerm = PermissionServiceHelper.hasSpecificPerm((long)currUserId, (String)"homs", (String)"homs_positionbill", (String)"47150e89000000ac");
            if (!hasViewPerm) {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u5c97\u4f4d\u7533\u8bf7\u5355\u201d\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PositionlistPlugIn_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
            showParameter.setHasRight(true);
        } else {
            showParameter.setPkId((Object)positionBill.getLong("id"));
        }
        showParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5c97\u4f4d - %s", (String)"PositionTreeList_1", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]), listview.getCurrentSelectedRowInfo().getName()));
        showParameter.setStatus(OperationStatus.VIEW);
        if (this.getView().getFormShowParameter().getCustomParam("unitTest") != null) {
            return;
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        super.beforePackageData(event);
        DynamicObjectCollection pageData = event.getPageData();
        Map maps = (Map)this.getView().getFormShowParameter().getCustomParam("customvariables");
        Date date = new Date();
        if (!CollectionUtils.isEmpty((Map)maps)) {
            date = PositionUtils.formatDate((String)((String)maps.get("searchdate")));
        }
        if (Objects.nonNull(date)) {
            PositionHisQueryPageUtil.batchPositionHisList((String)"adminorg,parent", (DynamicObjectCollection)pageData, (Date)date);
        }
    }
}

