/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.formplugin.web.position;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hbpm.business.application.impl.position.PositionChangeDetailApplicationImpl;
import kd.hrmp.hbpm.business.domain.bo.position.ChangeDetailBo;
import kd.hrmp.hbpm.business.domain.repository.position.PositionChangeDetailRepository;

public class PositionChangeDetailListPlugin
extends HRDataBaseList {
    private final Map<String, String> SEARCH_MAP = new HashMap<String, String>(4);
    private static final String DETAILENTRYCOL = "evententry.detailentry.id";
    private static final String DETAILENTRYCOL_AFTERVALUE = "evententry.detailentry.aftervalue";
    private static final String DETAILENTRYCOL_BEFOREVALUE = "evententry.detailentry.beforevalue";
    private static final String DETAILENTRYCOL_PROPKEY = "evententry.detailentry.propkey";
    private Map<String, DataEntityPropertyCollection> propsMap;

    public PositionChangeDetailListPlugin() {
        this.SEARCH_MAP.put("searchchangedate", "evententry.changedate");
        this.SEARCH_MAP.put("searchchangereason.id", "evententry.changereason.id");
        this.propsMap = new HashMap<String, DataEntityPropertyCollection>(4);
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        List qFilterList = setFilterEvent.getQFilters();
        this.replaceProperty(qFilterList);
        setFilterEvent.setOrderBy("position.adminorg.id,position.id,evententry.operatetime desc");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Object entryPrimaryKeyValue = event.getCurrentRow().getEntryPrimaryKeyValue();
        DynamicObject changeDetail = PositionChangeDetailRepository.getInstance().getEventInfoByEntryId(entryPrimaryKeyValue);
        if (changeDetail == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PositionChangeDetailListPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject position = changeDetail.getDynamicObject("hisposition");
        if (position == null) {
            position = changeDetail.getDynamicObject("targetposition");
        }
        if (position == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PositionChangeDetailListPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
            return;
        }
        Date bsed = changeDetail.getDate("changedate");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("homs_positionbill");
        showParameter.setCustomParam("position", (Object)position.getString("id"));
        showParameter.setCustomParam("operationStatus", (Object)"showHistory");
        showParameter.setCustomParam("hasPositionBill", (Object)"false");
        showParameter.setCustomParam("historyDate", (Object)bsed);
        String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5c97\u4f4d - %1$s", (String)"PositionRelationChartPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), position.getString("name"));
        showParameter.setCaption(message);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setHasRight(true);
        if (this.getView().getFormShowParameter().getCustomParam("unitTest") != null) {
            return;
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        super.beforePackageData(event);
        DynamicObjectCollection pageData = event.getPageData();
        if (CollectionUtils.isEmpty((Collection)pageData)) {
            return;
        }
        DataEntityPropertyCollection props = ((DynamicObject)pageData.get(0)).getDataEntityType().getProperties();
        if (this.isShowDetail(props)) {
            ArrayList detailIds = new ArrayList(pageData.size());
            pageData.stream().forEach(data -> {
                Long detailId = data.getLong(DETAILENTRYCOL);
                if (detailId != null && detailId > 0L) {
                    detailIds.add(detailId);
                }
            });
            PositionChangeDetailApplicationImpl positionChangeDetailApplication = new PositionChangeDetailApplicationImpl();
            List bos = positionChangeDetailApplication.getChangeDetail(detailIds);
            if (bos != null && bos.size() > 0) {
                Map<Long, ChangeDetailBo> queryDataMap = bos.stream().collect(Collectors.toMap(ChangeDetailBo::getDetailId, v1 -> v1, (v1, v2) -> v2));
                pageData.stream().forEach(data -> {
                    Long detailId = data.getLong(DETAILENTRYCOL);
                    ChangeDetailBo bo = (ChangeDetailBo)queryDataMap.get(detailId);
                    if (bo != null) {
                        data.set(DETAILENTRYCOL_AFTERVALUE, (Object)bo.getAfterValueDisplay());
                        data.set(DETAILENTRYCOL_BEFOREVALUE, (Object)bo.getBeforeValueDisplay());
                        data.set(DETAILENTRYCOL_PROPKEY, (Object)this.getPropDisplayName(bo.getChangEntity(), bo.getPropKey()));
                    }
                });
            }
        }
    }

    private void replaceProperty(List<QFilter> qFilterList) {
        qFilterList.forEach(qFilter -> {
            String value = this.SEARCH_MAP.get(qFilter.getProperty());
            if (value != null) {
                qFilter.__setProperty(value);
                qFilter.getNests(false).forEach(nest -> {
                    String nestValue = this.SEARCH_MAP.get(nest.getFilter().getProperty());
                    if (nestValue != null) {
                        nest.getFilter().__setProperty(nestValue);
                    }
                });
            }
        });
    }

    private boolean isShowDetail(DataEntityPropertyCollection props) {
        for (IDataEntityProperty prop : props) {
            if (!HRStringUtils.equals((String)prop.getName(), (String)DETAILENTRYCOL)) continue;
            return true;
        }
        return false;
    }

    private String getPropDisplayName(String entityCode, String propKey) {
        String displayName = "";
        DataEntityPropertyCollection props = this.getMainEntityProps(entityCode);
        for (IDataEntityProperty prop : props) {
            if (!HRStringUtils.equals((String)prop.getName(), (String)propKey)) continue;
            displayName = prop.getDisplayName().getLocaleValue();
            break;
        }
        return displayName;
    }

    private DataEntityPropertyCollection getMainEntityProps(String entityCode) {
        DataEntityPropertyCollection props = this.propsMap.get(entityCode);
        if (props == null) {
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityCode);
            props = mainEntityType.getProperties();
        }
        return props;
    }
}

