/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.formplugin.web.position;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.ReviseLogRepository;
import kd.hrmp.hbpm.formplugin.web.position.AbstractBUListPlugin;

public class PositionReviseLogList
extends AbstractBUListPlugin {
    private Map<Long, String> versionDateMap = null;

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (showParameter.getCustomParam("position") != null) {
            List positionIds = JSONObject.parseArray((String)showParameter.getCustomParam("position").toString(), Long.class);
            setFilterEvent.getQFilters().add(new QFilter("positionbo", "in", (Object)positionIds));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                List rowIds = rows.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
                if (!rowIds.isEmpty()) {
                    PositionReviseLogList.this.versionDateMap = PositionReviseLogList.this.getVersionDate(rowIds);
                }
                return rows;
            }
        });
    }

    private Map<Long, String> getVersionDate(List<Long> rowIds) {
        HashMap<Long, String> versionDateMap = new HashMap<Long, String>(rowIds.size());
        DynamicObject[] reviseLogs = ReviseLogRepository.getInstance().queryByIds(rowIds);
        List positionIds = Arrays.asList(reviseLogs).stream().map(reviseLog -> {
            DynamicObjectCollection entryentity = reviseLog.getDynamicObjectCollection("entryentity");
            if (!entryentity.isEmpty()) {
                return ((DynamicObject)entryentity.get(0)).getLong("reviseafter");
            }
            return null;
        }).collect(Collectors.toList());
        DynamicObject[] positions = PositionQueryRepository.getInstance().queryPositionFId(positionIds);
        HashMap<Long, String> posIdToVersionDateMap = new HashMap<Long, String>(rowIds.size());
        for (DynamicObject position : positions) {
            Date bsed = position.getDate("bsed");
            Date bsled = position.getDate("bsled");
            String bsedstr = bsed == null ? "null" : HRInteDateTimeUtil.formatDate((String)"hbpm_positionhr", (String)"bsed", (Date)bsed);
            String bsledstr = bsled == null ? "null" : HRInteDateTimeUtil.formatDate((String)"hbpm_positionhr", (String)"bsled", (Date)bsled);
            posIdToVersionDateMap.put(position.getLong("id"), bsedstr + " ~ " + bsledstr);
        }
        for (DynamicObject reviseLog2 : reviseLogs) {
            DynamicObjectCollection entryentity = reviseLog2.getDynamicObjectCollection("entryentity");
            String versionDate = null;
            if (!entryentity.isEmpty()) {
                versionDate = (String)posIdToVersionDateMap.get(((DynamicObject)entryentity.get(0)).getLong("reviseafter"));
            }
            versionDateMap.put(reviseLog2.getLong("id"), versionDate);
        }
        return versionDateMap;
    }

    public void packageData(PackageDataEvent e) {
        String fieldName = ((ColumnDesc)e.getSource()).getKey();
        if ("versiondate".equals(fieldName)) {
            Long reviseId = e.getRowData().getLong("id");
            e.setFormatValue((Object)this.versionDateMap.get(reviseId));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "viewdetail_donothing": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setFormId("hbpm_reviselogdetail");
                showParameter.setCustomParam("reviseLogId", this.getFocusRowPkId());
                this.getView().showForm(showParameter);
            }
        }
    }
}

