/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.formplugin.web.position;

import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterContainer;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.domain.repository.position.PositionTplTypeRepository;

public class PositionTplList
extends StandardTreeListPlugin {
    private static final String ROOT_ID = "1";

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (filterContainer != null) {
            filterContainer.setBillFormId("hbpm_positiontpl");
        }
    }

    public void registerListener(EventObject e) {
        Search search = (Search)this.getView().getControl("searchap");
        if (null != search) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent evt) {
        super.buildTreeListFilter(evt);
        Long nodeId = Long.parseLong((String)evt.getNodeId());
        if (ROOT_ID.equals(evt.getNodeId())) {
            return;
        }
        QFilter filter = new QFilter("posttpltype", "=", (Object)nodeId);
        evt.addQFilter(filter);
        evt.setCancel(true);
    }

    public void initializeTree(EventObject evt) {
        TreeView treeView = (TreeView)this.getControl("treeview");
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusNode = treeState.getFocusNode();
        if (null != focusNode) {
            this.getView().getFormShowParameter().setCustomParam("id", focusNode.get("id"));
        }
        this.refreshTreeNode();
    }

    private TreeNode loadAllTreeNodes() {
        TreeNode root = new TreeNode("", ROOT_ID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"PostplList_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
        root.setIsOpened(true);
        DataSet rows = PositionTplTypeRepository.getInstance().queryAllIdNameByNumberAsc();
        Iterator iterator = rows.iterator();
        while (rows.hasNext()) {
            Row row = (Row)iterator.next();
            Object id = row.get("id");
            Object name = row.get("name");
            TreeNode childNode = new TreeNode(root.getId(), String.valueOf(id), String.valueOf(name));
            root.addChild(childNode);
        }
        return root;
    }

    public void refreshNode(RefreshNodeEvent evt) {
        TreeNode root = this.loadAllTreeNodes();
        this.getTreeModel().setRoot(root);
        String nodeId = evt.getNodeId().toString();
        if (HRStringUtils.equals((String)ROOT_ID, (String)nodeId)) {
            evt.setChildNodes(root.getChildren());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult;
        String operateKey = args.getOperateKey();
        if ((HRStringUtils.equals((String)operateKey, (String)"enable") || HRStringUtils.equals((String)operateKey, (String)"disable") || HRStringUtils.equals((String)operateKey, (String)"delete") || HRStringUtils.equals((String)operateKey, (String)"refresh")) && (operationResult = args.getOperationResult()) != null && operationResult.isSuccess()) {
            this.refreshTreeNode();
        }
    }

    private void refreshTreeNode() {
        TreeNode root = this.loadAllTreeNodes();
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getTreeModel().setRoot(root);
    }
}

