/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.formplugin.web.position;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hbpm.business.domain.repository.position.PositionBillQueryRepository;

public class PositionlistPlugIn
extends HRDataBaseList {
    private static final Log logger = LogFactory.getLog(PositionlistPlugIn.class);
    private static final Log LOG = LogFactory.getLog(PositionlistPlugIn.class);

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        LOG.info(MessageFormat.format("currentObjectPKId is {0}", formShowParameter.getCustomParam("currentObjectPKId") != null ? Long.valueOf(Long.parseLong((String)formShowParameter.getCustomParam("currentObjectPKId"))) : null));
        if (Objects.nonNull(formShowParameter.getCustomParam("currentObjectPKId"))) {
            Long job = Long.parseLong((String)formShowParameter.getCustomParam("currentObjectPKId"));
            setFilterEvent.getQFilters().add(new QFilter("job.id", "=", (Object)job));
        }
        setFilterEvent.getQFilters().add(new QFilter("enable", "=", (Object)"1"));
        setFilterEvent.getQFilters().add(new QFilter("initstatus", "=", (Object)"2"));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        Object primaryKeyValue = list.getFocusRowPkId();
        this.clickDataDeal(primaryKeyValue);
    }

    private void clickDataDeal(Object primaryKeyValue) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_positionhr");
        boolean existsFlag = serviceHelper.isExists(primaryKeyValue);
        if (existsFlag) {
            this.showPositionPage();
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"PositionTreeList_3", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
        }
    }

    private void showPositionPage() {
        IListView listview = (IListView)this.getView();
        String positionId = listview.getFocusRowPkId().toString();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("homs_positionbill");
        DynamicObject positionBill = PositionBillQueryRepository.getInstance().queryPositionBillByPositionId(Long.valueOf(positionId));
        showParameter.setCustomParam("position", (Object)positionId);
        showParameter.setCustomParam("operationStatus", (Object)"readOnly");
        showParameter.setCustomParam("skiporigin", (Object)"hbpm_positionlist");
        if (positionBill != null) {
            showParameter.setPkId((Object)positionBill.getLong("id"));
        } else {
            showParameter.setCustomParam("hasPositionBill", (Object)"false");
            boolean hasViewPerm = PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)"homs", (String)"homs_positionbill", (String)"47150e89000000ac");
            showParameter.setHasRight(true);
            if (!hasViewPerm) {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u5c97\u4f4d\u7533\u8bf7\u5355\u201d\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PositionlistPlugIn_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
        }
        showParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5c97\u4f4d - %s", (String)"PositionTreeList_1", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]), listview.getCurrentSelectedRowInfo().getName()));
        showParameter.setStatus(OperationStatus.VIEW);
        if (this.getView().getFormShowParameter().getCustomParam("unitTest") != null) {
            return;
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

