/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.formplugin.web.position;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hbpm.business.domain.repository.position.CommonQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.ReviseLogRepository;

public class ReviseLogDetailPlugin
extends HRDataBaseEdit {
    private static final String REVISEFIELDNAME = "revisefieldname";
    private static final String REVISEBEFORE = "revisebefore";
    private static final String REVISEAFTER = "reviseafter";
    private static final String POSITIONNUMBER = "positionnumber";
    private static final String POSITIONNAME = "positionname";
    private static final String REVISEPERSONNAME = "revisepersonname";
    private static final String REVISETIME = "revisetime";
    private static final String BSED = "bsed";

    public void createNewData(BizDataEventArgs e) {
        Long reviseLogId = (Long)this.getView().getFormShowParameter().getCustomParam("reviseLogId");
        DynamicObject reviseLogDyn = ReviseLogRepository.getInstance().queryById(reviseLogId);
        DynamicObjectCollection reviseDetailDynList = reviseLogDyn.getDynamicObjectCollection("entryentity");
        if (reviseDetailDynList != null && reviseDetailDynList.size() > 0) {
            Set fieldkeySet = reviseDetailDynList.stream().map(reviseDetailDyn -> reviseDetailDyn.getString(REVISEFIELDNAME)).collect(Collectors.toSet());
            fieldkeySet.add(BSED);
            fieldkeySet.add("bsled");
            HashSet<Long> conditions = new HashSet<Long>(16);
            Long reviseBeforeId = ((DynamicObject)reviseDetailDynList.get(0)).getLong(REVISEBEFORE);
            Long reviseAfterId = ((DynamicObject)reviseDetailDynList.get(0)).getLong(REVISEAFTER);
            conditions.add(reviseBeforeId);
            conditions.add(reviseAfterId);
            DynamicObject[] queryDatas = CommonQueryRepository.getInstance().loadColsInfoById("hbpm_positionhr", fieldkeySet, conditions);
            Map<Long, DynamicObject> queryDataMap = Arrays.stream(queryDatas).collect(Collectors.toMap(data -> data.getLong("id"), data -> data, (v1, v2) -> v1));
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_positionhr");
            DataEntityPropertyCollection mainEntityTypeProps = mainEntityType.getProperties();
            Map<String, IDataEntityProperty> propMap = mainEntityTypeProps.stream().collect(Collectors.toMap(data -> data.getName(), v1 -> v1, (v1, v2) -> v2));
            HRBaseServiceHelper reviseLogDetailHelper = new HRBaseServiceHelper("hbpm_reviselogdetail");
            DynamicObject reviseLog = reviseLogDetailHelper.generateEmptyDynamicObject();
            DynamicObjectCollection dyns = reviseLog.getDynamicObjectCollection("reviselogdetail");
            for (DynamicObject reviseDetailDyn2 : reviseDetailDynList) {
                String revisefieldname = reviseDetailDyn2.getString(REVISEFIELDNAME);
                String beforeDisplayValue = ReviseLogDetailPlugin.getDisplayValueByProp(queryDataMap.get(reviseBeforeId), propMap.get(revisefieldname));
                String afterDisplayValue = ReviseLogDetailPlugin.getDisplayValueByProp(queryDataMap.get(reviseAfterId), propMap.get(revisefieldname));
                DynamicObject reviseLogDetail = new DynamicObject(dyns.getDynamicObjectType());
                reviseLogDetail.set(REVISEFIELDNAME, (Object)propMap.get(revisefieldname).getDisplayName().getLocaleValue());
                reviseLogDetail.set(REVISEBEFORE, (Object)beforeDisplayValue);
                reviseLogDetail.set(REVISEAFTER, (Object)afterDisplayValue);
                reviseLogDetail.set(POSITIONNUMBER, (Object)reviseLogDyn.getString("positionbo.number"));
                reviseLogDetail.set(POSITIONNAME, (Object)reviseLogDyn.getString("positionbo.name"));
                reviseLogDetail.set(REVISEPERSONNAME, (Object)reviseLogDyn.getString("creator.name"));
                reviseLogDetail.set(REVISETIME, (Object)HRInteDateTimeUtil.formatDate((String)reviseLogDyn.getDataEntityType().getName(), (String)"createtime", (Date)reviseLogDyn.getDate("createtime")));
                reviseLogDetail.set(BSED, (Object)this.getBsedRange(queryDataMap.get(reviseAfterId)));
                dyns.add((Object)reviseLogDetail);
            }
            e.setDataEntity((Object)reviseLog);
        }
    }

    private String getBsedRange(DynamicObject position) {
        Date bsed = position.getDate(BSED);
        Date bsled = position.getDate("bsled");
        String bsedstr = bsed == null ? "null" : HRInteDateTimeUtil.formatDate((String)"hbpm_positionhr", (String)BSED, (Date)bsed);
        String bsledstr = bsled == null ? "null" : HRInteDateTimeUtil.formatDate((String)"hbpm_positionhr", (String)"bsled", (Date)bsled);
        return bsedstr + " ~ " + bsledstr;
    }

    public static String getDisplayValueByProp(DynamicObject dyn, IDataEntityProperty prop) {
        if (prop == null) {
            return null;
        }
        String propName = prop.getName();
        if (prop instanceof MuliLangTextProp) {
            ILocaleString val = dyn.getLocaleString(propName);
            HashSet<String> allStr = new HashSet<String>(4);
            HashSet mulLangType = new HashSet(4);
            mulLangType.addAll(val.keySet());
            for (String type : mulLangType) {
                if (StringUtils.equals((CharSequence)"GLang", (CharSequence)type)) continue;
                String subVal = (String)val.getOrDefault((Object)type, (Object)"");
                allStr.add(subVal + "(" + type + ")");
            }
            return StringUtils.join((Object[])allStr.toArray(), (String)",");
        }
        if (prop instanceof ComboProp) {
            ComboProp comboProp = (ComboProp)prop;
            if (dyn != null) {
                return comboProp.getItemByName(dyn.getString(propName));
            }
        } else if (prop instanceof BasedataProp) {
            DynamicObject propValue;
            BasedataProp basedataProp = (BasedataProp)prop;
            if (dyn != null && (propValue = dyn.getDynamicObject(propName)) != null) {
                return propValue.getString(basedataProp.getDisplayProp());
            }
        } else {
            if (prop instanceof MulBasedataProp) {
                return dyn.getDynamicObjectCollection(prop).stream().map(dy -> dy.getString("fbasedataid.name")).collect(Collectors.joining(","));
            }
            if (prop instanceof DateProp) {
                if (dyn != null) {
                    if (dyn.getDate(propName) == null) {
                        return null;
                    }
                    return HRInteDateTimeUtil.formatDate((String)"hbpm_positionhr", (String)propName, (Date)dyn.getDate(propName));
                }
            } else if (prop instanceof DateTimeProp && dyn != null) {
                if (dyn.getDate(propName) == null) {
                    return null;
                }
                return HRInteDateTimeUtil.formatDate((String)"hbpm_positionhr", (String)propName, (Date)dyn.getDate(propName));
            }
        }
        if (dyn != null) {
            return dyn.getString(propName);
        }
        return null;
    }
}

