/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.formplugin.web.projectrole;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hbpm.business.service.projectrole.ProjectRoleBusiness;
import kd.hrmp.hbpm.business.utils.PRJRoleUtils;
import kd.hrmp.hbpm.business.utils.ProjectRoleCodeRuleHelper;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;
import kd.hrmp.hbpm.common.model.ProjectRoleCodeRuleModel;

public class ImportRolePlanEditPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener,
ProjectRoleConstants {
    private static final String CODE_RULE_MODEL = "paln_role_code_rule_model";
    private static final String SAVE_OP_SUCCESS = "new_role_With_role_plan_success";
    private ProjectRoleCodeRuleModel codeRuleModel;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("roleplan");
        BasedataEdit projTeamBD = (BasedataEdit)this.getView().getControl("projteam");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        projTeamBD.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getCodeRuleModel();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long id = this.getModel().getDataEntity().getLong("id");
        if (id == 0L) {
            this.getModel().deleteEntryData("entryentity");
        }
        this.getModel().setValue("design", (Object)new Date());
        this.getModel().setDataChanged(false);
    }

    public void afterCreateNewData(EventObject e) {
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("projteam");
        if (HRStringUtils.isNotEmpty((String)customParam)) {
            this.getModel().setValue("projteam", (Object)customParam);
        }
        this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)"hbpm_projectrolesdetail");
        this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (HRStringUtils.equals((String)"roleplan", (String)name)) {
            DynamicObject roleplan = this.getModel().getDataEntity().getDynamicObject("roleplan");
            this.getModel().deleteEntryData("entryentity");
            if (!HRObjectUtils.isEmpty((Object)roleplan)) {
                this.addInfoToEntry(roleplan);
            }
            this.handleNumber();
        } else if ("design".equals(name)) {
            this.getModel().setValue("bsed", this.getModel().getValue("design"));
        } else if ("projteam".equals(name)) {
            // empty if block
        }
    }

    private void addInfoToEntry(DynamicObject roleplan) {
        DynamicObjectCollection rolePlanCollection = roleplan.getDynamicObjectCollection("roleentryentity");
        if (rolePlanCollection != null && rolePlanCollection.size() > 0) {
            int count = rolePlanCollection.size();
            this.getModel().batchCreateNewEntryRow("entryentity", count);
            for (int index = 0; index < count; ++index) {
                DynamicObject role = ((DynamicObject)rolePlanCollection.get(index)).getDynamicObject("role");
                ILocaleString name = role.getLocaleString("name");
                String isMainHead = ((DynamicObject)rolePlanCollection.get(index)).getString("ismainhead");
                this.getModel().setValue("planname", (Object)name, index);
                this.getModel().setValue("rolestype", (Object)ProjectRoleBusiness.getRoleTypeDynByMainHead((Boolean)"1".equals(isMainHead)), index);
                this.getModel().setValue("isdutypers", (Object)isMainHead, index);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)"btnsave", (String)source.getOperateKey())) {
            this.getModel().setDataChanged(false);
            this.updateCodeRuleModel();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("btnsave".equals(args.getOperateKey())) {
            this.cacheOpResult(args.getOperationResult());
        }
    }

    private void cacheOpResult(OperationResult operationResult) {
        if (operationResult.isSuccess()) {
            this.getView().getPageCache().put(SAVE_OP_SUCCESS, "true");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        if ("roleplan".equals(propertyName)) {
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("otclassify", "=", (Object)1020L));
        } else if ("projteam".equals(propertyName)) {
            QFilter proRoleCoopOrgPermFilter = PRJRoleUtils.getProRoleCoopOrgPermFilter((String)"homs", (String)"hbpm_projectrolesdetail", (String)"projteam");
            beforeF7SelectEvent.getCustomQFilters().add(proRoleCoopOrgPermFilter);
        }
    }

    public void pageRelease(EventObject e) {
        this.recycleNumber();
    }

    private void handleNumber() {
        this.recycleNumber();
        if (!this.isEntryEmpty()) {
            this.setNumberVal();
            this.setNumberControlState();
        }
    }

    private void recycleNumber() {
        ProjectRoleCodeRuleHelper.recycleNumber((ProjectRoleCodeRuleModel)this.getCodeRuleModel(), (!this.isSaveSuccess() ? 1 : 0) != 0);
    }

    private void setNumberVal() {
        ProjectRoleCodeRuleModel codeRuleModel = this.getCodeRuleModel();
        if (ProjectRoleCodeRuleHelper.isExist((ProjectRoleCodeRuleModel)codeRuleModel)) {
            int rowCount = this.getModel().getEntryEntity("entryentity").getRowCount();
            String[] batchNumber = this.getAndCacheNumber(codeRuleModel, rowCount);
            for (int i = 0; i < rowCount; ++i) {
                this.getModel().setValue("plannumber", (Object)batchNumber[i], i);
            }
        }
    }

    private void setNumberControlState() {
        if (ProjectRoleCodeRuleHelper.isModify((ProjectRoleCodeRuleModel)this.getCodeRuleModel())) {
            this.setPlanNumberEnable(true);
        } else {
            this.setPlanNumberEnable(false);
        }
    }

    private void setPlanNumberEnable(boolean b) {
        int rowCount = this.getModel().getEntryEntity("entryentity").getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.getView().setEnable(Boolean.valueOf(b), i, new String[]{"plannumber"});
        }
    }

    private String[] getAndCacheNumber(ProjectRoleCodeRuleModel codeRuleModel, int rowCount) {
        String[] batchNumber = ProjectRoleCodeRuleHelper.getBatchNumber((ProjectRoleCodeRuleModel)codeRuleModel, (int)rowCount);
        codeRuleModel.setNumbers(batchNumber);
        this.getView().getPageCache().put(CODE_RULE_MODEL, SerializationUtils.toJsonString((Object)codeRuleModel));
        return batchNumber;
    }

    private void updateCodeRuleModel() {
        ProjectRoleCodeRuleModel model = this.getCodeRuleModel();
        String orgId = this.getModel().getDataEntity().getString("projteam.org.id");
        model.setOrgId(orgId);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String[] currentNumbers = (String[])entryEntity.stream().map(row -> row.getString("plannumber")).toArray(String[]::new);
        model.setCurrentNumbers(currentNumbers);
        this.getView().getPageCache().put(CODE_RULE_MODEL, SerializationUtils.toJsonString((Object)model));
    }

    private ProjectRoleCodeRuleModel getCodeRuleModel() {
        if (this.codeRuleModel != null) {
            return this.codeRuleModel;
        }
        String modelJsonStr = this.getView().getPageCache().get(CODE_RULE_MODEL);
        if (StringUtils.isNotEmpty((CharSequence)modelJsonStr)) {
            this.codeRuleModel = (ProjectRoleCodeRuleModel)SerializationUtils.fromJsonString((String)modelJsonStr, ProjectRoleCodeRuleModel.class);
        } else {
            this.codeRuleModel = new ProjectRoleCodeRuleModel();
            this.codeRuleModel.setEntityNumber("hbpm_projectrolesdetail");
            this.codeRuleModel.setOrgId("0");
            this.codeRuleModel.setNumbers(null);
            this.getView().getPageCache().put(CODE_RULE_MODEL, SerializationUtils.toJsonString((Object)this.codeRuleModel));
        }
        return this.codeRuleModel;
    }

    private boolean isEntryEmpty() {
        return this.getModel().getEntryEntity("entryentity").getRowCount() == 0;
    }

    private boolean isSaveSuccess() {
        return this.getView().getPageCache().get(SAVE_OP_SUCCESS) != null;
    }
}

