/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.formplugin.web.projectrole;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hbpm.business.domain.repository.position.ReportingrelationQueryRepository;
import kd.hrmp.hbpm.business.service.projectrole.ProjectRoleBusiness;
import kd.hrmp.hbpm.business.utils.PRJRoleUtils;
import kd.hrmp.hbpm.business.utils.ProjectRoleCodeRuleHelper;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;
import kd.hrmp.hbpm.common.model.ProjectRoleCodeRuleModel;

public class ProjectRoleFormEditPlugin
extends HRDataBaseEdit
implements ProjectRoleConstants,
BeforeF7SelectListener {
    private static final String SYSTEM_TYPE = "hrmp-hbpm-formplugin";
    private static final String META_COOPERATION = "flexpanelap2";
    private static final String REPORT_CORE_TYPE = "reportcoreltype";
    private static final List<String> REGISTER_BEFORE_F7_LISTENER = new ArrayList<String>();
    private ProjectRoleCodeRuleModel codeRuleModel;
    private static final String CODE_RULE_MODEL = "hbpm_code_rule_model";
    private static final String SAVE_OP_SUCCESS = "hbpm_save_success";
    private static final String ACTION_IS_DUTY_CONFIRM = "action_is_duty_confirm";
    private static final String OP_KEY_BEFORE_CONFIRM = "operate_before_confirm";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        REGISTER_BEFORE_F7_LISTENER.forEach(propertyName -> {
            Control control = this.getView().getControl(propertyName);
            if (control instanceof BasedataEdit) {
                ((BasedataEdit)control).addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        });
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BillShowParameter eSource = (BillShowParameter)e.getSource();
        Long id = (Long)eSource.getPkId();
        if (id != null && id != 0L) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_projectroles");
            DynamicObject dy = helper.queryOne("name", (Object)id);
            String prefix = ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272", (String)"ProjectRoleFormEditPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            e.getFormShowParameter().setCaption(String.join((CharSequence)"-", prefix, dy.getString("name")));
        }
    }

    public void beforeBindData(EventObject e) {
        IDataModel model;
        DynamicObject dyn;
        long id;
        super.beforeBindData(e);
        String source = (String)this.getView().getFormShowParameter().getCustomParam("source");
        if (!HRStringUtils.isEmpty((String)source)) {
            this.getModel().setValue("changetype", (Object)ProjectRoleConstants.CHANGEOPER_MODIFY);
        }
        if ((id = (dyn = (model = this.getModel()).getDataEntity()).getLong("id")) != 0L && (HRStringUtils.equals((String)"cooperationchange", (String)source) || HRStringUtils.equals((String)"modify", (String)source))) {
            model.setDataChanged(false);
        }
    }

    public void afterBindData(EventObject e) {
        Object orgObj;
        super.afterBindData(e);
        long id = this.getModel().getDataEntity().getLong("id");
        this.getModel().deleteEntryData("entryentity");
        if (id != 0L) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanelap"});
        }
        String source = (String)this.getView().getFormShowParameter().getCustomParam("source");
        String option = (String)this.getView().getFormShowParameter().getCustomParam("his_action");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"disabledate"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"save_coop_change"});
        if (HRStringUtils.isEmpty((String)source)) {
            if (id != 0L) {
                this.getView().setVisible(Boolean.FALSE, new String[]{META_COOPERATION});
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
                String enable = (String)this.getModel().getValue("enable");
                if ("0".equals(enable)) {
                    this.getModel().setValue("disabledate", this.getModel().getValue("bsed"));
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"design"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"disabledate"});
                }
            }
        } else if (HRStringUtils.equals((String)"modify", (String)source) || HRStringUtils.equals((String)option, (String)"open_insert_data_page")) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
            this.getView().setVisible(Boolean.FALSE, new String[]{META_COOPERATION});
            this.getView().setEnable(Boolean.TRUE, new String[]{"attachmentpanelap"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            this.getModel().setValue("changetype", (Object)1020L);
            this.getModel().setValue("bsed", (Object)new Date());
        } else if (HRStringUtils.equals((String)"cooperationchange", (String)source)) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"save_change"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"save_coop_change"});
            this.setCooperationForm(id);
            this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanelap"});
            this.getModel().setValue("bsed", (Object)new Date());
        } else if (HRStringUtils.equals((String)"new", (String)source)) {
            this.afterBindData4New();
        } else if (this.isPageSourceRelateInfo()) {
            this.afterBindData4RelateInfoNew();
        }
        if ((orgObj = this.getModel().getValue("org")) == null) {
            this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        }
        this.getModel().setDataChanged(false);
        this.forceSetFormTitle();
    }

    private void forceSetFormTitle() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("force_set_caption");
        if (customParam != null && Boolean.parseBoolean(customParam.toString())) {
            this.getView().setFormTitle(new LocaleString(formShowParameter.getCaption()));
        }
    }

    private void setPageCacheMutexInfo() {
        this.getPageCache().put("MUTEX_OBJ_ID", this.getModel().getDataEntity(true).getPkValue().toString());
        this.getPageCache().put("MUTEX_ENTITY_KEY", this.getModel().getDataEntityType().getName());
        this.getPageCache().put("MUTEX_OPER_KEY", "change_donothing");
    }

    public void afterCreateNewData(EventObject e) {
        String customParam;
        long id = this.getModel().getDataEntity().getLong("id");
        if (id == 0L && !HRObjectUtils.isEmpty((Object)(customParam = (String)this.getView().getFormShowParameter().getCustomParam("projteam")))) {
            this.getModel().setValue("projteam", (Object)Long.parseLong(customParam));
            DynamicObject projectTeamDy = this.getModel().getDataEntity().getDynamicObject("projteam");
            Date date = projectTeamDy.getDate("establishmentdate");
            this.getModel().setValue("design", (Object)date);
            Long parentOrgId = projectTeamDy.getDynamicObject("parentorg").getLong("id");
            this.getModel().setValue("org", (Object)projectTeamDy.getDynamicObject("org"));
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_projectroles");
            QFilter projectTeamFilter = new QFilter("projteam", "=", (Object)Long.parseLong(customParam));
            QFilter dutyPersonFilter = new QFilter("isdutypers", "=", (Object)"1");
            DynamicObject dutyPersonDy = helper.queryOne("id", new QFilter[]{projectTeamFilter, Q_FILTER_ENABLE, dutyPersonFilter, FILTER_IS_CURRENT_VERSION});
            if (HRObjectUtils.isEmpty((Object)dutyPersonDy)) {
                this.getModel().setValue("isdutypers", (Object)Boolean.TRUE);
                QFilter parentFilter = new QFilter("projteam", "=", (Object)parentOrgId);
                DynamicObject superProjectRole = helper.queryOne("id", new QFilter[]{parentFilter, Q_FILTER_ENABLE, dutyPersonFilter});
                if (!HRObjectUtils.isEmpty((Object)superProjectRole)) {
                    this.getModel().setValue("superroles", (Object)superProjectRole.getLong("id"));
                }
            } else {
                Long projectRoleId = dutyPersonDy.getLong("id");
                this.getModel().setValue("superroles", (Object)projectRoleId);
            }
            DynamicObject project = this.getModel().getDataEntity().getDynamicObject("projteam");
            boolean isMainHead = this.getModel().getDataEntity().getBoolean("isdutypers");
            Long workRole = ProjectRoleBusiness.getSuperRole((boolean)isMainHead, (DynamicObject)project);
            this.getModel().setValue("superroles", (Object)workRole);
        }
    }

    private void setCooperationForm(Long id) {
        DynamicObject[] dynamicObjects;
        this.getView().setVisible(Boolean.FALSE, new String[]{"fs_baseinfo", "effectdate"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"attachmentpanelap"});
        if (id != 0L && (dynamicObjects = ReportingrelationQueryRepository.getInstance().queryNonAdministrativeRelationByDutyRoleIds4Page(Collections.singletonList(id))) != null && dynamicObjects.length > 0) {
            IDataModel dataModel = this.getModel();
            AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(REPORT_CORE_TYPE, new Object[0]);
            vs.addField("parent", new Object[0]);
            vs.addField("effectdate", new Object[0]);
            vs.addField("reportingrelboid", new Object[0]);
            vs.addField("reportingrelbsled", new Object[0]);
            vs.addField("id", new Object[0]);
            StringBuilder oldCoopInfoStr = new StringBuilder();
            Arrays.stream(dynamicObjects).forEach(dy -> {
                vs.addRow(new Object[]{dy.getLong("reportingtype.id"), dy.getLong("parent.id"), dy.getDate("bsed"), dy.getString("id"), dy.getDate("bsled"), dy.getLong("id")});
                oldCoopInfoStr.append(dy.getLong("id")).append(",").append(dy.getLong("reportingtype.id")).append(",").append(dy.getLong("parent.id")).append(";");
            });
            this.getPageCache().put("oldCoopInfo", oldCoopInfoStr.toString());
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        String changeType = (String)this.getView().getFormShowParameter().getCustomParam("source");
        if (HRStringUtils.equals((String)"save_change", (String)operateKey) || HRStringUtils.equals((String)"save_coop_change", (String)operateKey)) {
            boolean enable = this.getModel().getDataEntity().getBoolean("enable");
            if (!enable) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u53d8\u66f4\u5df2\u7981\u7528\u9879\u76ee\u89d2\u8272\u3002", (String)"ProjectRoleFormEditPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            this.checkCoopMustInput(args);
            this.checkCoopInfoChg(args, operateKey);
            if (!HRStringUtils.isEmpty((String)changeType)) {
                source.getOption().setVariableValue("changetype", changeType);
            }
            if (HRStringUtils.equals((String)"cooperationchange", (String)changeType)) {
                this.setModeEffectDate();
            }
        } else if (HRStringUtils.equals((String)"saveandadd", (String)operateKey) || HRStringUtils.equals((String)"save_donothing", (String)operateKey)) {
            this.checkCoopMustInput(args);
            if ((HRStringUtils.equals((String)"saveandadd", (String)operateKey) || HRStringUtils.equals((String)"new", (String)changeType)) && HRStringUtils.equals((String)"new", (String)changeType)) {
                this.setModeEffectDate();
            }
        } else if (HRStringUtils.equals((String)"save_donothing", (String)operateKey)) {
            this.updateCodeRuleModel();
        }
    }

    private void updateCodeRuleModel() {
        ProjectRoleCodeRuleModel model = this.getCodeRuleModel();
        String orgId = this.getModel().getDataEntity().getString("projteam.org.id");
        model.setOrgId(orgId);
        String[] currentNumbers = new String[]{this.getModel().getDataEntity().getString("number")};
        model.setCurrentNumbers(currentNumbers);
        this.getView().getPageCache().put(CODE_RULE_MODEL, SerializationUtils.toJsonString((Object)model));
    }

    private void checkCoopMustInput(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection pageCollection;
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ((HRStringUtils.equals((String)"saveandadd", (String)operateKey) || HRStringUtils.equals((String)"save_donothing", (String)operateKey) || HRStringUtils.equals((String)"save_coop_change", (String)operateKey)) && !ObjectUtils.isEmpty((Object)(pageCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity")))) {
            for (DynamicObject dyn : pageCollection) {
                if (dyn.getDynamicObject(REPORT_CORE_TYPE) != null && dyn.getDynamicObject("parent") != null) continue;
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u534f\u4f5c\u4fe1\u606f\u201d\u3002", (String)"ProjectRoleFormEditPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        }
    }

    private void checkCoopInfoChg(BeforeDoOperationEventArgs args, String operateKey) {
        if (HRStringUtils.equals((String)"save_coop_change", (String)operateKey)) {
            DynamicObjectCollection pageCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            StringBuilder newCoopInfoStr = new StringBuilder();
            pageCollection.forEach(dyn -> newCoopInfoStr.append(dyn.getLong("reportingrelboid")).append(",").append(dyn.getLong("reportcoreltype.id")).append(",").append(dyn.getLong("parent.id")).append(";"));
            String oldCoopInfo = this.getPageCache().get("oldCoopInfo");
            String string = oldCoopInfo = oldCoopInfo == null ? "" : oldCoopInfo;
            if (oldCoopInfo.equals(newCoopInfoStr.toString())) {
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u66f4\u6539\u9879\u76ee\u89d2\u8272\u534f\u4f5c\u5173\u7cfb\uff0c\u4e0d\u53ef\u4fdd\u5b58\u3002", (String)"ProjectRoleFormEditPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        }
    }

    private void setModeEffectDate() {
        this.getModel().getEntryEntity("entryentity").forEach(row -> row.set("effectdate", (Object)this.getModel().getDataEntity().getDate("bsed")));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setStatus(OperationStatus.EDIT);
        } else {
            this.getView().setStatus(status);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            this.getModel().setDataChanged(false);
            if (HRStringUtils.equals((String)"save_donothing", (String)operateKey) || HRStringUtils.equals((String)"save_change", (String)operateKey)) {
                if (this.isPageSourceRelateInfo()) {
                    this.afterDoOperation4RelateInfoNew();
                }
                this.getView().close();
            } else if (HRStringUtils.equals((String)"saveandadd", (String)operateKey)) {
                if (!this.isPageSourceRelateInfo()) {
                    this.getView().returnDataToParent((Object)"saveandadd");
                } else {
                    this.afterDoOperation4RelateInfoSaveAndNew();
                }
            }
            if ("save_donothing".equals(operateKey) || "save_change".equals(operateKey)) {
                this.saveAttachment(this.getView());
            }
        }
    }

    public void saveAttachment(IFormView view) {
        String attachmentCacheKey;
        Object pkId = view.getModel().getDataEntity().getPkValue();
        IPageCache cache = (IPageCache)view.getService(IPageCache.class);
        String cacheJsonString = cache.get(attachmentCacheKey = "TampAttCache" + view.getPageId());
        if (!StringUtils.isEmpty((CharSequence)cacheJsonString)) {
            String appId = view.getFormShowParameter().getFormConfig().getAppId();
            Map attachmentInfo = (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class);
            AttachmentServiceHelper.saveTempAttachments((String)"hbpm_projectrolesdetail", (Object)pkId, (String)appId, (Map)attachmentInfo);
            cache.put(attachmentCacheKey, "");
        }
    }

    public void pageRelease(EventObject e) {
        this.recycleNumber();
    }

    private void recycleNumber() {
        ProjectRoleCodeRuleHelper.recycleNumber((ProjectRoleCodeRuleModel)this.getCodeRuleModel(), (!this.isSaveSuccess() ? 1 : 0) != 0);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("isdutypers".equals(name)) {
            Boolean isMainHead = (Boolean)e.getChangeSet()[0].getNewValue();
            DynamicObject project = this.getModel().getDataEntity().getDynamicObject("projteam");
            Long workRole = ProjectRoleBusiness.getSuperRole((boolean)isMainHead, (DynamicObject)project);
            this.getModel().setValue("superroles", (Object)workRole);
            this.getModel().setValue("rolestype", (Object)ProjectRoleBusiness.getRoleTypeDynByMainHead((Boolean)isMainHead));
        } else if ("design".equals(name)) {
            this.getModel().setValue("bsed", newValue);
        } else if ("projteam".equals(name) && newValue != null) {
            this.getModel().setValue("org", ((DynamicObject)newValue).get("org"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject projectRole;
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (REPORT_CORE_TYPE.equals(fieldKey)) {
            DynamicObject projectRole2 = this.getModel().getDataEntity(true);
            DynamicObject pj = projectRole2.getDynamicObject("projteam");
            QFilter qFilter = PRJRoleUtils.getOrgTeamTypeFilter((DynamicObject)pj, (String)"hbpm_reportcoreltype", (String)"orgteamtype.fbasedataid", (Long)1020L);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter);
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "!=", (Object)1010L));
        } else if ("changereason".equals(fieldKey)) {
            DynamicObject projectRole3 = this.getModel().getDataEntity(true);
            DynamicObject pj = projectRole3.getDynamicObject("projteam");
            if (pj == null) {
                String kdString = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6240\u5c5e\u9879\u76ee\u56e2\u961f\u201d\u3002", (String)"ProjectRoleFormEditPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getModel().setValue("changereason", null);
                throw new KDBizException(kdString);
            }
        } else if ("parent".equals(fieldKey)) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("rolesourcetype", "!=", (Object)ROLE_SOURCE_ADMIN));
        } else if ("superroles".equals(fieldKey) && (projectRole = this.getModel().getDataEntity(true)) != null) {
            QFilter qFilter = new QFilter("boid", "!=", (Object)projectRole.getLong("id"));
            beforeF7SelectEvent.getCustomQFilters().add(qFilter);
        }
    }

    private void afterBindData4New() {
        Date nowDate = new Date();
        this.getModel().setValue("bsed", (Object)nowDate);
        this.getModel().setValue("design", (Object)nowDate);
        Boolean isMainHead = (Boolean)this.getModel().getValue("isdutypers");
        this.getModel().setValue("rolestype", (Object)ProjectRoleBusiness.getRoleTypeDynByMainHead((Boolean)isMainHead));
        this.getModel().setDataChanged(false);
        this.setNumberFromCodeRule();
    }

    private void setNumberFromCodeRule() {
        ProjectRoleCodeRuleModel codeRuleModel = this.getCodeRuleModel();
        if (ProjectRoleCodeRuleHelper.isExist((ProjectRoleCodeRuleModel)codeRuleModel)) {
            String[] batchNumber = this.getAndCacheNumber(codeRuleModel);
            this.getModel().setValue("number", (Object)batchNumber[0]);
        }
    }

    private String[] getAndCacheNumber(ProjectRoleCodeRuleModel codeRuleModel) {
        String[] batchNumber = ProjectRoleCodeRuleHelper.getBatchNumber((ProjectRoleCodeRuleModel)codeRuleModel, (int)1);
        codeRuleModel.setNumbers(batchNumber);
        this.getView().getPageCache().put(CODE_RULE_MODEL, SerializationUtils.toJsonString((Object)codeRuleModel));
        return batchNumber;
    }

    private boolean isPageSourceRelateInfo() {
        return "relate_info_new".equals(this.getView().getFormShowParameter().getCustomParam("source"));
    }

    private void afterBindData4RelateInfoNew() {
        this.afterBindData4New();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"projteam"});
    }

    private void afterDoOperation4RelateInfoSaveAndNew() {
        this.getView().returnDataToParent((Object)"save_new_Success");
    }

    private void afterDoOperation4RelateInfoNew() {
        this.getView().returnDataToParent((Object)"new_success");
    }

    private ProjectRoleCodeRuleModel getCodeRuleModel() {
        if (this.codeRuleModel != null) {
            return this.codeRuleModel;
        }
        String modelJsonStr = this.getView().getPageCache().get(CODE_RULE_MODEL);
        if (StringUtils.isNotEmpty((CharSequence)modelJsonStr)) {
            this.codeRuleModel = (ProjectRoleCodeRuleModel)SerializationUtils.fromJsonString((String)modelJsonStr, ProjectRoleCodeRuleModel.class);
        } else {
            this.codeRuleModel = new ProjectRoleCodeRuleModel();
            this.codeRuleModel.setEntityNumber("hbpm_projectrolesdetail");
            this.codeRuleModel.setOrgId("0");
            this.codeRuleModel.setNumbers(null);
            this.getView().getPageCache().put(CODE_RULE_MODEL, SerializationUtils.toJsonString((Object)this.codeRuleModel));
        }
        return this.codeRuleModel;
    }

    private boolean isSaveSuccess() {
        return this.getView().getPageCache().get(SAVE_OP_SUCCESS) != null;
    }

    static {
        REGISTER_BEFORE_F7_LISTENER.add(REPORT_CORE_TYPE);
        REGISTER_BEFORE_F7_LISTENER.add("changereason");
        REGISTER_BEFORE_F7_LISTENER.add("parent");
        REGISTER_BEFORE_F7_LISTENER.add("superroles");
    }
}

