/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.formplugin.web.projectrole;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hbpm.business.service.projectrole.ProjectRoleBusiness;
import kd.hrmp.hbpm.business.utils.PRJRoleUtils;
import kd.hrmp.hbpm.business.utils.PermHelper;
import kd.hrmp.hbpm.business.utils.PrjRolePermUtils;

public class ProjectRoleListPlugin
extends HRDataBaseList {
    protected static final Log logger = LogFactory.getLog(ProjectRoleListPlugin.class);

    public void filterColumnSetFilter(SetFilterEvent event) {
        super.filterColumnSetFilter(event);
        String fieldName = event.getFieldName();
        if ("projteam.name".equals(fieldName)) {
            QFilter permFilter = new QFilter("1", "=", (Object)1);
            Optional.ofNullable(PrjRolePermUtils.getDataRuleForBdProp((String)"projteam")).ifPresent(arg_0 -> ((QFilter)permFilter).and(arg_0));
            HasPermOrgResult hrPermOrg = this.getOrgPermResult();
            Optional.of(hrPermOrg).filter(orgPermResult -> !orgPermResult.hasAllOrgPerm()).ifPresent(orgPermResult -> permFilter.and("org", "in", (Object)orgPermResult.getHasPermOrgs()));
            Map customQFilterMap = null;
            String hisCustomQFilters = this.getPageCache().get("hisCustomQFilters");
            customQFilterMap = HRStringUtils.isNotEmpty((String)hisCustomQFilters) ? (Map)SerializationUtils.fromJsonString((String)hisCustomQFilters, Map.class) : Maps.newHashMapWithExpectedSize((int)16);
            event.getCustomQFilters().add(permFilter);
            ArrayList customQFilters = Lists.newArrayListWithCapacity((int)10);
            customQFilters.add(permFilter.toSerializedString());
            customQFilterMap.put(fieldName, customQFilters);
            this.getPageCache().put("hisCustomQFilters", SerializationUtils.toJsonString(customQFilterMap));
        }
    }

    private HasPermOrgResult getOrgPermResult() {
        return PermHelper.getHRPermOrg((String)"hbpm_projectrolesdetail");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        Long proRoleId = 0L;
        if (!ObjectUtils.isEmpty((Object)listSelectedData)) {
            proRoleId = (Long)listSelectedData.get(0).getPrimaryKeyValue();
        }
        switch (operateKey) {
            case "reportingrelchange": {
                if (listSelectedData.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u53d8\u66f4\u4e00\u4e2a\u9879\u76ee\u89d2\u8272\u534f\u52a9\u5173\u7cfb\u3002", (String)"ProjectRoleListPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (!this.doMutex(args, listSelectedData.get(0).getPrimaryKeyValue().toString(), "change_donothing").booleanValue()) break;
                if (this.isProjectRoleEnable(proRoleId)) {
                    this.showProjectRoleForm(listSelectedData, "cooperationchange");
                    break;
                }
                this.showChangeDisableDataCoopRelTips();
                args.setCancel(true);
                break;
            }
            case "change": {
                if (listSelectedData.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u53d8\u66f4\u64cd\u4f5c\u201d\u4ec5\u652f\u6301\u5355\u9009\u3002", (String)"ProjectRoleListPlugin_1", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (!this.doMutex(args, listSelectedData.get(0).getPrimaryKeyValue().toString(), "change_donothing").booleanValue()) break;
                if (this.isProjectRoleEnable(proRoleId)) {
                    this.showProjectRoleForm(listSelectedData, "modify");
                    break;
                }
                this.showChangeDisableDataInfoTips();
                args.setCancel(true);
                break;
            }
            case "importroleplan": {
                this.showRolePlanForm();
                break;
            }
            case "btndisable": {
                List selectIds = this.getSelectedRows().stream().map(x -> (Long)x.getPrimaryKeyValue()).collect(Collectors.toList());
                if (!PRJRoleUtils.checkCanDisable(selectIds)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"ProjectRoleListPlugin_2", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                this.showDisableInfoForm(listSelectedData);
                break;
            }
            case "new": {
                args.setCancel(true);
                if (this.checkCurNodeIsProjectTeam()) {
                    this.showNewProjectRoleForm();
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728\u884c\u653f\u7ec4\u7ec7\u4e0b\u65e0\u6cd5\u65b0\u589e\u89d2\u8272\uff0c\u8bf7\u68c0\u67e5\u9009\u4e2d\u6570\u636e\u540e\u518d\u8bd5\u3002", (String)"ProjectRoleListPlugin_5", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private boolean checkCurNodeIsProjectTeam() {
        ListView view = (ListView)this.getView();
        String currentNodeId = (String)view.getTreeListView().getTreeModel().getCurrentNodeId();
        ArrayList inParam = new ArrayList();
        HashMap<String, Comparable<Long>> pjtQueryParam = new HashMap<String, Comparable<Long>>();
        inParam.add(pjtQueryParam);
        pjtQueryParam.put("projectGroupId", Long.valueOf(currentNodeId));
        pjtQueryParam.put("checkTime", HRDateTimeUtils.getNowDate());
        List result = null;
        try {
            result = (List)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSProjectGroupService", (String)"getInfoByIdAndTime", (Object[])new Object[]{inParam});
            if (logger.isInfoEnabled()) {
                logger.info(String.format("checkCurNodeIsProjectTeam result: %s", result));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
        return result.size() != 0;
    }

    private boolean isProjectRoleEnable(Long proRoleId) {
        return PRJRoleUtils.checkIsEnable((Long)proRoleId);
    }

    private void showChangeDisableDataInfoTips() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u53d8\u66f4\u5df2\u7981\u7528\u7684\u9879\u76ee\u89d2\u8272\u4fe1\u606f\u3002", (String)"ProjectRoleListPlugin_3", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
    }

    private void showChangeDisableDataCoopRelTips() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u53d8\u66f4\u5df2\u7981\u7528\u7684\u9879\u76ee\u89d2\u8272\u534f\u4f5c\u5173\u7cfb\u3002", (String)"ProjectRoleListPlugin_4", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
    }

    private Boolean doMutex(BeforeDoOperationEventArgs args, String pkId, String opKey) {
        String entityId = "hbpm_projectrolesdetail";
        StringBuilder errMsg = new StringBuilder();
        if (!MutexHelper.require((String)entityId, (Object)pkId, (String)opKey, (boolean)true, (StringBuilder)errMsg)) {
            args.setCancel(true);
            this.getView().showTipNotification(errMsg.toString());
            return false;
        }
        return true;
    }

    private void showNewProjectRoleForm() {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setStatus(OperationStatus.ADDNEW);
        Object currentNodeId = this.getCurrentNodeId();
        if (currentNodeId != null && ProjectRoleBusiness.checkPermWithDataAndBU((Object)currentNodeId)) {
            showParameter.setCustomParam("projteam", currentNodeId);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "new"));
        showParameter.setFormId("hbpm_projectrolesdetail");
        showParameter.setCustomParam("source", (Object)"new");
        showParameter.setCustomParam("ue_param", (Object)"true");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showDisableInfoForm(ListSelectedRowCollection listSelectedData) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hbpm_disableinfo");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "disable"));
        Map<Long, String> idNameMap = listSelectedData.stream().collect(Collectors.toMap(k -> (Long)k.getPrimaryKeyValue(), ListSelectedRow::getName));
        showParameter.setCustomParam("idNameMap", idNameMap);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showRolePlanForm() {
        BaseShowParameter showParameter = new BaseShowParameter();
        Object currentNodeId = this.getCurrentNodeId();
        if (currentNodeId != null && ProjectRoleBusiness.checkPermWithDataAndBU((Object)currentNodeId)) {
            showParameter.setCustomParam("projteam", currentNodeId);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importroleplan"));
        showParameter.setFormId("hbpm_importrolesplan");
        showParameter.setHasRight(true);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showProjectRoleForm(ListSelectedRowCollection listSelectedData, String source) {
        ListSelectedRow listSelectedRow = listSelectedData.get(0);
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("hbpm_projectrolesdetail");
        showParameter.setPkId(listSelectedRow.getPrimaryKeyValue());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("source", (Object)source);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, source));
        showParameter.setCustomParam("ue_param", (Object)"true");
        showParameter.setCustomParam("force_set_caption", (Object)"true");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)"disable", (String)actionId)) {
            this.getView().invokeOperation("refresh");
        }
        if (HRStringUtils.equals((String)"new", (String)actionId) || HRStringUtils.equals((String)actionId, (String)"modify") || "importroleplan".equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null && HRStringUtils.equals((String)"saveandadd", (String)returnData.toString())) {
                this.showNewProjectRoleForm();
            }
            ((BillList)this.getView().getControl("billlistap")).refresh();
        }
    }

    private Object getCurrentNodeId() {
        ListView view = (ListView)this.getView();
        ITreeListView treeListView = view.getTreeListView();
        if (treeListView != null) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_projteambaseinfo");
            Object currentNodeId = treeListView.getTreeModel().getCurrentNodeId();
            if (currentNodeId == null) {
                return null;
            }
            boolean exists = helper.isExists(currentNodeId);
            if (exists) {
                return currentNodeId;
            }
        }
        return null;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        this.getView().getFormShowParameter().setCustomParam("source", (Object)"detail");
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setCustomParam("ue_param", (Object)"true");
        e.getParameter().setCustomParam("force_set_caption", (Object)"true");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "enable_donothing": {
                if (afterDoOperationEventArgs.getOperationResult() == null || !afterDoOperationEventArgs.getOperationResult().isSuccess() && CollectionUtils.isEmpty((Collection)afterDoOperationEventArgs.getOperationResult().getSuccessPkIds())) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }
}

