/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.formplugin.web.projectrole.basedata;

import java.text.MessageFormat;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;

public class RolePlanEditPlugin
extends HRDataBaseEdit
implements ProjectRoleConstants {
    private static final String DEFAULT_PLAN = "defaultPlan";
    private static final HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_roleplan");
    private static final String IS_MAIN_HEAD = "ismainhead";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long id = (Long)this.getModel().getValue("id");
        if (id == 0L) {
            this.getModel().deleteEntryRow("roleentryentity", 0);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"donothing")) {
            String caption = ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272\u6a21\u677f", (String)"RolePlanEditPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]);
            ListShowParameter listFormShowParameter = new ListShowParameter();
            OpenStyle openStyle = listFormShowParameter.getOpenStyle();
            openStyle.setShowType(ShowType.Modal);
            StyleCss styleCss = new StyleCss();
            styleCss.setHeight("620px");
            styleCss.setWidth("960px");
            openStyle.setInlineStyleCss(styleCss);
            listFormShowParameter.setLookUp(true);
            listFormShowParameter.setShowTitle(false);
            listFormShowParameter.setMultiSelect(true);
            listFormShowParameter.setBillFormId("hbpm_rolelibrary");
            listFormShowParameter.setFormId("bos_listf7");
            listFormShowParameter.setCaption(caption);
            QFilter filter = new QFilter("otclassify", "=", (Object)1020L).and("enable", "=", (Object)"1");
            listFormShowParameter.getListFilterParameter().setFilter(filter);
            listFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "add_role"));
            this.getView().showForm((FormShowParameter)listFormShowParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (HRStringUtils.equals((String)"isdefaultplan", (String)name)) {
            DynamicObject plan;
            boolean isDefaultPlan = (Boolean)this.getModel().getValue("isdefaultplan");
            if (isDefaultPlan && (plan = this.getDefaultPlan()) != null) {
                ConfirmCallBackListener listener = new ConfirmCallBackListener(DEFAULT_PLAN, (IFormPlugin)this);
                String msg = MessageFormat.format(ResManager.loadKDString((String)"\u76ee\u524d\u5df2\u5b58\u5728\u9ed8\u8ba4\u65b9\u6848\u201c{0}\u201d\uff0c\u662f\u5426\u628a\u5b83\u8bbe\u7f6e\u4e3a\u975e\u9ed8\u8ba4\u65b9\u6848\uff1f", (String)"RolePlanEditPlugin_1", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]), plan.getString("name"));
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, listener);
            }
        } else if (HRStringUtils.equals((String)IS_MAIN_HEAD, (String)name)) {
            this.mainHead();
        }
    }

    private void mainHead() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("roleentryentity");
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("roleentryentity");
        boolean currentIsMainHead = this.getModel().getEntryRowEntity("roleentryentity", currentRowIndex).getBoolean(IS_MAIN_HEAD);
        if (currentIsMainHead) {
            int rowCount = this.getModel().getEntryRowCount("roleentryentity");
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject dynamicObject;
                boolean isMainHead;
                if (i == currentRowIndex || !(isMainHead = (dynamicObject = (DynamicObject)entry.get(i)).getBoolean(IS_MAIN_HEAD))) continue;
                dynamicObject.set(IS_MAIN_HEAD, (Object)"0");
                this.getView().updateView("roleentryentity");
                break;
            }
        }
    }

    private DynamicObject getDefaultPlan() {
        QFilter filter = new QFilter("enable", "=", (Object)"1").and(new QFilter("otclassify", "=", (Object)1020L)).and(new QFilter("isdefaultplan", "=", (Object)"1")).and(new QFilter("id", "!=", this.getModel().getValue("id")));
        return helper.queryOne("id,name,isdefaultplan", filter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (HRStringUtils.equals((String)callBackId, (String)DEFAULT_PLAN) && MessageBoxResult.Cancel.equals((Object)result)) {
            this.getModel().setValue("isdefaultplan", (Object)false);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("add_role".equals(actionId) && null != (returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) && returnData.size() > 0) {
            Object[] roleIds = returnData.getPrimaryKeyValues();
            IDataModel dataModel = this.getModel();
            AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("role", new Object[0]);
            for (Object roleId : roleIds) {
                vs.addRow(new Object[]{roleId});
            }
            model.batchCreateNewEntryRow("roleentryentity", vs);
            model.endInit();
            this.getView().updateView("roleentryentity");
        }
    }
}

