/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.formplugin.web.standardposition;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hbpm.business.domain.repository.position.StandardPositionRepository;
import kd.hrmp.hbpm.business.utils.JobLevelGradeRangeUtil;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class StandardPositionEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    public static final String UID = "uid";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"attachmentpanelap"});
        JobLevelGradeRangeUtil.getInstance().registerListener(this.getView(), (AbstractFormPlugin)this, (BeforeF7SelectListener)this);
        BasedataEdit positiontype = (BasedataEdit)this.getView().getControl("positiontype");
        positiontype.setF7BatchFill(false);
        positiontype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        String showBsed;
        super.beforeBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String enable = (String)this.getModel().getValue("enable");
        if (HRStringUtils.equals((String)"10", (String)enable)) {
            view.setStatus(OperationStatus.VIEW);
            view.setVisible(Boolean.valueOf(true), new String[]{"bar_modify"});
        }
        JobLevelGradeRangeUtil.getInstance().afterBindData(model, view);
        String option = (String)this.getView().getFormShowParameter().getCustomParam("option");
        if (!HRStringUtils.equals((String)option, (String)"showhisversion")) {
            this.getModel().beginInit();
            this.getModel().setValue("bsed", (Object)HRDateTimeUtils.truncateDate((Date)new Date()));
            this.getModel().endInit();
        }
        if ("false".equals(showBsed = (String)this.getView().getFormShowParameter().getCustomParam("showBsed"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bsed"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bsed"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.buttonVisibleAfterBindData();
        this.updateUidIntoCache();
    }

    protected void buttonVisibleAfterBindData() {
        boolean statusFlag;
        String enable = (String)this.getModel().getValue("enable");
        if (!HRStringUtils.equals((String)"1", (String)enable)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"insertdatabtn"});
            this.getView().updateView("insertdatabtn");
        }
        boolean isAudit = HRBaseDataConfigUtil.getAudit((String)"hbpm_stposition");
        String status = (String)this.getModel().getValue("status");
        boolean bl = statusFlag = HRStringUtils.equals((String)"C", (String)status) || HRStringUtils.equals((String)"B", (String)status);
        if (statusFlag && isAudit) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
            this.getView().updateView("bar_modify");
            this.getView().getModel().setDataChanged(false);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs arg) {
        super.preOpenForm(arg);
        FormShowParameter formShowParameter = arg.getFormShowParameter();
        formShowParameter.setCustomParam("showBsed", (Object)"true");
        if (formShowParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            String name = ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d-\u65b0\u589e", (String)"StandardPositionEdit_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]);
            if (HRStringUtils.equals((String)formShowParameter.getParentFormId(), (String)"hbpm_stposition")) {
                name = ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d-\u53d8\u66f4", (String)"StandardPositionEdit_1", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]);
            }
            arg.getFormShowParameter().setCaption(name);
            return;
        }
        if (formShowParameter instanceof BaseShowParameter) {
            Object pkId = ((BaseShowParameter)formShowParameter).getPkId();
            if (Objects.isNull(pkId) || !(pkId instanceof Long)) {
                return;
            }
            Object[] dynamicObjects = StandardPositionRepository.getInstance().queryAllStandardPosition(Collections.singletonList((Long)pkId));
            if (!PositionUtils.isArrayEmpty((Object[])dynamicObjects).booleanValue()) {
                String name = ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d-", (String)"StandardPositionEdit_2", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]);
                arg.getFormShowParameter().setCaption(name + dynamicObjects[0].getString("name"));
                formShowParameter.setCustomParam("showBsed", (Object)"false");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        PositionUtils.reNameF7Capture((String)"hbpm_stposition", (String)",job,", (BeforeF7SelectEvent)evt);
        JobLevelGradeRangeUtil.getInstance().beforeF7Select(evt, model, view);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String operationKey = args.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        JobLevelGradeRangeUtil.getInstance().propertyChanged(model, view, operationKey);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String operationKey = source.getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        JobLevelGradeRangeUtil.getInstance().click(model, view, operationKey, (IFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        IDataModel model = this.getModel();
        JobLevelGradeRangeUtil.getInstance().closedCallBack(model, returnData, actionId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        String confirmShow = this.getPageCache().get("confirmShow");
        if (!HRStringUtils.equals((String)confirmShow, (String)"1") && (HRStringUtils.equals((String)operateKey, (String)"confirmchangenoaudit") || HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"confirmchange")) && !this.getModel().getDataChanged() && this.isAttachUnChanged()) {
            if (HRStringUtils.equals((String)operateKey, (String)"confirmchangenoaudit")) {
                this.getPageCache().put("confirmShow", "1");
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u4fe1\u606f\u53d8\u66f4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"StandardPositionEdit_3", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (HRStringUtils.equals((String)"modify", (String)operateKey)) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_modify"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bsed"});
        }
        if (HRStringUtils.equals((String)"insertdata_his", (String)operateKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bsed"});
        }
    }

    private String getAttachUid() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        List uid = attachmentPanel.getAttachmentData().stream().map(map -> map.get(UID).toString() + map.get("name") + map.get("description")).collect(Collectors.toList());
        return String.join((CharSequence)",", uid);
    }

    private void updateUidIntoCache() {
        this.getView().getPageCache().put(UID, this.getAttachUid());
    }

    private boolean isAttachUnChanged() {
        String oldUid = this.getView().getPageCache().get(UID);
        return HRStringUtils.equals((String)oldUid, (String)this.getAttachUid());
    }

    public void beforeImportData(BeforeImportDataEventArgs args) {
        super.beforeImportData(args);
        Map sourceData = args.getSourceData();
        DynamicObject dy = this.getModel().getDataEntity();
        JobLevelGradeRangeUtil.getInstance().beforeImportData(dy, sourceData);
    }

    public void afterImportData(ImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        DynamicObject ob = this.getModel().getDataEntity();
        if (!(ob == null || sourceData != null && sourceData.containsKey("bsed"))) {
            ob.set("bsed", (Object)HRDateTimeUtils.truncateDate((Date)new Date()));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        boolean isSuccess;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (("confirmchange".equals(operateKey) || "confirmchangenoaudit".equals(operateKey) || HRStringUtils.equals((String)operateKey, (String)"save")) && (isSuccess = afterDoOperationEventArgs.getOperationResult().isSuccess())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"insertdatabtn", "hisversionbtn", "bar_revise", "bsed"});
            this.getView().updateView("tbmain");
            Container toolBar = (Container)this.getView().getControl("tbmain");
            toolBar.deleteControls(new String[]{"insertdatabtn", "confirmchange", "confirmchangenoaudit", "versionchangecomparebtn", "deletehisbtn", "bar_hisinfo"});
        }
    }
}

