/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.mservice.position;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidatePriority;
import kd.hrmp.hbpm.business.application.impl.position.DarkPositionApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.position.IPositionServiceApplication;
import kd.hrmp.hbpm.opplugin.web.position.PositionMServiceOp;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionHisLoopValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionJobRelationValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionStatusValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionSubValidator;

public class PositionMServiceSaveOp
extends PositionMServiceOp {
    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        new PositionServiceApplicationImpl().setMustInputFieldDefaultValue(e.getDataEntities());
        super.onAddValidators(e);
    }

    @Override
    protected void registerValidators() {
        this.validatorHandler.registerValidator((AbstractValidator)new PositionStatusValidator("save"));
        this.validatorHandler.registerValidator((AbstractValidator)new PositionJobRelationValidator());
        this.validatorHandler.registerValidator((AbstractValidator)new PositionHisLoopValidator(null, "id").checkMemory());
        PositionSubValidator positionSubValidator = new PositionSubValidator(null);
        positionSubValidator.setValidatePriority(ValidatePriority.Last);
        this.validatorHandler.registerValidator((AbstractValidator)positionSubValidator);
    }

    @Override
    protected void doSavePositions(IPositionServiceApplication positionServiceApplication, List<DynamicObject> positions) {
        Map result = positionServiceApplication.savePosition(positions, null);
        List hisVersions = (List)result.get("hisVersions");
        List enabledPositions = hisVersions.stream().filter(pos -> "1".equals(pos.getString("enable"))).collect(Collectors.toList());
        DarkPositionApplicationImpl darkPositionApplication = new DarkPositionApplicationImpl();
        darkPositionApplication.maintainDarkPositionRelation(enabledPositions, false, false);
    }
}

