/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.opplugin.web.position;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hbpm.business.domain.repository.position.HBPMMsgRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeMsgServiceImpl;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionChangeMsgValidator;

public class PositionChangeMsgOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add("sendstate");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new PositionChangeMsgValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        super.beginOperationTransaction(evt);
        if (evt.getOperationKey().equals("retrysend")) {
            DynamicObject[] msgs = evt.getDataEntities();
            List msgIds = Arrays.stream(msgs).map(msg -> msg.getLong("id")).collect(Collectors.toList());
            DynamicObject[] retryMsgs = HBPMMsgRepository.getInstance().queryRetryMsgsById(msgIds);
            ChangeMsgServiceImpl msgService = new ChangeMsgServiceImpl();
            for (DynamicObject msg2 : retryMsgs) {
                if (!HRStringUtils.isEmpty((String)msg2.getString("msgparams"))) continue;
                msg2.set("msgparams", (Object)msgService.getMsgParams(msg2));
            }
            msgService.retrySend(retryMsgs);
        }
    }
}

